/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.core.util.LinkFileMap;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;
import org.gudy.azureus2.ui.swt.shells.AdvRenameWindow;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class FilesViewMenuUtil {
    public static final Object PRIORITY_HIGH = new Object();
    public static final Object PRIORITY_NORMAL = new Object();
    public static final Object PRIORITY_LOW = new Object();
    public static final Object PRIORITY_NUMERIC = new Object();
    public static final Object PRIORITY_NUMERIC_AUTO = new Object();
    public static final Object PRIORITY_SKIPPED = new Object();
    public static final Object PRIORITY_DELETE = new Object();

    public static void fillMenu(final TableView<?> tv, final Menu menu, final DownloadManager[] manager_list, final DiskManagerFileInfo[][] files_list) {
        Shell shell = menu.getShell();
        final ArrayList<DiskManagerFileInfo> all_files = new ArrayList<DiskManagerFileInfo>();
        for (DiskManagerFileInfo[] files : files_list) {
            all_files.addAll(Arrays.asList(files));
        }
        boolean hasSelection = all_files.size() > 0;
        MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText(itemOpen, "FilesView.menu.open");
        Utils.setMenuItemImage(itemOpen, "run");
        menu.setDefaultItem(itemOpen);
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText(itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                for (int i = all_files.size() - 1; i >= 0; --i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)all_files.get(i);
                    if (info == null) continue;
                    ManagerUtils.open(info, use_open_containing_folder);
                }
            }
        });
        itemExplore.setEnabled(hasSelection);
        Menu menuBrowse = new Menu(menu.getShell(), 4);
        MenuItem itemBrowse = new MenuItem(menu, 64);
        Messages.setLanguageText(itemBrowse, "MyTorrentsView.menu.browse");
        itemBrowse.setMenu(menuBrowse);
        MenuItem itemBrowsePublic = new MenuItem(menuBrowse, 8);
        itemBrowsePublic.setText(MessageText.getString("label.public") + "...");
        itemBrowsePublic.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                for (int i = all_files.size() - 1; i >= 0; --i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)all_files.get(i);
                    if (info == null) continue;
                    ManagerUtils.browse(info, false, true);
                }
            }
        });
        MenuItem itemBrowseAnon = new MenuItem(menuBrowse, 8);
        itemBrowseAnon.setText(MessageText.getString("label.anon") + "...");
        itemBrowseAnon.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                for (int i = all_files.size() - 1; i >= 0; --i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)all_files.get(i);
                    if (info == null) continue;
                    ManagerUtils.browse(info, true, true);
                }
            }
        });
        new MenuItem(menuBrowse, 2);
        MenuItem itemBrowseURL = new MenuItem(menuBrowse, 8);
        Messages.setLanguageText(itemBrowseURL, "label.copy.url.to.clip");
        itemBrowseURL.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                Utils.getOffOfSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        String url = ManagerUtils.browse((DiskManagerFileInfo)all_files.get(0), true, false);
                        if (url != null) {
                            ClipboardCopy.copyToClipBoard(url);
                        }
                    }
                });
            }
        });
        itemBrowseURL.setEnabled(all_files.size() == 1);
        menuBrowse.setEnabled(hasSelection);
        MenuItem itemRenameOrRetarget = null;
        MenuItem itemRename = null;
        MenuItem itemRetarget = null;
        itemRenameOrRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText(itemRenameOrRetarget, "FilesView.menu.rename");
        itemRenameOrRetarget.setData("rename", true);
        itemRenameOrRetarget.setData("retarget", true);
        itemRename = new MenuItem(menu, 8);
        Messages.setLanguageText(itemRename, "FilesView.menu.rename_only");
        itemRename.setData("rename", true);
        itemRename.setData("retarget", false);
        itemRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText(itemRetarget, "FilesView.menu.retarget");
        itemRetarget.setData("rename", false);
        itemRetarget.setData("retarget", true);
        MenuItem itemRevertFiles = new MenuItem(menu, 8);
        Messages.setLanguageText(itemRevertFiles, "MyTorrentsView.menu.revertfiles");
        MenuItem itemLocateFiles = new MenuItem(menu, 8);
        Messages.setLanguageText(itemLocateFiles, "MyTorrentsView.menu.locatefiles");
        MenuItem itemfindMore = new MenuItem(menu, 8);
        Messages.setLanguageText(itemfindMore, "MyTorrentsView.menu.findmorelikethis");
        MenuItem itemClearLinks = null;
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode > 1) {
            itemClearLinks = new MenuItem(menu, 8);
            Messages.setLanguageText(itemClearLinks, "FilesView.menu.clear.links");
        }
        final MenuItem itemQuickView = new MenuItem(menu, 32);
        Messages.setLanguageText(itemQuickView, "MainWindow.menu.quick_view");
        itemQuickView.setEnabled(all_files.size() == 1 && Utils.isQuickViewSupported((DiskManagerFileInfo)all_files.get(0)));
        itemQuickView.setSelection(all_files.size() == 1 && Utils.isQuickViewActive((DiskManagerFileInfo)all_files.get(0)));
        itemQuickView.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg) {
                Utils.setQuickViewActive((DiskManagerFileInfo)all_files.get(0), itemQuickView.getSelection());
            }
        });
        if (manager_list.length == 1) {
            MenuFactory.addAlertsMenu(menu, manager_list[0], files_list[0]);
        }
        MenuItem itemPersonalShare = new MenuItem(menu, 8);
        Messages.setLanguageText(itemPersonalShare, "MyTorrentsView.menu.create_personal_share");
        MenuItem itemPriority = new MenuItem(menu, 64);
        Messages.setLanguageText(itemPriority, "FilesView.menu.setpriority");
        Menu menuPriority = new Menu(shell, 4);
        itemPriority.setMenu(menuPriority);
        MenuItem itemHigh = new MenuItem(menuPriority, 64);
        itemHigh.setData("Priority", PRIORITY_HIGH);
        Messages.setLanguageText(itemHigh, "FilesView.menu.setpriority.high");
        MenuItem itemNormal = new MenuItem(menuPriority, 64);
        itemNormal.setData("Priority", PRIORITY_NORMAL);
        Messages.setLanguageText(itemNormal, "FilesView.menu.setpriority.normal");
        MenuItem itemLow = new MenuItem(menuPriority, 64);
        itemLow.setData("Priority", PRIORITY_LOW);
        Messages.setLanguageText(itemLow, "FileItem.low");
        MenuItem itemNumeric = new MenuItem(menuPriority, 64);
        itemNumeric.setData("Priority", PRIORITY_NUMERIC);
        Messages.setLanguageText(itemNumeric, "FilesView.menu.setpriority.numeric");
        MenuItem itemNumericAuto = new MenuItem(menuPriority, 64);
        itemNumericAuto.setData("Priority", PRIORITY_NUMERIC_AUTO);
        Messages.setLanguageText(itemNumericAuto, "FilesView.menu.setpriority.numeric.auto");
        MenuItem itemSkipped = new MenuItem(menuPriority, 64);
        itemSkipped.setData("Priority", PRIORITY_SKIPPED);
        Messages.setLanguageText(itemSkipped, "FilesView.menu.setpriority.skipped");
        MenuItem itemDelete = new MenuItem(menuPriority, 64);
        itemDelete.setData("Priority", PRIORITY_DELETE);
        Messages.setLanguageText(itemDelete, "wizard.multitracker.delete");
        new MenuItem(menu, 2);
        if (!hasSelection) {
            itemOpen.setEnabled(false);
            itemPriority.setEnabled(false);
            itemRenameOrRetarget.setEnabled(false);
            itemRename.setEnabled(false);
            itemRetarget.setEnabled(false);
            itemLocateFiles.setEnabled(false);
            itemfindMore.setEnabled(false);
            if (itemClearLinks != null) {
                itemClearLinks.setEnabled(false);
            }
            itemPersonalShare.setEnabled(false);
            return;
        }
        boolean all_persistent = true;
        boolean open = true;
        boolean all_compact = true;
        boolean all_dnd_not_deleted = true;
        boolean all_high_pri = true;
        boolean all_normal_pri = true;
        boolean all_low_pri = true;
        boolean all_complete = true;
        boolean any_relocated = false;
        final ArrayList<DiskManagerFileInfo> files_with_links = new ArrayList<DiskManagerFileInfo>();
        for (int j = 0; j < manager_list.length; ++j) {
            DownloadManager manager = manager_list[j];
            int dm_file_count = manager.getNumFileInfos();
            if (!manager.isPersistent()) {
                all_persistent = false;
            }
            DiskManagerFileInfo[] files = files_list[j];
            DownloadManagerState dm_state = manager.getDownloadState();
            int[] storage_types = manager.getStorageType(files);
            for (int i = 0; i < files.length; ++i) {
                File target;
                boolean isCompact;
                DiskManagerFileInfo file_info = files[i];
                if (open && file_info.getAccessMode() != 1) {
                    open = false;
                }
                boolean bl = isCompact = storage_types[i] == 2 || storage_types[i] == 4;
                if (all_compact && !isCompact) {
                    all_compact = false;
                }
                if (all_dnd_not_deleted || all_high_pri || all_normal_pri || all_low_pri) {
                    if (file_info.isSkipped()) {
                        all_low_pri = false;
                        all_normal_pri = false;
                        all_high_pri = false;
                        if (isCompact) {
                            all_dnd_not_deleted = false;
                        }
                    } else {
                        all_dnd_not_deleted = false;
                        if (all_high_pri || all_normal_pri || all_low_pri) {
                            int file_pri = file_info.getPriority();
                            if (file_pri == 0) {
                                all_low_pri = false;
                                all_high_pri = false;
                            } else if (file_pri == 1) {
                                all_low_pri = false;
                                all_normal_pri = false;
                            } else if (file_pri == -1) {
                                all_high_pri = false;
                                all_normal_pri = false;
                            } else {
                                all_high_pri = false;
                                all_normal_pri = false;
                                all_low_pri = false;
                            }
                        }
                    }
                }
                File file_link = file_info.getFile(true);
                File file_nolink = file_info.getFile(false);
                if (file_info.getDownloaded() != file_info.getLength() || file_link.length() != file_info.getLength()) {
                    all_complete = false;
                }
                if (dm_file_count > 1 && !file_nolink.getAbsolutePath().equals(file_link.getAbsolutePath())) {
                    files_with_links.add(file_info);
                }
                if ((target = dm_state.getFileLink(file_info.getIndex(), file_nolink)) == null || target == file_nolink || target.equals(file_nolink)) continue;
                any_relocated = true;
            }
        }
        itemOpen.setEnabled(open);
        itemRenameOrRetarget.setEnabled(all_persistent);
        itemRename.setEnabled(all_persistent);
        itemRetarget.setEnabled(all_persistent);
        itemPersonalShare.setEnabled(all_complete && all_files.size() == 1);
        itemSkipped.setEnabled(!all_dnd_not_deleted);
        itemHigh.setEnabled(!all_high_pri);
        itemNormal.setEnabled(!all_normal_pri);
        itemLow.setEnabled(!all_low_pri);
        itemDelete.setEnabled(!all_compact);
        itemOpen.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                for (int i = 0; i < all_files.size(); ++i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)all_files.get(i);
                    if (info == null || info.getAccessMode() != 1) continue;
                    Utils.launch(info);
                }
            }
        });
        Listener rename_listener = new Listener(){

            @Override
            public void handleEvent(Event event2) {
                boolean rename_it = (Boolean)event2.widget.getData("rename");
                boolean retarget_it = (Boolean)event2.widget.getData("retarget");
                FilesViewMenuUtil.rename(tv, all_files.toArray(new Object[all_files.size()]), rename_it, retarget_it);
            }
        };
        itemRenameOrRetarget.addListener(13, rename_listener);
        itemRename.addListener(13, rename_listener);
        itemRetarget.addListener(13, rename_listener);
        itemLocateFiles.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                ManagerUtils.locateFiles(manager_list, files_list, menu.getShell());
            }
        });
        itemLocateFiles.setEnabled(true);
        if (ManagerUtils.canFindMoreLikeThis()) {
            itemfindMore.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    ManagerUtils.findMoreLikeThis((DiskManagerFileInfo)all_files.get(0), menu.getShell());
                }
            });
            itemfindMore.setEnabled(all_files.size() == 1);
        }
        itemRevertFiles.setEnabled(any_relocated);
        itemRevertFiles.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                FilesViewMenuUtil.revertFiles(tv, all_files);
            }
        });
        if (itemClearLinks != null) {
            itemClearLinks.setEnabled(files_with_links.size() > 0);
            itemClearLinks.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    for (DiskManagerFileInfo file : files_with_links) {
                        file.setLink(null);
                    }
                    FilesViewMenuUtil.invalidateRows(tv, files_with_links);
                }
            });
        }
        itemPersonalShare.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("personal", "true");
                for (int i = 0; i < all_files.size(); ++i) {
                    DiskManagerFileInfo file_info = (DiskManagerFileInfo)all_files.get(i);
                    File file = file_info.getFile(true);
                    if (file.isFile()) {
                        ShareUtils.shareFile(file.getAbsolutePath(), properties);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    ShareUtils.shareDir(file.getAbsolutePath(), properties);
                }
            }
        });
        Listener priorityListener = new Listener(){

            @Override
            public void handleEvent(Event event2) {
                final Object priority = event2.widget.getData("Priority");
                Utils.getOffOfSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        FilesViewMenuUtil.changePriority(priority, all_files);
                    }
                });
            }
        };
        itemNumeric.addListener(13, priorityListener);
        itemNumericAuto.addListener(13, priorityListener);
        itemHigh.addListener(13, priorityListener);
        itemNormal.addListener(13, priorityListener);
        itemLow.addListener(13, priorityListener);
        itemSkipped.addListener(13, priorityListener);
        itemDelete.addListener(13, priorityListener);
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray("file_context");
        if (menu_items.length > 0) {
            Object[] fileInfos = new org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[all_files.size()];
            for (int i = 0; i < all_files.size(); ++i) {
                fileInfos[i] = (org.gudy.azureus2.plugins.disk.DiskManagerFileInfo)PluginCoreUtils.convert(all_files.get(i), false);
            }
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(fileInfos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(TableView tv, Object[] datasources, boolean rename_it, boolean retarget_it) {
        File f_target;
        File existing_file;
        DiskManagerFileInfo fileInfo2;
        String s;
        if (datasources.length == 0) {
            return;
        }
        String save_dir = null;
        if (!rename_it && retarget_it && (save_dir = FilesViewMenuUtil.askForSaveDirectory((DiskManagerFileInfo)datasources[0], s = MessageText.getString("label.num_selected", new String[]{Integer.toString(datasources.length)}))) == null) {
            return;
        }
        ArrayList<DownloadManager> pausedDownloads = new ArrayList<DownloadManager>(0);
        final AESemaphore task_sem = new AESemaphore("tasksem");
        ArrayList<DiskManagerFileInfo> affected_files = new ArrayList<DiskManagerFileInfo>();
        try {
            for (int i = 0; i < datasources.length; ++i) {
                String s_target;
                if (datasources[i] instanceof DownloadManager) {
                    AdvRenameWindow window = new AdvRenameWindow();
                    window.open((DownloadManager)datasources[i]);
                    continue;
                }
                if (!(datasources[i] instanceof DiskManagerFileInfo)) continue;
                fileInfo2 = (DiskManagerFileInfo)datasources[i];
                existing_file = fileInfo2.getFile(true);
                f_target = null;
                if (rename_it && retarget_it) {
                    s_target = FilesViewMenuUtil.askForRetargetedFilename(fileInfo2);
                    if (s_target != null) {
                        f_target = new File(s_target);
                    }
                } else if (rename_it) {
                    s_target = FilesViewMenuUtil.askForRenameFilename(fileInfo2);
                    if (s_target != null) {
                        f_target = new File(existing_file.getParentFile(), s_target);
                    }
                } else {
                    f_target = new File(save_dir, existing_file.getName());
                }
                if (f_target != null) break block19;
                if (affected_files.size() <= 0) break block20;
            }
        }
        catch (Throwable throwable) {
            if (affected_files.size() > 0) {
                Utils.getOffOfSWTThread(new AERunnable(affected_files, task_sem, pausedDownloads, tv){
                    final /* synthetic */ List val$affected_files;
                    final /* synthetic */ AESemaphore val$task_sem;
                    final /* synthetic */ List val$pausedDownloads;
                    final /* synthetic */ TableView val$tv;
                    {
                        this.val$affected_files = list;
                        this.val$task_sem = aESemaphore;
                        this.val$pausedDownloads = list2;
                        this.val$tv = tableView;
                    }

                    @Override
                    public void runSupport() {
                        for (int i = 0; i < this.val$affected_files.size(); ++i) {
                            this.val$task_sem.reserve();
                        }
                        for (DownloadManager manager : this.val$pausedDownloads) {
                            manager.resume();
                        }
                        FilesViewMenuUtil.invalidateRows(this.val$tv, this.val$affected_files);
                    }
                });
            }
            throw throwable;
        }
        {
            block19: {
                block20: {
                    Utils.getOffOfSWTThread(new /* invalid duplicate definition of identical inner class */);
                }
                return;
            }
            DownloadManager manager = fileInfo2.getDownloadManager();
            if (!pausedDownloads.contains(manager) && manager.pause()) {
                pausedDownloads.add(manager);
            }
            boolean dont_delete_existing = false;
            if (f_target.exists()) {
                if (f_target.equals(existing_file)) continue;
                if (retarget_it) {
                    if (!FilesViewMenuUtil.checkRetargetOK(fileInfo2, f_target)) continue;
                    dont_delete_existing = true;
                } else if (existing_file.exists() && !FilesViewMenuUtil.askCanOverwrite(existing_file)) continue;
            }
            final File ff_target = f_target;
            final boolean f_dont_delete_existing = dont_delete_existing;
            affected_files.add(fileInfo2);
            Utils.getOffOfSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    FilesViewMenuUtil.moveFile(fileInfo2.getDownloadManager(), fileInfo2, ff_target, f_dont_delete_existing, new Runnable(){

                        @Override
                        public void run() {
                            task_sem.release();
                        }
                    });
                }
            });
            continue;
        }
        if (affected_files.size() > 0) {
            Utils.getOffOfSWTThread(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private static void invalidateRows(TableView tv, List<DiskManagerFileInfo> files) {
        if (tv == null) {
            return;
        }
        HashSet<TableRowCore> done = new HashSet<TableRowCore>();
        for (DiskManagerFileInfo file : files) {
            TableRowCore[] subrows;
            TableRowCore row = tv.getRow(file);
            if (row == null && (row = tv.getRow(file.getDownloadManager())) != null && (subrows = row.getSubRowsWithNull()) != null) {
                for (TableRowCore sr : subrows) {
                    if (sr.getDataSource(true) != file) continue;
                    row = sr;
                    break;
                }
            }
            if (row == null || done.contains(row)) continue;
            done.add(row);
            row.invalidate(true);
        }
    }

    public static void changePriority(Object type, List<DiskManagerFileInfo> file_list) {
        if (file_list == null || file_list.size() == 0) {
            return;
        }
        if (type == PRIORITY_NUMERIC) {
            FilesViewMenuUtil.changePriorityManual(file_list);
            return;
        }
        if (type == PRIORITY_NUMERIC_AUTO) {
            FilesViewMenuUtil.changePriorityAuto(file_list);
            return;
        }
        IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> mapDMtoDMFI = new IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
        for (DiskManagerFileInfo file : file_list) {
            DownloadManager dm = file.getDownloadManager();
            ArrayList<DiskManagerFileInfo> listFileInfos = (ArrayList<DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
            if (listFileInfos == null) {
                listFileInfos = new ArrayList<DiskManagerFileInfo>(1);
                mapDMtoDMFI.put(dm, listFileInfos);
            }
            listFileInfos.add(file);
        }
        boolean skipped = type == PRIORITY_SKIPPED || type == PRIORITY_DELETE;
        boolean delete_action = type == PRIORITY_DELETE;
        for (DownloadManager dm : mapDMtoDMFI.keySet()) {
            boolean paused;
            ArrayList list = (ArrayList)mapDMtoDMFI.get(dm);
            DiskManagerFileInfo[] fileInfos = list.toArray(new DiskManagerFileInfo[0]);
            if (type == PRIORITY_NORMAL) {
                dm.setFilePriorities(fileInfos, 0);
            } else if (type == PRIORITY_HIGH) {
                dm.setFilePriorities(fileInfos, 1);
            } else if (type == PRIORITY_LOW) {
                dm.setFilePriorities(fileInfos, -1);
            }
            if (!(paused = FilesViewMenuUtil.setSkipped(dm, fileInfos, skipped, delete_action))) continue;
            dm.resume();
        }
    }

    private static void changePriorityManual(final List<DiskManagerFileInfo> file_list) {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("FilesView.dialog.priority.title", "FilesView.dialog.priority.text");
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                int priority = 0;
                try {
                    priority = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException er) {
                    Debug.out("Invalid priority: " + sReturn);
                    new MessageBoxShell(33, MessageText.getString("FilePriority.invalid.title"), MessageText.getString("FilePriority.invalid.text", new String[]{sReturn})).open(null);
                    return;
                }
                IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> mapDMtoDMFI = new IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
                for (DiskManagerFileInfo file : file_list) {
                    DownloadManager dm = file.getDownloadManager();
                    ArrayList<DiskManagerFileInfo> listFileInfos = (ArrayList<DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
                    if (listFileInfos == null) {
                        listFileInfos = new ArrayList<DiskManagerFileInfo>(1);
                        mapDMtoDMFI.put(dm, listFileInfos);
                    }
                    listFileInfos.add(file);
                    file.setPriority(priority);
                }
                for (DownloadManager dm : mapDMtoDMFI.keySet()) {
                    ArrayList list;
                    DiskManagerFileInfo[] fileInfos;
                    boolean paused = FilesViewMenuUtil.setSkipped(dm, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(dm)).toArray(new DiskManagerFileInfo[0]), false, false);
                    if (!paused) continue;
                    dm.resume();
                }
            }
        });
    }

    private static void changePriorityAuto(List<DiskManagerFileInfo> file_list) {
        int priority = 0;
        IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> mapDMtoDMFI = new IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
        for (DiskManagerFileInfo diskManagerFileInfo : file_list) {
            DownloadManager dm = diskManagerFileInfo.getDownloadManager();
            ArrayList<DiskManagerFileInfo> listFileInfos = (ArrayList<DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
            if (listFileInfos == null) {
                listFileInfos = new ArrayList<DiskManagerFileInfo>(1);
                mapDMtoDMFI.put(dm, listFileInfos);
            }
            listFileInfos.add(diskManagerFileInfo);
            diskManagerFileInfo.setPriority(priority++);
        }
        for (Map.Entry entry : mapDMtoDMFI.entrySet()) {
            DiskManagerFileInfo[] all_files = ((DownloadManager)entry.getKey()).getDiskManagerFileInfoSet().getFiles();
            ArrayList files = (ArrayList)entry.getValue();
            int next_priority = 0;
            if (all_files.length != files.size()) {
                HashSet<Integer> affected_indexes = new HashSet<Integer>();
                for (DiskManagerFileInfo file : files) {
                    affected_indexes.add(file.getIndex());
                }
                for (DiskManagerFileInfo file : all_files) {
                    if (affected_indexes.contains(file.getIndex()) || file.isSkipped()) continue;
                    next_priority = Math.max(next_priority, file.getPriority() + 1);
                }
            }
            next_priority += files.size();
            for (DiskManagerFileInfo file : files) {
                file.setPriority(--next_priority);
            }
        }
        for (DownloadManager downloadManager : mapDMtoDMFI.keySet()) {
            ArrayList list;
            DiskManagerFileInfo[] fileInfos;
            boolean paused = FilesViewMenuUtil.setSkipped(downloadManager, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(downloadManager)).toArray(new DiskManagerFileInfo[0]), false, false);
            if (!paused) continue;
            downloadManager.resume();
        }
    }

    private static String askForRenameFilename(DiskManagerFileInfo fileInfo2) {
        SimpleTextEntryWindow dialog = new SimpleTextEntryWindow("FilesView.rename.filename.title", "FilesView.rename.filename.text");
        String file_name = fileInfo2.getFile(true).getName();
        dialog.setPreenteredText(file_name, false);
        int pos = file_name.lastIndexOf(46);
        if (pos > 0) {
            String suffix = fileInfo2.getDownloadManager().getDownloadState().getAttribute("incompfilesuffix");
            if (suffix != null && file_name.substring(pos).equals(suffix)) {
                --pos;
                while (pos > 0 && file_name.charAt(pos) != '.') {
                    --pos;
                }
            }
            if (pos > 0) {
                dialog.selectPreenteredTextRange(new int[]{0, pos});
            }
        }
        dialog.allowEmptyInput(false);
        dialog.prompt();
        if (!dialog.hasSubmittedInput()) {
            return null;
        }
        return dialog.getSubmittedInput();
    }

    private static String askForRetargetedFilename(DiskManagerFileInfo fileInfo2) {
        FileDialog fDialog = new FileDialog(Utils.findAnyShell(), 131072);
        File existing_file = fileInfo2.getFile(true);
        fDialog.setFilterPath(existing_file.getParent());
        fDialog.setFileName(existing_file.getName());
        fDialog.setText(MessageText.getString("FilesView.rename.choose.path"));
        return fDialog.open();
    }

    private static String askForSaveDirectory(DiskManagerFileInfo fileInfo2, String message) {
        Shell anyShell = Utils.findAnyShell();
        Shell shell = new Shell(anyShell.getDisplay(), 8);
        shell.setSize(1, 1);
        shell.open();
        DirectoryDialog dDialog = new DirectoryDialog(shell, 139264);
        File current_dir = fileInfo2.getFile(true).getParentFile();
        if (!current_dir.isDirectory()) {
            current_dir = fileInfo2.getDownloadManager().getSaveLocation();
        }
        dDialog.setFilterPath(current_dir.getPath());
        dDialog.setText(MessageText.getString("FilesView.rename.choose.path.dir"));
        if (message != null) {
            dDialog.setMessage(message);
        }
        String open = dDialog.open();
        shell.close();
        return open;
    }

    private static boolean askCanOverwrite(File file) {
        MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{file.toString()}));
        mb.setDefaultButtonUsingStyle(32);
        mb.setRememberOnlyIfButton(0);
        mb.setRemember("FilesView.messagebox.rename.id", true, null);
        mb.setLeftImage(8);
        mb.open(null);
        return mb.waitUntilClosed() == 32;
    }

    private static boolean checkRetargetOK(DiskManagerFileInfo info, File target) {
        if (!target.exists()) {
            return true;
        }
        if (info.getTorrentFile().getLength() == target.length()) {
            return true;
        }
        MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.retarget.confirm.title"), MessageText.getString("FilesView.retarget.confirm.text"));
        mb.setDefaultButtonUsingStyle(32);
        mb.setLeftImage(8);
        mb.open(null);
        return mb.waitUntilClosed() == 32;
    }

    private static void moveFile(final DownloadManager manager, final DiskManagerFileInfo fileInfo2, final File target, boolean dont_delete_existing, final Runnable done) {
        block3: {
            manager.setUserData("is_changing_links", true);
            if (dont_delete_existing) {
                manager.setUserData("set_link_dont_delete_existing", true);
            }
            try {
                FileUtil.runAsTask(new AzureusCoreOperationTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run(AzureusCoreOperation operation) {
                        boolean went_async = false;
                        try {
                            boolean ok = fileInfo2.setLink(target);
                            if (!ok) {
                                new MessageBoxShell(33, MessageText.getString("FilesView.rename.failed.title"), MessageText.getString("FilesView.rename.failed.text")).open(new UserPrompterResultListener(){

                                    @Override
                                    public void prompterClosed(int result) {
                                        if (done != null) {
                                            done.run();
                                        }
                                    }
                                });
                                went_async = true;
                            }
                        }
                        finally {
                            manager.setUserData("is_changing_links", false);
                            manager.setUserData("set_link_dont_delete_existing", null);
                            if (!went_async && done != null) {
                                done.run();
                            }
                        }
                    }
                });
            }
            catch (Throwable e) {
                manager.setUserData("is_changing_links", false);
                manager.setUserData("set_link_dont_delete_existing", null);
                if (done == null) break block3;
                done.run();
            }
        }
    }

    private static boolean setSkipped(DownloadManager manager, DiskManagerFileInfo[] infos, boolean skipped, boolean delete_action) {
        File save_location;
        if (!manager.isPersistent()) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i].setSkipped(skipped);
            }
            return false;
        }
        int[] existing_storage_types = manager.getStorageType(infos);
        int nbFiles = manager.getDiskManagerFileInfoSet().nbFiles();
        boolean[] setLinear = new boolean[nbFiles];
        boolean[] setCompact = new boolean[nbFiles];
        boolean[] setReorder = new boolean[nbFiles];
        boolean[] setReorderCompact = new boolean[nbFiles];
        int compactCount = 0;
        int linearCount = 0;
        int reorderCount = 0;
        int reorderCompactCount = 0;
        if (infos.length > 1) {
            // empty if block
        }
        boolean root_exists = (save_location = manager.getAbsoluteSaveLocation()).isDirectory() || infos.length <= 1 && save_location.exists();
        boolean type_has_been_changed = false;
        boolean requires_pausing = false;
        for (int i = 0; i < infos.length; ++i) {
            int new_storage_type;
            int non_compact_target;
            int compact_target;
            int existing_storage_type = existing_storage_types[i];
            if (existing_storage_type == 2 || existing_storage_type == 1) {
                compact_target = 2;
                non_compact_target = 1;
            } else {
                compact_target = 4;
                non_compact_target = 3;
            }
            if (skipped) {
                File existing_file = infos[i].getFile(true);
                boolean perform_check = root_exists ? true : !FileUtil.isAncestorOf(save_location, existing_file);
                if (perform_check && existing_file.exists()) {
                    if (delete_action) {
                        boolean wants_to_delete;
                        MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{existing_file.toString()}));
                        mb.setDefaultButtonUsingStyle(32);
                        mb.setRememberOnlyIfButton(0);
                        mb.setRemember("FilesView.messagebox.delete.id", false, null);
                        mb.setLeftImage(8);
                        mb.open(null);
                        boolean bl = wants_to_delete = mb.waitUntilClosed() == 32;
                        new_storage_type = wants_to_delete ? compact_target : non_compact_target;
                    } else {
                        new_storage_type = non_compact_target;
                    }
                } else {
                    new_storage_type = compact_target;
                }
            } else {
                new_storage_type = non_compact_target;
            }
            boolean has_changed = existing_storage_type != new_storage_type;
            type_has_been_changed |= has_changed;
            if (!has_changed) continue;
            requires_pausing |= new_storage_type == 2 || new_storage_type == 4;
            if (new_storage_type == 2) {
                setCompact[infos[i].getIndex()] = true;
                ++compactCount;
                continue;
            }
            if (new_storage_type == 1) {
                setLinear[infos[i].getIndex()] = true;
                ++linearCount;
                continue;
            }
            if (new_storage_type == 3) {
                setReorder[infos[i].getIndex()] = true;
                ++reorderCount;
                continue;
            }
            if (new_storage_type != 4) continue;
            setReorderCompact[infos[i].getIndex()] = true;
            ++reorderCompactCount;
        }
        boolean ok = true;
        boolean paused = false;
        if (type_has_been_changed) {
            if (requires_pausing) {
                paused = manager.pause();
            }
            if (linearCount > 0) {
                ok &= Arrays.equals(setLinear, manager.getDiskManagerFileInfoSet().setStorageTypes(setLinear, 1));
            }
            if (compactCount > 0) {
                ok &= Arrays.equals(setCompact, manager.getDiskManagerFileInfoSet().setStorageTypes(setCompact, 2));
            }
            if (reorderCount > 0) {
                ok &= Arrays.equals(setReorder, manager.getDiskManagerFileInfoSet().setStorageTypes(setReorder, 3));
            }
            if (reorderCompactCount > 0) {
                ok &= Arrays.equals(setReorderCompact, manager.getDiskManagerFileInfoSet().setStorageTypes(setReorderCompact, 4));
            }
        }
        if (ok) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i].setSkipped(skipped);
            }
        }
        return paused;
    }

    public static void revertFiles(TableView<?> tv, DownloadManager[] dms) {
        ArrayList<DiskManagerFileInfo> files = new ArrayList<DiskManagerFileInfo>();
        for (DownloadManager dm : dms) {
            DiskManagerFileInfo[] dm_files = dm.getDiskManagerFileInfoSet().getFiles();
            LinkFileMap links = dm.getDownloadState().getFileLinks();
            Iterator<LinkFileMap.Entry> it = links.entryIterator();
            while (it.hasNext()) {
                LinkFileMap.Entry entry = it.next();
                if (entry.getToFile() == null) continue;
                files.add(dm_files[entry.getIndex()]);
            }
        }
        if (files.size() > 0) {
            FilesViewMenuUtil.revertFiles(tv, files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void revertFiles(TableView<?> tv, List<DiskManagerFileInfo> files) {
        ArrayList<DownloadManager> paused = new ArrayList<DownloadManager>();
        final AESemaphore task_sem = new AESemaphore("tasksem");
        ArrayList<DiskManagerFileInfo> affected_files = new ArrayList<DiskManagerFileInfo>();
        try {
            for (int i = 0; i < files.size(); ++i) {
                final DiskManagerFileInfo file_info = files.get(i);
                if (file_info == null) continue;
                final File file_nolink = file_info.getFile(false);
                final DownloadManager manager = file_info.getDownloadManager();
                File target = file_info.getDownloadManager().getDownloadState().getFileLink(file_info.getIndex(), file_nolink);
                if (target == null || target == file_nolink || target.equals(file_nolink)) continue;
                if (!paused.contains(manager) && manager.pause()) {
                    paused.add(manager);
                }
                affected_files.add(file_info);
                Utils.getOffOfSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        FilesViewMenuUtil.moveFile(manager, file_info, file_nolink, true, new Runnable(){

                            @Override
                            public void run() {
                                task_sem.release();
                            }
                        });
                    }
                });
            }
            if (affected_files.size() <= 0) return;
        }
        catch (Throwable throwable) {
            if (affected_files.size() <= 0) throw throwable;
            Utils.getOffOfSWTThread(new AERunnable(affected_files, task_sem, paused, tv){
                final /* synthetic */ List val$affected_files;
                final /* synthetic */ AESemaphore val$task_sem;
                final /* synthetic */ List val$paused;
                final /* synthetic */ TableView val$tv;
                {
                    this.val$affected_files = list;
                    this.val$task_sem = aESemaphore;
                    this.val$paused = list2;
                    this.val$tv = tableView;
                }

                @Override
                public void runSupport() {
                    for (int i = 0; i < this.val$affected_files.size(); ++i) {
                        this.val$task_sem.reserve();
                    }
                    for (DownloadManager manager : this.val$paused) {
                        manager.resume();
                    }
                    FilesViewMenuUtil.invalidateRows(this.val$tv, this.val$affected_files);
                }
            });
            throw throwable;
        }
        Utils.getOffOfSWTThread(new /* invalid duplicate definition of identical inner class */);
    }
}

