/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.archivedfiles.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.archivedfiles.SizeItem;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class ArchivedFilesView
extends TableViewTab<DownloadStub.DownloadStubFile>
implements TableLifeCycleListener,
TableDataSourceChangedListener,
TableViewSWTMenuFillListener {
    private static final String TABLE_ID = "ArchivedFiles";
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem("ArchivedFiles"), new SizeItem("ArchivedFiles")};
    public static final String MSGID_PREFIX = "ArchivedFilesView";
    private TableViewSWT<DownloadStub.DownloadStubFile> tv;
    private DownloadStub current_download;
    public static boolean show_full_path;

    public ArchivedFilesView() {
        super(MSGID_PREFIX);
    }

    @Override
    public TableViewSWT<DownloadStub.DownloadStubFile> initYourTableView() {
        this.tv = TableViewFactory.createTableViewSWT(DownloadStub.DownloadStubFile.class, TABLE_ID, this.getPropertiesPrefix(), basicItems, basicItems[0].getName(), 0x10010002);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.setEnableTabViews(false, true, null);
        return this.tv;
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        final ArrayList<DownloadStub.DownloadStubFile> files = new ArrayList<DownloadStub.DownloadStubFile>();
        for (Object o : ds) {
            files.add((DownloadStub.DownloadStubFile)o);
        }
        boolean hasSelection = files.size() > 0;
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText(itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                for (DownloadStub.DownloadStubFile file : files) {
                    ManagerUtils.open(new File(file.getFile().getAbsolutePath()), use_open_containing_folder);
                }
            }
        });
        itemExplore.setEnabled(hasSelection);
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
        if (columnName.equals("name")) {
            new MenuItem(menuThisColumn, 2);
            final MenuItem path_item = new MenuItem(menuThisColumn, 32);
            path_item.setSelection(show_full_path);
            Messages.setLanguageText(path_item, "FilesView.fullpath");
            path_item.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    show_full_path = path_item.getSelection();
                    ArchivedFilesView.this.tv.columnInvalidate("name");
                    ArchivedFilesView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("ArchivedFilesView.show.full.path", show_full_path);
                }
            });
        }
    }

    @Override
    public void tableDataSourceChanged(Object ds) {
        if (ds == this.current_download) {
            this.tv.setEnabled(ds != null);
            return;
        }
        boolean enabled = true;
        if (ds instanceof DownloadStub) {
            this.current_download = (DownloadStub)ds;
        } else if (ds instanceof Object[]) {
            Object[] objs = (Object[])ds;
            if (objs.length != 1) {
                enabled = false;
            } else {
                DownloadStub stub = (DownloadStub)objs[0];
                if (stub == this.current_download) {
                    return;
                }
                this.current_download = stub;
            }
        } else {
            this.current_download = null;
            enabled = false;
        }
        if (!this.tv.isDisposed()) {
            this.tv.removeAllTableRows();
            this.tv.setEnabled(enabled);
            if (enabled && this.current_download != null) {
                this.addExistingDatasources();
            }
        }
    }

    @Override
    public void tableViewInitialized() {
        if (this.current_download != null) {
            this.addExistingDatasources();
        } else {
            this.tv.setEnabled(false);
        }
    }

    @Override
    public void tableViewDestroyed() {
    }

    private void addExistingDatasources() {
        if (this.current_download == null || this.tv.isDisposed()) {
            return;
        }
        DownloadStub.DownloadStubFile[] files = this.current_download.getStubFiles();
        this.tv.addDataSources((DownloadStub.DownloadStubFile[])files);
        this.tv.processDataSourceQueueSync();
    }

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames(TABLE_ID, basicItems);
        COConfigurationManager.addAndFireParameterListener("ArchivedFilesView.show.full.path", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                show_full_path = COConfigurationManager.getBooleanParameter("ArchivedFilesView.show.full.path");
            }
        });
    }
}

