/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateCheckerListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerDecisionListener;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.update.UpdateManagerVerificationListener;
import org.gudy.azureus2.plugins.update.UpdateProgressListener;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.StringListChooser;
import org.gudy.azureus2.ui.swt.progress.IProgressReport;
import org.gudy.azureus2.ui.swt.progress.IProgressReportConstants;
import org.gudy.azureus2.ui.swt.progress.IProgressReporter;
import org.gudy.azureus2.ui.swt.progress.IProgressReporterListener;
import org.gudy.azureus2.ui.swt.progress.ProgressReportingManager;
import org.gudy.azureus2.ui.swt.update.SilentInstallUI;
import org.gudy.azureus2.ui.swt.update.SimpleInstallUI;
import org.gudy.azureus2.ui.swt.update.UpdateAutoDownloader;
import org.gudy.azureus2.ui.swt.update.UpdateWindow;
import org.gudy.azureus2.update.CoreUpdateChecker;

public class UpdateMonitor
implements UpdateCheckInstanceListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final long AUTO_UPDATE_CHECK_PERIOD = 82800000L;
    public static final long AUTO_UPDATE_CHECK_PERIOD_BETA = 14400000L;
    private static final String MSG_PREFIX = "UpdateMonitor.messagebox.";
    private static UpdateMonitor singleton;
    private static AEMonitor class_mon;
    private AzureusCore azCore;
    private UpdateWindow current_update_window;
    private UpdateCheckInstance current_update_instance;
    private long last_recheck_time;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateMonitor getSingleton(AzureusCore core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new UpdateMonitor(core);
            }
            UpdateMonitor updateMonitor = singleton;
            return updateMonitor;
        }
        finally {
            class_mon.exit();
        }
    }

    protected UpdateMonitor(AzureusCore _azureus_core) {
        this.azCore = _azureus_core;
        PluginInterface defPI = PluginInitializer.getDefaultInterface();
        UpdateManager um = defPI.getUpdateManager();
        um.addListener(new UpdateManagerListener(){

            @Override
            public void checkInstanceCreated(UpdateCheckInstance instance) {
                instance.addListener(UpdateMonitor.this);
                if (!instance.isLowNoise()) {
                    new updateStatusChanger(instance);
                }
            }
        });
        um.addVerificationListener(new UpdateManagerVerificationListener(){

            @Override
            public boolean acceptUnVerifiedUpdate(Update update) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    String title = MessageText.getString("UpdateMonitor.messagebox.accept.unverified.title");
                    String text = MessageText.getString("UpdateMonitor.messagebox.accept.unverified.text", new String[]{update.getName()});
                    UIFunctionsUserPrompter prompter = uiFunctions.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                    prompter.setRemember("UpdateMonitor.messagebox.accept.unverified", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                    prompter.setAutoCloseInMS(0);
                    prompter.open(null);
                    return prompter.waitUntilClosed() == 0;
                }
                return false;
            }

            @Override
            public void verificationFailed(Update update, Throwable cause) {
                String cause_str = Debug.getNestedExceptionMessage(cause);
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    String title = MessageText.getString("UpdateMonitor.messagebox.verification.failed.title");
                    String text = MessageText.getString("UpdateMonitor.messagebox.verification.failed.text", new String[]{update.getName(), cause_str});
                    uiFunctions.promptUser(title, text, new String[]{MessageText.getString("Button.ok")}, 0, null, null, false, 0, null);
                }
            }
        });
        SimpleTimer.addPeriodicEvent("UpdateMon:autocheck", COConfigurationManager.getBooleanParameter("Beta Programme Enabled") ? 14400000L : 82800000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent ev) {
                UpdateMonitor.this.performAutoCheck(false);
            }
        });
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("Update Check", new Runnable(){

            @Override
            public void run() {
                UIFunctions uiFunctions;
                String app_str;
                if (!(Constants.isWindowsVistaOrHigher || SystemProperties.isJavaWebStartInstance() || new File(app_str = SystemProperties.getApplicationPath()).canWrite() || (uiFunctions = UIFunctionsManager.getUIFunctions()) == null)) {
                    if (app_str.endsWith(File.separator)) {
                        app_str = app_str.substring(0, app_str.length() - 1);
                    }
                    final String f_app_str = app_str;
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            UIFunctionsUserPrompter prompt = uiFunctions.getUserPrompter(MessageText.getString("updater.cant.write.to.app.title"), MessageText.getString("updater.cant.write.to.app.details", new String[]{f_app_str}), new String[]{MessageText.getString("Button.ok")}, 0);
                            prompt.setIconResource("warning");
                            prompt.setRemember("UpdateMonitor.can.not.write.to.app.dir.2", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                            prompt.open(null);
                        }
                    }, true);
                }
                UpdateMonitor.this.performAutoCheck(true);
            }
        });
        delayed_task.queue();
    }

    private String format(UpdateCheckInstance instance, String str) {
        String name = instance.getName();
        if (MessageText.keyExists(name)) {
            name = MessageText.getString(name);
        }
        return name + " - " + str;
    }

    private String format(UpdateChecker checker, String str) {
        return "    " + checker.getComponent().getName() + " - " + str;
    }

    protected void requestRecheck() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "UpdateMonitor: recheck requested"));
        }
        this.performCheck(false, true, true, null);
    }

    protected void performAutoCheck(final boolean start_of_day) {
        boolean bOldSWT;
        boolean check_at_start = false;
        boolean check_periodic = false;
        boolean bl = bOldSWT = SWT.getVersion() < 3139;
        if (!SystemProperties.isJavaWebStartInstance()) {
            check_at_start = COConfigurationManager.getBooleanParameter("update.start") || bOldSWT;
            check_periodic = COConfigurationManager.getBooleanParameter("update.periodic");
        }
        boolean bl2 = check_at_start = check_at_start || check_periodic;
        if (check_at_start && start_of_day || check_periodic && !start_of_day) {
            this.performCheck(bOldSWT, true, false, null);
        } else {
            new DelayedEvent("UpdateMon:wait2", 5000L, new AERunnable(){

                @Override
                public void runSupport() {
                    UIFunctions uiFunctions;
                    if (start_of_day && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                        uiFunctions.setStatusText("");
                    }
                    CoreUpdateChecker.doUsageStats();
                }
            });
        }
    }

    public void performCheck(final boolean bForce, final boolean automatic, boolean isRecheck, final UpdateCheckInstanceListener l) {
        UIFunctions uiFunctions;
        long now = SystemTime.getCurrentTime();
        if (isRecheck) {
            if (this.last_recheck_time > now || now - this.last_recheck_time < 82800000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "skipping recheck as consecutive recheck too soon"));
                }
                return;
            }
            this.last_recheck_time = now;
        } else {
            this.last_recheck_time = 0L;
        }
        if (SystemProperties.isJavaWebStartInstance()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "skipping update check as java web start"));
            }
            return;
        }
        if (this.current_update_window != null && !this.current_update_window.isDisposed()) {
            this.current_update_window.dispose();
        }
        if (this.current_update_instance != null) {
            this.current_update_instance.cancel();
        }
        if (bForce) {
            VersionCheckClient.getSingleton().clearCache();
        }
        if ((uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
            uiFunctions.setStatusText("MainWindow.status.checking ...");
        }
        AEThread2 t = new AEThread2("UpdateMonitor:kickoff", true){

            @Override
            public void run() {
                UpdateManager um = PluginInitializer.getDefaultInterface().getUpdateManager();
                UpdateMonitor.this.current_update_instance = um.createUpdateCheckInstance(bForce ? 1 : 2, "update.instance.update");
                if (!automatic) {
                    UpdateMonitor.this.current_update_instance.setAutomatic(false);
                }
                if (l != null) {
                    UpdateMonitor.this.current_update_instance.addListener(l);
                }
                UpdateMonitor.this.current_update_instance.start();
            }
        };
        t.start();
    }

    @Override
    public void complete(final UpdateCheckInstance instance) {
        if (instance.isLowNoise()) {
            this.handleLowNoise(instance);
            return;
        }
        boolean hasDownloads = false;
        Update[] us = instance.getUpdates();
        for (int i = 0; i < us.length; ++i) {
            if (us[i].getDownloaders().length <= 0) continue;
            hasDownloads = true;
            break;
        }
        try {
            int ui = (Integer)instance.getProperty(1);
            if (ui == 2) {
                new SimpleInstallUI(this, instance);
                return;
            }
            if (ui == 3) {
                new SilentInstallUI(this, instance);
                return;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        boolean update_action = instance.getType() == 2;
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.setStatusText("");
        }
        if (hasDownloads) {
            UpdateWindow this_window = null;
            boolean autoDownload = COConfigurationManager.getBooleanParameter("update.autodownload");
            if (update_action) {
                if (!autoDownload && (this.current_update_window == null || this.current_update_window.isDisposed())) {
                    this_window = this.current_update_window = new UpdateWindow(this, this.azCore, instance);
                }
            } else {
                this_window = new UpdateWindow(this, this.azCore, instance);
            }
            if (this_window != null) {
                for (int i = 0; i < us.length; ++i) {
                    if (us[i].getDownloaders().length <= 0) continue;
                    this_window.addUpdate(us[i]);
                }
                this_window.updateAdditionComplete();
            } else if (autoDownload) {
                new UpdateAutoDownloader(us, new UpdateAutoDownloader.cbCompletion(){

                    @Override
                    public void allUpdatesComplete(boolean requiresRestart, boolean bHadMandatoryUpdates) {
                        Boolean b = (Boolean)instance.getProperty(4);
                        if (b != null && b.booleanValue()) {
                            return;
                        }
                        if (requiresRestart) {
                            UpdateMonitor.this.handleRestart();
                        } else if (bHadMandatoryUpdates) {
                            UpdateMonitor.this.requestRecheck();
                        }
                    }
                });
            } else if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "UpdateMonitor: user dialog already in progress, updates skipped"));
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "UpdateMonitor: check instance resulted in no user-actionable updates"));
        }
    }

    @Override
    public void cancelled(UpdateCheckInstance instance) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.setStatusText("");
        }
    }

    protected void handleRestart() {
        final UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            int visiblity_state = uiFunctions.getVisibilityState();
            if (visiblity_state == 1 && COConfigurationManager.getBooleanParameter("Low Resource Silent Update Restart Enabled")) {
                uiFunctions.dispose(true, false);
            } else {
                uiFunctions.performAction(2, Constants.isWindows7OrHigher, new UIFunctions.actionListener(){

                    @Override
                    public void actionComplete(Object result) {
                        if (((Boolean)result).booleanValue()) {
                            uiFunctions.dispose(true, false);
                        }
                    }
                });
            }
        } else {
            Debug.out("Can't handle restart as no ui functions available");
        }
    }

    protected void addDecisionHandler(UpdateCheckInstance instance) {
        instance.addDecisionListener(new UpdateManagerDecisionListener(){

            @Override
            public Object decide(Update update, int decision_type, String decision_name, String decision_description, Object decision_data) {
                if (decision_type == 0) {
                    String[] options = (String[])decision_data;
                    Shell shell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
                    if (shell == null) {
                        Debug.out("Shell doesn't exist");
                        return null;
                    }
                    StringListChooser chooser = new StringListChooser(shell);
                    chooser.setTitle(decision_name);
                    chooser.setText(decision_description);
                    for (int i = 0; i < options.length; ++i) {
                        chooser.addOption(options[i]);
                    }
                    String result = chooser.open();
                    return result;
                }
                return null;
            }
        });
    }

    protected void handleLowNoise(UpdateCheckInstance instance) {
        this.addDecisionHandler(instance);
        Update[] updates = instance.getUpdates();
        try {
            for (int i = 0; i < updates.length; ++i) {
                ResourceDownloader[] downloaders = updates[i].getDownloaders();
                for (int j = 0; j < downloaders.length; ++j) {
                    downloaders[j].download();
                }
            }
            boolean restart_required = false;
            for (int i = 0; i < updates.length; ++i) {
                if (updates[i].getRestartRequired() != 2) continue;
                restart_required = true;
            }
            if (restart_required) {
                this.handleRestart();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        class_mon = new AEMonitor("UpdateMonitor:class");
    }

    protected class updateStatusChanger
    implements IProgressReportConstants {
        UpdateCheckInstance instance;
        int check_num = 0;
        IProgressReporter updateReporter = ProgressReportingManager.getInstance().addReporter(MessageText.getString("UpdateWindow.title"));

        protected updateStatusChanger(UpdateCheckInstance _instance) {
            this.instance = _instance;
            this.updateReporter.setReporterType("reporterType_updater");
            this.updateReporter.setCancelAllowed(true);
            this.updateReporter.setTitle(MessageText.getString("updater.progress.window.title"));
            this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(this.instance, "added"));
            String name = this.instance.getName();
            if (MessageText.keyExists(name)) {
                this.updateReporter.setMessage(MessageText.getString(name));
            } else {
                this.updateReporter.setMessage(name);
            }
            this.updateReporter.setMinimum(0);
            this.updateReporter.setMaximum(this.instance.getCheckers().length);
            this.updateReporter.setSelection(this.check_num, null);
            this.updateReporter.addListener(new IProgressReporterListener(){

                @Override
                public int report(IProgressReport progressReport) {
                    if (progressReport.getReportType() == 2 || progressReport.getReportType() == 4) {
                        return 1;
                    }
                    if (progressReport.getReportType() == 1) {
                        if (null != updateStatusChanger.this.instance) {
                            updateStatusChanger.this.instance.cancel();
                        }
                        return 1;
                    }
                    return 0;
                }
            });
            this.instance.addListener(new UpdateCheckInstanceListener(){

                @Override
                public void cancelled(UpdateCheckInstance instance) {
                    updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(instance, MessageText.getString("Progress.reporting.status.canceled")));
                    updateStatusChanger.this.updateReporter.cancel();
                }

                @Override
                public void complete(UpdateCheckInstance instance) {
                    updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(instance, MessageText.getString("Progress.reporting.status.finished")));
                    updateStatusChanger.this.updateReporter.setDone();
                }
            });
            UpdateChecker[] checkers = this.instance.getCheckers();
            for (int i = 0; i < checkers.length; ++i) {
                final UpdateChecker checker = checkers[i];
                checker.addListener(new UpdateCheckerListener(){

                    @Override
                    public void cancelled(UpdateChecker checker) {
                        updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(checker, MessageText.getString("Progress.reporting.status.canceled")));
                    }

                    @Override
                    public void completed(UpdateChecker checker) {
                        updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(checker, MessageText.getString("Progress.reporting.status.finished")));
                        updateStatusChanger.this.updateReporter.setSelection(++updateStatusChanger.this.check_num, null);
                    }

                    @Override
                    public void failed(UpdateChecker checker) {
                        updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(checker, MessageText.getString("Progress.reporting.default.error")));
                        updateStatusChanger.this.updateReporter.setSelection(++updateStatusChanger.this.check_num, null);
                        updateStatusChanger.this.updateReporter.setErrorMessage(null);
                    }
                });
                checker.addProgressListener(new UpdateProgressListener(){

                    @Override
                    public void reportProgress(String str) {
                        updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(checker, "    " + str));
                    }
                });
            }
        }
    }
}

