/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;

public class SimpleInstallUI {
    private UpdateMonitor monitor;
    private UpdateCheckInstance instance;
    private boolean cancelled;
    private ResourceDownloader current_downloader;

    protected SimpleInstallUI(UpdateMonitor _monitor, UpdateCheckInstance _instance) {
        this.monitor = _monitor;
        this.instance = _instance;
        try {
            this.monitor.addDecisionHandler(_instance);
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SimpleInstallUI.this.build();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        SimpleInstallUI.this.instance.cancel();
                    }
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
            this.instance.cancel();
        }
    }

    protected void build() {
        Composite parent = (Composite)this.instance.getProperty(2);
        if (parent != null) {
            if (parent.isDisposed()) {
                throw new RuntimeException("cancelled");
            }
        } else {
            throw new RuntimeException("borkeroo");
        }
        this.build(parent);
    }

    protected void build(Composite parent) {
        parent.setLayout(new FormLayout());
        Button cancel_button = new Button(parent, 0);
        cancel_button.setText("Cancel");
        cancel_button.addListener(13, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(Event arg0) {
                SimpleInstallUI simpleInstallUI = SimpleInstallUI.this;
                synchronized (simpleInstallUI) {
                    SimpleInstallUI.this.cancelled = true;
                    if (SimpleInstallUI.this.current_downloader != null) {
                        SimpleInstallUI.this.current_downloader.cancel();
                    }
                }
                SimpleInstallUI.this.instance.cancel();
            }
        });
        FormData data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        cancel_button.setLayoutData(data);
        final Label label = new Label(parent, 0);
        label.setText("blah blah ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(cancel_button, 0, 0x1000000);
        label.setLayoutData(data);
        final ProgressBar progress = new ProgressBar(parent, 0);
        progress.setMinimum(0);
        progress.setMaximum(100);
        progress.setSelection(0);
        data = new FormData();
        data.left = new FormAttachment(label, 4);
        data.top = new FormAttachment(cancel_button, 0, 0x1000000);
        data.right = new FormAttachment(cancel_button, -4);
        progress.setLayoutData(data);
        parent.layout(true, true);
        new AEThread2("SimpleInstallerUI", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Update[] updates;
                    for (Update update : updates = SimpleInstallUI.this.instance.getUpdates()) {
                        ResourceDownloader[] downloaders;
                        String name = update.getName();
                        int pos = name.indexOf(47);
                        if (pos >= 0) {
                            name = name.substring(pos + 1);
                        }
                        this.setLabel(name);
                        for (ResourceDownloader downloader : downloaders = update.getDownloaders()) {
                            SimpleInstallUI simpleInstallUI = SimpleInstallUI.this;
                            synchronized (simpleInstallUI) {
                                if (SimpleInstallUI.this.cancelled) {
                                    return;
                                }
                                SimpleInstallUI.this.current_downloader = downloader;
                            }
                            this.setProgress(0);
                            downloader.addListener(new ResourceDownloaderAdapter(){

                                @Override
                                public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
                                    this.setProgress(percentage);
                                }

                                @Override
                                public void reportAmountComplete(ResourceDownloader downloader, long amount) {
                                }
                            });
                            downloader.download();
                        }
                    }
                    boolean restart_required = false;
                    for (int i = 0; i < updates.length; ++i) {
                        if (updates[i].getRestartRequired() != 2) continue;
                        restart_required = true;
                    }
                    if (restart_required) {
                        SimpleInstallUI.this.monitor.handleRestart();
                    }
                }
                catch (Throwable e) {
                    Debug.out("Install failed", e);
                    SimpleInstallUI.this.instance.cancel();
                }
            }

            protected void setLabel(final String str) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        if (label != null && !label.isDisposed()) {
                            label.setText(str);
                            label.getParent().layout();
                        }
                    }
                });
            }

            protected void setProgress(final int percent) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        if (progress != null && !progress.isDisposed()) {
                            progress.setSelection(percent);
                        }
                    }
                });
            }
        }.start();
    }
}

