/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;

public class SilentInstallUI {
    private UpdateMonitor monitor;
    private UpdateCheckInstance instance;
    private boolean cancelled;

    protected SilentInstallUI(UpdateMonitor _monitor, UpdateCheckInstance _instance) {
        this.monitor = _monitor;
        this.instance = _instance;
        try {
            this.monitor.addDecisionHandler(_instance);
            new AEThread2("SilentInstallerUI", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Update[] updates;
                        for (Update update : updates = SilentInstallUI.this.instance.getUpdates()) {
                            ResourceDownloader[] downloaders;
                            for (ResourceDownloader downloader : downloaders = update.getDownloaders()) {
                                SilentInstallUI silentInstallUI = SilentInstallUI.this;
                                synchronized (silentInstallUI) {
                                    if (SilentInstallUI.this.cancelled) {
                                        return;
                                    }
                                }
                                downloader.download();
                            }
                        }
                        boolean restart_required = false;
                        for (int i = 0; i < updates.length; ++i) {
                            if (updates[i].getRestartRequired() != 2) continue;
                            restart_required = true;
                        }
                        if (restart_required) {
                            SilentInstallUI.this.monitor.handleRestart();
                        }
                    }
                    catch (Throwable e) {
                        Debug.out("Install failed", e);
                        SilentInstallUI.this.instance.cancel();
                    }
                }
            }.start();
        }
        catch (Throwable e) {
            Debug.out(e);
            this.instance.cancel();
        }
    }
}

