/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import com.aelitis.azureus.ui.UIFunctions;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.BrowserWrapper;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class FullUpdateWindow {
    private static Shell current_shell = null;
    private static BrowserWrapper browser;
    private static BrowserWrapper.BrowserFunction browserFunction;

    public static void handleUpdate(final String url, final UIFunctions.actionListener listener) {
        try {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    FullUpdateWindow.open(url, listener);
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
            listener.actionComplete(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open(String url, final UIFunctions.actionListener listener) {
        boolean ok = false;
        final boolean[] listener_informed = new boolean[]{false};
        try {
            if (current_shell != null && !current_shell.isDisposed()) {
                return;
            }
            final Shell parentShell = Utils.findAnyShell();
            final Shell shell = current_shell = ShellFactory.createShell(parentShell, 67680);
            shell.setLayout(new FillLayout());
            if (parentShell != null) {
                parentShell.setCursor(shell.getDisplay().getSystemCursor(1));
            }
            shell.addDisposeListener(new DisposeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void widgetDisposed(DisposeEvent e) {
                    try {
                        if (parentShell != null) {
                            parentShell.setCursor(e.display.getSystemCursor(0));
                        }
                        if (browserFunction != null && !browserFunction.isDisposed()) {
                            browserFunction.dispose();
                        }
                        current_shell = null;
                    }
                    finally {
                        if (!listener_informed[0]) {
                            try {
                                listener.actionComplete(false);
                            }
                            catch (Throwable f) {
                                Debug.out(f);
                            }
                        }
                    }
                }
            });
            browser = Utils.createSafeBrowser(shell, 0);
            if (browser == null) {
                shell.dispose();
                return;
            }
            browser.addTitleListener(new TitleListener(){

                @Override
                public void changed(TitleEvent event2) {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    shell.setText(event2.title);
                }
            });
            browser.addOpenWindowListener(new OpenWindowListener(){

                @Override
                public void open(WindowEvent event2) {
                    final BrowserWrapper subBrowser = Utils.createSafeBrowser(shell, Utils.getInitialBrowserStyle(0));
                    subBrowser.addLocationListener(new LocationListener(){

                        @Override
                        public void changed(LocationEvent arg0) {
                        }

                        @Override
                        public void changing(LocationEvent event2) {
                            if (event2.location == null || !event2.location.startsWith("http")) {
                                return;
                            }
                            event2.doit = false;
                            Utils.launch(event2.location);
                            Utils.execSWTThreadLater(1000, new AERunnable(){

                                @Override
                                public void runSupport() {
                                    subBrowser.dispose();
                                }
                            });
                        }
                    });
                    subBrowser.setBrowser(event2);
                }
            });
            browserFunction = browser.addBrowserFunction("sendVuzeUpdateEvent", new BrowserWrapper.BrowserFunction(){
                private String last = null;

                @Override
                public Object function(Object[] arguments) {
                    if (shell == null || shell.isDisposed()) {
                        return null;
                    }
                    if (arguments == null) {
                        Debug.out("Invalid sendVuzeUpdateEvent null ");
                        return null;
                    }
                    if (arguments.length < 1) {
                        Debug.out("Invalid sendVuzeUpdateEvent length " + arguments.length + " not 1");
                        return null;
                    }
                    if (!(arguments[0] instanceof String)) {
                        Debug.out("Invalid sendVuzeUpdateEvent " + (arguments[0] == null ? "NULL" : arguments.getClass().getSimpleName()) + " not String");
                        return null;
                    }
                    String text = ((String)arguments[0]).toLowerCase();
                    if (this.last != null && this.last.equals(text)) {
                        return null;
                    }
                    this.last = text;
                    if (text.contains("page-loaded")) {
                        Utils.centreWindow(shell);
                        if (parentShell != null) {
                            parentShell.setCursor(shell.getDisplay().getSystemCursor(0));
                        }
                        shell.open();
                    } else if (text.startsWith("set-size")) {
                        String[] strings = text.split(" ");
                        if (strings.length > 2) {
                            try {
                                int w = Integer.parseInt(strings[1]);
                                int h = Integer.parseInt(strings[2]);
                                Rectangle computeTrim = shell.computeTrim(0, 0, w, h);
                                shell.setSize(computeTrim.width, computeTrim.height);
                            }
                            catch (Exception e) {}
                        }
                    } else if (text.contains("decline") || text.contains("close")) {
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            @Override
                            public void runSupport() {
                                shell.dispose();
                            }
                        });
                    } else if (text.contains("accept")) {
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            @Override
                            public void runSupport() {
                                listener_informed[0] = true;
                                try {
                                    listener.actionComplete(true);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                shell.dispose();
                            }
                        });
                    }
                    return null;
                }
            });
            browser.addStatusTextListener(new StatusTextListener(){

                @Override
                public void changed(StatusTextEvent event2) {
                    browserFunction.function(new Object[]{event2.text});
                }
            });
            browser.addLocationListener(new LocationListener(){

                @Override
                public void changing(LocationEvent event2) {
                }

                @Override
                public void changed(LocationEvent event2) {
                }
            });
            String final_url = url + (url.indexOf(63) == -1 ? "?" : "&") + "locale=" + MessageText.getCurrentLocale().toString() + "&azv=" + "5.7.5.0";
            SimpleTimer.addEvent("fullupdate.pageload", SystemTime.getOffsetTime(5000L), new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (!shell.isDisposed()) {
                                shell.open();
                            }
                        }
                    });
                }
            });
            browser.setUrl(final_url);
            if (browser.isFake()) {
                shell.setSize(400, 500);
                Utils.centreWindow(shell);
                browser.setUrl("http://www.vuze.com/download");
                browser.setText("Update available, please go to www.vuze.com to update.");
                shell.open();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                try {
                    listener.actionComplete(false);
                }
                catch (Throwable f) {
                    Debug.out(f);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            FullUpdateWindow.open("http://www.vuze.com/client/update.php?newversion=9.9.9.9", new UIFunctions.actionListener(){

                @Override
                public void actionComplete(Object result) {
                    System.out.println("result=" + result);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Display d = Display.getDefault();
        while (true) {
            if (d.readAndDispatch()) {
                continue;
            }
            d.sleep();
        }
    }
}

