/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.speedtest;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.util.HashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestPanel;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class SpeedTestSelector
extends AbstractWizardPanel<SpeedTestWizard> {
    private boolean mlab_test = true;

    public SpeedTestSelector(SpeedTestWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((SpeedTestWizard)this.wizard).setTitle(MessageText.getString("speedtest.wizard.select.title"));
        ((SpeedTestWizard)this.wizard).setCurrentInfo("");
        Composite rootPanel = ((SpeedTestWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        panel.setLayoutData(gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout(layout);
        Group gRadio = new Group(panel, 0);
        Messages.setLanguageText(gRadio, "speedtest.wizard.select.group");
        gRadio.setLayoutData(gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        gRadio.setLayout(layout);
        gridData = new GridData(768);
        gRadio.setLayoutData(gridData);
        Button auto_button = new Button(gRadio, 16);
        Messages.setLanguageText(auto_button, "speedtest.wizard.select.general");
        auto_button.setSelection(true);
        final Button manual_button = new Button(gRadio, 16);
        Messages.setLanguageText(manual_button, "speedtest.wizard.select.bt");
        manual_button.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                SpeedTestSelector.this.mlab_test = !manual_button.getSelection();
            }
        });
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    @Override
    public boolean isPreviousEnabled() {
        return false;
    }

    @Override
    public IWizardPanel getNextPanel() {
        if (this.mlab_test) {
            ((SpeedTestWizard)this.wizard).close();
            SpeedTestSelector.runMLABTest(null);
            return null;
        }
        return new SpeedTestPanel((SpeedTestWizard)this.wizard, null);
    }

    public static void runMLABTest(final Runnable runWhenClosed) {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                UIFunctionsManager.getUIFunctions().installPlugin("mlab", "dlg.install.mlab", new UIFunctions.actionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionComplete(Object result) {
                        if (result instanceof Boolean) {
                            SpeedTestSelector._runMLABTest(runWhenClosed);
                        } else {
                            try {
                                Throwable error = (Throwable)result;
                                Debug.out(error);
                            }
                            finally {
                                if (runWhenClosed != null) {
                                    runWhenClosed.run();
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private static void _runMLABTest(final Runnable runWhenClosed) {
        block5: {
            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("mlab");
            if (pi == null) {
                Debug.out("mlab plugin not available");
                if (runWhenClosed != null) {
                    runWhenClosed.run();
                }
            } else {
                try {
                    HashMap map = new HashMap();
                    pi.getIPC().invoke("runTest", new Object[]{map, new IPCInterface(){

                        @Override
                        public Object invoke(String methodName, Object[] params) throws IPCException {
                            COConfigurationManager.setParameter("SpeedTest Completed", true);
                            if (runWhenClosed != null) {
                                runWhenClosed.run();
                            }
                            return null;
                        }

                        @Override
                        public boolean canInvoke(String methodName, Object[] params) {
                            return true;
                        }
                    }, true});
                }
                catch (Throwable e) {
                    Debug.out(e);
                    if (runWhenClosed == null) break block5;
                    runWhenClosed.run();
                }
            }
        }
    }
}

