/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.speedtest;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.stats.TransferStatsView;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class SpeedTestFinishPanel
extends AbstractWizardPanel {
    SpeedManager speedManager = AzureusCoreFactory.getSingleton().getSpeedManager();
    TransferStatsView.limitToTextHelper helper = new TransferStatsView.limitToTextHelper();

    public SpeedTestFinishPanel(Wizard wizard, IWizardPanel previousPanel) {
        super(wizard, previousPanel);
    }

    @Override
    public void show() {
        String title = MessageText.getString("SpeedTestWizard.finish.panel.title");
        this.wizard.setTitle(title);
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        Utils.setLayoutData((Control)panel, gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout(layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 380;
        Utils.setLayoutData((Control)label, gridData);
        Messages.setLanguageText(label, "SpeedTestWizard.finish.panel.click.close");
        SpeedManagerLimitEstimate upEst = this.speedManager.getEstimatedUploadCapacityBytesPerSec();
        int maxUploadKbs = upEst.getBytesPerSec() / 1024;
        SpeedManagerLimitEstimate downEst = this.speedManager.getEstimatedDownloadCapacityBytesPerSec();
        int maxDownloadKbs = downEst.getBytesPerSec() / 1024;
        boolean autoSpeedEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
        boolean autoSpeedSeedingEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
        Label s2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        s2.setLayoutData(gridData);
        String autoSpeed = MessageText.getString("SpeedTestWizard.finish.panel.auto.speed");
        this.createStatusLine(panel, autoSpeed, autoSpeedEnabled);
        String autoSpeedWhileSeeding = MessageText.getString("SpeedTestWizard.finish.panel.auto.speed.seeding");
        this.createStatusLine(panel, autoSpeedWhileSeeding, autoSpeedSeedingEnabled);
        Label s1 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        s1.setLayoutData(gridData);
        this.createHeaderLine(panel);
        String maxUploadLbl = MessageText.getString("SpeedView.stats.estupcap");
        this.createDataLine(panel, maxUploadLbl, maxUploadKbs, upEst);
        String maxDownloadLbl = MessageText.getString("SpeedView.stats.estdowncap");
        this.createDataLine(panel, maxDownloadLbl, maxDownloadKbs, downEst);
    }

    private void createHeaderLine(Composite panel) {
        Label c1 = new Label(panel, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        c1.setLayoutData(gridData);
        c1.setText(" ");
        Label c2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c2.setLayoutData(gridData);
        c2.setText(MessageText.getString("SpeedTestWizard.set.upload.bytes.per.sec"));
        Label c3 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 1;
        c3.setLayoutData(gridData);
        c3.setText(MessageText.getString("SpeedTestWizard.set.upload.bits.per.sec"));
    }

    private void createStatusLine(Composite panel, String label, boolean enabled) {
        Label r3c1 = new Label(panel, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 3;
        r3c1.setLayoutData(gridData);
        r3c1.setText(label);
        Label c3 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c3.setLayoutData(gridData);
        if (enabled) {
            c3.setText(MessageText.getString("SpeedTestWizard.finish.panel.enabled", "enabled"));
        } else {
            c3.setText(MessageText.getString("SpeedTestWizard.finish.panel.disabled", "disabled"));
        }
        Label c2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 1;
        c2.setLayoutData(gridData);
        String maxUploadBitsSec = "       ";
        c2.setText(maxUploadBitsSec);
    }

    private void createDataLine(Composite panel, String label, int maxKbps, SpeedManagerLimitEstimate estimate) {
        Label c1 = new Label(panel, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 3;
        c1.setLayoutData(gridData);
        c1.setText(label + "  ");
        Label c2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c2.setLayoutData(gridData);
        String estString = this.helper.getLimitText(estimate);
        c2.setText(estString);
        Label c3 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 1;
        c3.setLayoutData(gridData);
        String maxBitsPerSec = maxKbps == 0 ? MessageText.getString("ConfigView.unlimited") : DisplayFormatters.formatByteCountToBitsPerSec(maxKbps * 1024);
        c3.setText(maxBitsPerSec);
    }

    @Override
    public boolean isPreviousEnabled() {
        return false;
    }
}

