/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class CoreWaiterSWT {
    private static boolean DEBUG = false;
    private static Shell shell;

    public static void waitForCoreRunning(AzureusCoreRunningListener l) {
        CoreWaiterSWT.waitForCore(TriggerInThread.SWT_THREAD, l);
    }

    public static void waitForCore(final TriggerInThread triggerInThread, final AzureusCoreRunningListener l) {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(final AzureusCore core) {
                if (triggerInThread == TriggerInThread.ANY_THREAD) {
                    l.azureusCoreRunning(core);
                } else if (triggerInThread == TriggerInThread.NEW_THREAD) {
                    new AEThread2("CoreWaiterInvoke", true){

                        @Override
                        public void run() {
                            l.azureusCoreRunning(core);
                        }
                    }.start();
                }
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (shell != null && !shell.isDisposed()) {
                            shell.dispose();
                            shell = null;
                        }
                        if (triggerInThread == TriggerInThread.SWT_THREAD) {
                            l.azureusCoreRunning(core);
                        }
                    }
                });
            }
        });
        if (!AzureusCoreFactory.isCoreRunning()) {
            if (DEBUG) {
                System.out.println("NOT AVAIL FOR " + Debug.getCompressedStackTrace());
            }
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    CoreWaiterSWT.showWaitWindow();
                }
            });
        } else if (DEBUG) {
            System.out.println("NO NEED TO WAIT.. CORE AVAIL! " + Debug.getCompressedStackTrace());
        }
    }

    protected static void showWaitWindow() {
        if (shell != null && !shell.isDisposed()) {
            shell.forceActive();
            return;
        }
        shell = UIFunctionsManagerSWT.getUIFunctionsSWT().showCoreWaitDlg();
    }

    public static enum TriggerInThread {
        SWT_THREAD,
        ANY_THREAD,
        NEW_THREAD;

    }
}

