/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.progress;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.gudy.azureus2.ui.swt.progress.IProgressReporter;

class ProgressReporterStack {
    private Stack reporterStack = new Stack();
    private Object lockObject = new Object();

    ProgressReporterStack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(IProgressReporter reporter) {
        if (null == reporter) {
            return;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.reporterStack.contains(reporter)) {
                this.reporterStack.remove(reporter);
            }
            this.reporterStack.push(reporter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProgressReporter peek() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.reporterStack.isEmpty()) {
                return (IProgressReporter)this.reporterStack.peek();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IProgressReporter reporter) {
        Object object = this.lockObject;
        synchronized (object) {
            if (null != reporter && this.reporterStack.contains(reporter)) {
                return this.reporterStack.remove(reporter);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IProgressReporter reporter) {
        Object object = this.lockObject;
        synchronized (object) {
            return this.reporterStack.contains(reporter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProgressReporter pop() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.reporterStack.isEmpty()) {
                return (IProgressReporter)this.reporterStack.pop();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim() {
        Object object = this.lockObject;
        synchronized (object) {
            Iterator iterator = this.reporterStack.iterator();
            while (iterator.hasNext()) {
                IProgressReporter reporter = (IProgressReporter)iterator.next();
                if (reporter.getProgressReport().isActive()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getReporters(boolean onlyActive) {
        Object object = this.lockObject;
        synchronized (object) {
            ArrayList<IProgressReporter> reporters = new ArrayList<IProgressReporter>();
            for (IProgressReporter reporter : this.reporterStack) {
                if (onlyActive) {
                    if (!reporter.getProgressReport().isActive()) continue;
                    reporters.add(reporter);
                    continue;
                }
                reporters.add(reporter);
            }
            return reporters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.reporterStack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        Object object = this.lockObject;
        synchronized (object) {
            int activeReporters = 0;
            for (IProgressReporter reporter : this.reporterStack) {
                if (!reporter.getProgressReport().isActive()) continue;
                ++activeReporters;
            }
            return activeReporters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorCount() {
        Object object = this.lockObject;
        synchronized (object) {
            int reportersInErrorState = 0;
            for (IProgressReporter reporter : this.reporterStack) {
                if (!reporter.getProgressReport().isInErrorState()) continue;
                ++reportersInErrorState;
            }
            return reportersInErrorState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMultipleActive() {
        Object object = this.lockObject;
        synchronized (object) {
            int activeReporters = 0;
            for (IProgressReporter reporter : this.reporterStack) {
                if (reporter.getProgressReport().isActive()) {
                    ++activeReporters;
                }
                if (activeReporters <= 1) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProgressReporter getNextActiveReporter() {
        Object object = this.lockObject;
        synchronized (object) {
            for (IProgressReporter reporter : this.reporterStack) {
                if (!reporter.getProgressReport().isActive()) continue;
                return reporter;
            }
        }
        return null;
    }
}

