/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.progress;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.progress.IMessage;
import org.gudy.azureus2.ui.swt.progress.IProgressReport;
import org.gudy.azureus2.ui.swt.progress.IProgressReportConstants;
import org.gudy.azureus2.ui.swt.progress.IProgressReporter;
import org.gudy.azureus2.ui.swt.progress.IProgressReporterListener;
import org.gudy.azureus2.ui.swt.progress.ProgressReportMessage;
import org.gudy.azureus2.ui.swt.progress.ProgressReportingManager;

public class ProgressReporter
implements IProgressReporter,
IProgressReportConstants {
    private ProgressReportingManager manager = null;
    private transient int ID;
    private int minimum;
    private int maximum;
    private int selection;
    private int percentage;
    private int latestReportType = 0;
    private boolean isIndeterminate;
    private boolean isDone;
    private boolean isPercentageInUse;
    private boolean isCancelAllowed;
    private boolean isCanceled;
    private boolean isRetryAllowed;
    private boolean isInErrorState;
    private boolean isDisposed;
    private String title = "";
    private String message = "";
    private CopyOnWriteList messageHistory = new CopyOnWriteList();
    private String detailMessage = "";
    private String errorMessage = "";
    private String name = "";
    private Image image = null;
    private String reporterType = "default.reporter.type";
    private IProgressReport latestProgressReport = null;
    private CopyOnWriteList reporterListeners = null;
    private Object objectData = null;
    private int messageHistoryLimit = 1000;
    private boolean isActive = true;
    private boolean cancelCloses = false;

    protected ProgressReporter(ProgressReportingManager manager) {
        this(manager, null);
    }

    protected ProgressReporter(ProgressReportingManager _manager, String name) {
        this.manager = _manager;
        this.name = name;
        this.ID = this.manager.getNextAvailableID();
    }

    @Override
    public void setReporterType(String reporterType) {
        this.reporterType = reporterType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            if (this.isDisposed) {
                return;
            }
            this.isDisposed = true;
            this.isActive = false;
        }
        this.latestReportType = 7;
        this.notifyListeners(this.getProgressReport());
        if (null != this.reporterListeners) {
            this.reporterListeners.clear();
        }
        this.manager.notifyManager(this);
    }

    private void reInit() {
        this.isActive = true;
        this.isCanceled = false;
        this.isDone = false;
        this.isInErrorState = false;
        this.errorMessage = "";
        this.message = "";
        this.detailMessage = "";
        this.messageHistory.clear();
    }

    private void notifyListeners(IProgressReport report) {
        if (null == this.reporterListeners || this.reporterListeners.size() < 1) {
            return;
        }
        ArrayList<IProgressReporterListener> removalList = new ArrayList<IProgressReporterListener>();
        for (IProgressReporterListener listener : this.reporterListeners) {
            try {
                if (1 != listener.report(report)) continue;
                removalList.add(listener);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        Iterator<Object> iterator = removalList.iterator();
        while (iterator.hasNext()) {
            this.reporterListeners.remove(iterator.next());
        }
    }

    private void updateAndNotify(int eventType) {
        this.latestReportType = eventType;
        this.latestProgressReport = new ProgressReport();
        this.manager.notifyManager(this);
        if (eventType == 6 && this.isCanceled) {
            return;
        }
        this.notifyListeners(this.latestProgressReport);
    }

    @Override
    public void setSelection(int selection, String message) {
        if (this.shouldIgnore()) {
            return;
        }
        this.message = message;
        if (selection >= this.maximum) {
            this.setDone();
            return;
        }
        if (selection < this.minimum) {
            this.percentage = 0;
            this.selection = this.minimum;
            this.isIndeterminate = true;
            return;
        }
        this.selection = selection;
        this.percentage = selection * 100 / (this.maximum - this.minimum);
        this.isDone = false;
        this.isPercentageInUse = false;
        this.isIndeterminate = false;
        if (null != message && message.length() > 0) {
            this.addToMessageHistory(message, 2);
        }
        this.updateAndNotify(6);
    }

    @Override
    public void setPercentage(int percentage, String message) {
        if (this.shouldIgnore()) {
            return;
        }
        this.message = message;
        if (percentage >= 100) {
            this.setDone();
            return;
        }
        if (percentage < 0) {
            percentage = 0;
            this.selection = this.minimum;
            this.isIndeterminate = true;
            return;
        }
        this.minimum = 0;
        this.maximum = 100;
        this.percentage = percentage;
        this.selection = percentage;
        this.isDone = false;
        this.isPercentageInUse = true;
        this.isIndeterminate = false;
        if (null != message && message.length() > 0) {
            this.addToMessageHistory(message, 2);
        }
        this.updateAndNotify(6);
    }

    @Override
    public void setIndeterminate(boolean isIndeterminate) {
        if (this.shouldIgnore()) {
            return;
        }
        this.isIndeterminate = isIndeterminate;
        if (isIndeterminate) {
            this.minimum = 0;
            this.maximum = 0;
        }
        this.updateAndNotify(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDone() {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            if (this.shouldIgnore()) {
                return;
            }
            this.isDone = true;
            this.isActive = false;
        }
        this.selection = this.maximum;
        this.percentage = 100;
        this.isIndeterminate = false;
        this.message = MessageText.getString("Progress.reporting.status.finished");
        this.addToMessageHistory(this.message, 8);
        this.updateAndNotify(2);
    }

    @Override
    public void setMessage(String message) {
        if (this.shouldIgnore()) {
            return;
        }
        this.message = message;
        this.addToMessageHistory(message, 2);
        this.updateAndNotify(6);
    }

    @Override
    public void appendDetailMessage(String detailMessage) {
        if (this.shouldIgnore()) {
            return;
        }
        this.detailMessage = detailMessage;
        this.addToMessageHistory(detailMessage, 8);
        this.updateAndNotify(6);
        this.detailMessage = "";
    }

    @Override
    public void setMinimum(int min) {
        if (this.shouldIgnore()) {
            return;
        }
        this.minimum = min;
        this.updateAndNotify(6);
    }

    @Override
    public void setMaximum(int max) {
        if (this.shouldIgnore()) {
            return;
        }
        this.maximum = max;
        this.updateAndNotify(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            if (this.isCanceled || this.shouldIgnore()) {
                return;
            }
            this.isCanceled = true;
            this.isActive = false;
        }
        this.message = MessageText.getString("Progress.reporting.status.canceled");
        this.addToMessageHistory(this.message, 8);
        this.updateAndNotify(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retry() {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            if (this.shouldIgnore()) {
                return;
            }
            this.reInit();
        }
        this.message = MessageText.getString("Progress.reporting.status.retrying");
        this.addToMessageHistory(this.message, 8);
        this.updateAndNotify(5);
    }

    @Override
    public void setCancelAllowed(boolean cancelAllowed) {
        if (this.shouldIgnore()) {
            return;
        }
        this.isCancelAllowed = cancelAllowed;
        this.updateAndNotify(6);
    }

    @Override
    public void setName(String name) {
        if (this.shouldIgnore()) {
            return;
        }
        this.name = name + "";
        this.updateAndNotify(6);
    }

    @Override
    public void setTitle(String title) {
        if (this.shouldIgnore()) {
            return;
        }
        this.title = title;
        this.updateAndNotify(6);
    }

    @Override
    public void setImage(Image image) {
        if (this.shouldIgnore()) {
            return;
        }
        this.image = image;
        this.updateAndNotify(6);
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        if (this.shouldIgnore()) {
            return;
        }
        if (null != this.errorMessage && this.errorMessage.equals(errorMessage)) {
            return;
        }
        this.errorMessage = null == errorMessage || errorMessage.length() < 1 ? MessageText.getString("Progress.reporting.default.error") : errorMessage;
        this.isInErrorState = true;
        this.isActive = false;
        this.addToMessageHistory(this.errorMessage, 4);
        this.updateAndNotify(4);
    }

    @Override
    public void setRetryAllowed(boolean retryOnError) {
        if (this.shouldIgnore()) {
            return;
        }
        this.isRetryAllowed = retryOnError;
    }

    private boolean shouldIgnore() {
        return this.isDisposed || this.isDone;
    }

    @Override
    public boolean getCancelCloses() {
        return this.cancelCloses;
    }

    @Override
    public void setCancelCloses(boolean b) {
        this.cancelCloses = b;
    }

    private void addToMessageHistory(String value, int type) {
        if (this.messageHistory.size() >= this.messageHistoryLimit) {
            return;
        }
        if (this.messageHistory.size() < this.messageHistoryLimit) {
            this.messageHistory.add(new ProgressReportMessage(value, type));
        }
        if (this.messageHistory.size() == this.messageHistoryLimit) {
            Debug.out(MessageText.getString("Progress.reporting.detail.history.limit", new String[]{this.messageHistoryLimit + ""}));
        }
    }

    @Override
    public void setObjectData(Object objectData) {
        if (this.shouldIgnore()) {
            return;
        }
        this.objectData = objectData;
    }

    @Override
    public IMessage[] getMessageHistory() {
        List<IMessage> tmp = this.messageHistory.getList();
        return tmp.toArray(new IMessage[tmp.size()]);
    }

    @Override
    public void addListener(IProgressReporterListener listener) {
        if (this.shouldIgnore()) {
            return;
        }
        if (null != listener) {
            if (null == this.reporterListeners) {
                this.reporterListeners = new CopyOnWriteList();
                this.reporterListeners.add(listener);
            } else if (!this.reporterListeners.contains(listener)) {
                this.reporterListeners.add(listener);
            }
        }
    }

    @Override
    public void removeListener(IProgressReporterListener listener) {
        if (null == this.reporterListeners) {
            return;
        }
        this.reporterListeners.remove(listener);
    }

    public int compareTo(Object obj) {
        if (obj instanceof IProgressReporter) {
            return this.ID < obj.hashCode() ? -1 : (this.ID == obj.hashCode() ? 0 : 1);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IProgressReporter) {
            return this.ID == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.ID;
    }

    @Override
    public IProgressReport getProgressReport() {
        if (null == this.latestProgressReport) {
            this.latestProgressReport = new ProgressReport();
        }
        return this.latestProgressReport;
    }

    public class ProgressReport
    implements IProgressReport {
        private final String reporterType;
        private final int reporterID;
        private final int minimum;
        private final int maximum;
        private final int selection;
        private final int percentage;
        private final boolean isActive;
        private final boolean isIndeterminate;
        private final boolean isDone;
        private final boolean isPercentageInUse;
        private final boolean isCancelAllowed;
        public final boolean isCanceled;
        private final boolean isRetryAllowed;
        private final boolean isInErrorState;
        private final boolean isDisposed;
        private final String title;
        private final String message;
        private final String detailMessage;
        private final String errorMessage;
        private final String name;
        private final Image image;
        private final Object objectData;
        private final int REPORT_TYPE;

        private ProgressReport() {
            this.reporterType = ProgressReporter.this.reporterType;
            this.reporterID = ProgressReporter.this.ID;
            this.minimum = ProgressReporter.this.minimum;
            this.maximum = ProgressReporter.this.maximum;
            this.selection = ProgressReporter.this.selection;
            this.percentage = ProgressReporter.this.percentage;
            this.isActive = ProgressReporter.this.isActive;
            this.isIndeterminate = ProgressReporter.this.isIndeterminate;
            this.isDone = ProgressReporter.this.isDone;
            this.isPercentageInUse = ProgressReporter.this.isPercentageInUse;
            this.isCancelAllowed = ProgressReporter.this.isCancelAllowed;
            this.isCanceled = ProgressReporter.this.isCanceled;
            this.isRetryAllowed = ProgressReporter.this.isRetryAllowed;
            this.isInErrorState = ProgressReporter.this.isInErrorState;
            this.isDisposed = ProgressReporter.this.isDisposed;
            this.title = ProgressReporter.this.title;
            this.message = ProgressReporter.this.message;
            this.detailMessage = ProgressReporter.this.detailMessage;
            this.errorMessage = ProgressReporter.this.errorMessage;
            this.name = ProgressReporter.this.name;
            this.image = ProgressReporter.this.image;
            this.objectData = ProgressReporter.this.objectData;
            this.REPORT_TYPE = ProgressReporter.this.latestReportType;
        }

        @Override
        public IProgressReporter getReporter() {
            return ProgressReporter.this;
        }

        @Override
        public String getReporterType() {
            return this.reporterType;
        }

        @Override
        public int getReporterID() {
            return this.reporterID;
        }

        @Override
        public int getMinimum() {
            return this.minimum;
        }

        @Override
        public int getMaximum() {
            return this.maximum;
        }

        @Override
        public int getSelection() {
            return this.selection;
        }

        @Override
        public int getPercentage() {
            return this.percentage;
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public boolean isIndeterminate() {
            return this.isIndeterminate;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public boolean isPercentageInUse() {
            return this.isPercentageInUse;
        }

        @Override
        public boolean isCancelAllowed() {
            return this.isCancelAllowed;
        }

        @Override
        public boolean isCanceled() {
            return this.isCanceled;
        }

        @Override
        public boolean isRetryAllowed() {
            return this.isRetryAllowed;
        }

        @Override
        public boolean isInErrorState() {
            return this.isInErrorState;
        }

        @Override
        public boolean isDisposed() {
            return this.isDisposed;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String getDetailMessage() {
            return this.detailMessage;
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Image getImage() {
            return this.image;
        }

        @Override
        public Object getObjectData() {
            return this.objectData;
        }

        @Override
        public int getReportType() {
            return this.REPORT_TYPE;
        }
    }
}

