/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsinstaller;

import com.aelitis.azureus.core.AzureusCore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallerListener;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWListPanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWModePanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class InstallPluginWizard
extends Wizard {
    int mode;
    StandardPlugin[] standard_plugins;
    List<InstallablePlugin> plugins = new ArrayList<InstallablePlugin>();
    boolean shared = false;
    String list_title_text;

    public static void register(AzureusCore core, final Display display) {
        core.getPluginManager().getPluginInstaller().addListener(new PluginInstallerListener(){

            @Override
            public boolean installRequest(final String reason, final InstallablePlugin plugin) throws PluginException {
                if (plugin instanceof StandardPlugin) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            new InstallPluginWizard(reason, (StandardPlugin)plugin);
                        }
                    });
                    return true;
                }
                return false;
            }
        });
    }

    public InstallPluginWizard() {
        super("installPluginsWizard.title");
        IPWModePanel mode_panel = new IPWModePanel(this, null);
        this.setFirstPanel(mode_panel);
    }

    public InstallPluginWizard(String reason, StandardPlugin plugin) {
        super("installPluginsWizard.title");
        this.standard_plugins = new StandardPlugin[]{plugin};
        this.list_title_text = reason;
        this.plugins = new ArrayList<InstallablePlugin>();
        this.plugins.add(plugin);
        IPWListPanel list_panel = new IPWListPanel(this, null);
        this.setFirstPanel(list_panel);
    }

    protected StandardPlugin[] getStandardPlugins(AzureusCore core) throws PluginException {
        if (this.standard_plugins == null) {
            this.standard_plugins = core.getPluginManager().getPluginInstaller().getStandardPlugins();
        }
        return this.standard_plugins;
    }

    protected String getListTitleText() {
        if (this.list_title_text == null) {
            this.list_title_text = MessageText.getString("installPluginsWizard.list.loaded");
        }
        return this.list_title_text;
    }

    @Override
    public void onClose() {
        super.onClose();
    }

    public void setPluginList(List<InstallablePlugin> _plugins) {
        this.plugins = _plugins;
    }

    public List<InstallablePlugin> getPluginList() {
        return this.plugins;
    }

    public void performInstall() {
        InstallablePlugin[] ps = new InstallablePlugin[this.plugins.size()];
        this.plugins.toArray(ps);
        if (ps.length > 0) {
            try {
                ps[0].getInstaller().install(ps, this.shared);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                Logger.log(new LogAlert(true, "Failed to initialise installer", e));
            }
        }
    }
}

