/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsinstaller;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWFilePanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWListPanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class IPWModePanel
extends AbstractWizardPanel<InstallPluginWizard> {
    private static final int MODE_FROM_LIST = 0;
    private static final int MODE_FROM_FILE = 1;
    private int mode = 0;

    public IPWModePanel(InstallPluginWizard wizard, IWizardPanel<InstallPluginWizard> previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        ((InstallPluginWizard)this.wizard).setTitle(MessageText.getString("installPluginsWizard.mode.title"));
        ((InstallPluginWizard)this.wizard).setErrorMessage("");
        Composite rootPanel = ((InstallPluginWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1812);
        Utils.setLayoutData((Control)panel, gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout(layout);
        Button bListMode = new Button(panel, 16);
        Messages.setLanguageText(bListMode, "installPluginsWizard.mode.list");
        bListMode.setData("mode", new Integer(0));
        if (((InstallPluginWizard)this.wizard).mode == 0) {
            bListMode.setSelection(true);
        }
        Button bFileMode = new Button(panel, 16);
        Messages.setLanguageText(bFileMode, "installPluginsWizard.mode.file");
        bFileMode.setData("mode", new Integer(1));
        if (((InstallPluginWizard)this.wizard).mode == 1) {
            bFileMode.setSelection(true);
        }
        Listener modeListener = new Listener(){

            @Override
            public void handleEvent(Event e) {
                IPWModePanel.this.mode = (Integer)e.widget.getData("mode");
                ((InstallPluginWizard)((IPWModePanel)IPWModePanel.this).wizard).mode = IPWModePanel.this.mode;
            }
        };
        bListMode.addListener(13, modeListener);
        bFileMode.addListener(13, modeListener);
        if (userMode < 2) {
            Group cWiki = new Group(panel, 64);
            cWiki.setText(MessageText.getString("installPluginsWizard.installMode.info.title"));
            gridData = new GridData(772);
            gridData.verticalIndent = 15;
            Utils.setLayoutData((Control)cWiki, gridData);
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginHeight = 0;
            cWiki.setLayout(layout);
            gridData = new GridData(772);
            gridData.horizontalIndent = 10;
            gridData.horizontalSpan = 4;
            Label label = new Label(cWiki, 64);
            Utils.setLayoutData((Control)label, gridData);
            label.setText(MessageText.getString("installPluginsWizard.installMode.info.text"));
        }
    }

    @Override
    public IWizardPanel<InstallPluginWizard> getNextPanel() {
        switch (this.mode) {
            case 0: {
                return new IPWListPanel((InstallPluginWizard)this.wizard, this);
            }
            case 1: {
                return new IPWFilePanel((InstallPluginWizard)this.wizard, this);
            }
        }
        return null;
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }
}

