/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsinstaller;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.LinkArea;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWInstallModePanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class IPWListPanel
extends AbstractWizardPanel<InstallPluginWizard> {
    Table pluginList;
    LinkArea link_area;

    public IPWListPanel(InstallPluginWizard wizard, IWizardPanel<InstallPluginWizard> previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((InstallPluginWizard)this.wizard).setTitle(MessageText.getString("installPluginsWizard.list.title"));
        ((InstallPluginWizard)this.wizard).setErrorMessage("");
        Composite rootPanel = ((InstallPluginWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        Utils.setLayoutData((Control)panel, gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout(layout);
        final Label lblStatus = new Label(panel, 0);
        GridData data = new GridData(768);
        Utils.setLayoutData((Control)lblStatus, data);
        Messages.setLanguageText(lblStatus, "installPluginsWizard.list.loading");
        this.pluginList = new Table(panel, 68132);
        this.pluginList.setHeaderVisible(true);
        data = new GridData(768);
        data.heightHint = 120;
        Utils.setLayoutData((Control)this.pluginList, data);
        TableColumn tcName = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText(tcName, "installPluginsWizard.list.name");
        tcName.setWidth(Utils.adjustPXForDPI(200));
        TableColumn tcVersion = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText(tcVersion, "installPluginsWizard.list.version");
        tcVersion.setWidth(Utils.adjustPXForDPI(150));
        Label lblDescription = new Label(panel, 0);
        Messages.setLanguageText(lblDescription, "installPluginsWizard.list.description");
        this.link_area = new LinkArea(panel);
        data = new GridData(768);
        data.heightHint = 100;
        this.link_area.getComponent().setLayoutData(data);
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                StandardPlugin[] plugins;
                try {
                    plugins = ((InstallPluginWizard)IPWListPanel.this.wizard).getStandardPlugins(core);
                    Arrays.sort(plugins, new Comparator<StandardPlugin>(){

                        @Override
                        public int compare(StandardPlugin o1, StandardPlugin o2) {
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                    });
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    ((InstallPluginWizard)IPWListPanel.this.wizard).getDisplay().asyncExec(new AERunnable(){

                        @Override
                        public void runSupport() {
                            IPWListPanel.this.link_area.addLine(Debug.getNestedExceptionMessage(e));
                        }
                    });
                    return;
                }
                ((InstallPluginWizard)IPWListPanel.this.wizard).getDisplay().asyncExec(new AERunnable(){

                    @Override
                    public void runSupport() {
                        lblStatus.setText(((InstallPluginWizard)IPWListPanel.this.wizard).getListTitleText());
                        List<InstallablePlugin> selected_plugins = ((InstallPluginWizard)IPWListPanel.this.wizard).getPluginList();
                        for (int i = 0; i < plugins.length; ++i) {
                            StandardPlugin plugin = plugins[i];
                            if (plugin.getAlreadyInstalledPlugin() != null) continue;
                            if (IPWListPanel.this.pluginList == null || IPWListPanel.this.pluginList.isDisposed()) {
                                return;
                            }
                            TableItem item = new TableItem(IPWListPanel.this.pluginList, 0);
                            item.setData(plugin);
                            item.setText(0, plugin.getName());
                            boolean selected = false;
                            for (int j = 0; j < selected_plugins.size(); ++j) {
                                if (selected_plugins.get(j).getId() != plugin.getId()) continue;
                                selected = true;
                            }
                            item.setChecked(selected);
                            item.setText(1, plugin.getVersion());
                        }
                        if (plugins.length == 1 && IPWListPanel.this.pluginList.getItemCount() > 0) {
                            IPWListPanel.this.pluginList.select(0);
                            IPWListPanel.this.loadPluginDetails(IPWListPanel.this.pluginList.getItem(0));
                        }
                    }
                });
            }
        });
        this.pluginList.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (IPWListPanel.this.pluginList.getSelectionCount() > 0) {
                    IPWListPanel.this.loadPluginDetails(IPWListPanel.this.pluginList.getSelection()[0]);
                }
                IPWListPanel.this.updateList();
            }
        });
    }

    protected void loadPluginDetails(final TableItem selected_item) {
        this.link_area.reset();
        this.link_area.addLine(MessageText.getString("installPluginsWizard.details.loading"));
        final StandardPlugin plugin = (StandardPlugin)selected_item.getData();
        AEThread2 detailsLoader = new AEThread2("Detail Loader"){

            @Override
            public void run() {
                final String description = HTMLUtils.convertListToString(HTMLUtils.convertHTMLToText(plugin.getDescription(), ""));
                ((InstallPluginWizard)IPWListPanel.this.wizard).getDisplay().asyncExec(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (IPWListPanel.this.pluginList == null || IPWListPanel.this.pluginList.isDisposed() || IPWListPanel.this.pluginList.getSelectionCount() == 0) {
                            return;
                        }
                        if (IPWListPanel.this.pluginList.getSelection()[0] != selected_item) {
                            return;
                        }
                        IPWListPanel.this.link_area.reset();
                        IPWListPanel.this.link_area.setRelativeURLBase(plugin.getRelativeURLBase());
                        IPWListPanel.this.link_area.addLine(description);
                    }
                });
            }
        };
        detailsLoader.start();
    }

    @Override
    public boolean isNextEnabled() {
        return ((InstallPluginWizard)this.wizard).getPluginList().size() > 0;
    }

    @Override
    public IWizardPanel<InstallPluginWizard> getNextPanel() {
        return new IPWInstallModePanel((InstallPluginWizard)this.wizard, this);
    }

    public void updateList() {
        ArrayList<InstallablePlugin> list = new ArrayList<InstallablePlugin>();
        TableItem[] items = this.pluginList.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getChecked()) continue;
            list.add((InstallablePlugin)items[i].getData());
        }
        ((InstallPluginWizard)this.wizard).setPluginList(list);
        ((InstallPluginWizard)this.wizard).setNextEnabled(this.isNextEnabled());
    }
}

