/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.ui.common.ToolBarItem;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarActivationListener;

public class UIToolBarItemImpl
implements ToolBarItem {
    private String id;
    private String imageID = "image.toolbar.run";
    private String textID;
    private boolean alwaysAvailable = false;
    private long state;
    private UIToolBarActivationListener defaultActivation;
    private String tooltipID;
    private String groupID = "main";
    private List<ToolBarItem.ToolBarItemListener> toolBarItemListeners = new ArrayList<ToolBarItem.ToolBarItemListener>();
    private String toolTip;

    public UIToolBarItemImpl(String id) {
        this.id = id;
    }

    @Override
    public void addToolBarItemListener(ToolBarItem.ToolBarItemListener l) {
        if (!this.toolBarItemListeners.contains(l)) {
            this.toolBarItemListeners.add(l);
        }
    }

    @Override
    public void removeToolBarItemListener(ToolBarItem.ToolBarItemListener l) {
        this.toolBarItemListeners.remove(l);
    }

    private void triggerFieldChange() {
        ToolBarItem.ToolBarItemListener[] array;
        for (ToolBarItem.ToolBarItemListener l : array = this.toolBarItemListeners.toArray(new ToolBarItem.ToolBarItemListener[0])) {
            l.uiFieldChanged(this);
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getTextID() {
        return this.textID;
    }

    @Override
    public void setTextID(String id) {
        this.textID = id;
        this.triggerFieldChange();
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public void setImageID(String id) {
        this.imageID = id;
        this.triggerFieldChange();
    }

    @Override
    public boolean isAlwaysAvailable() {
        return this.alwaysAvailable;
    }

    @Override
    public void setAlwaysAvailable(boolean alwaysAvailable) {
        this.alwaysAvailable = alwaysAvailable;
        this.triggerFieldChange();
    }

    @Override
    public long getState() {
        return this.state;
    }

    @Override
    public void setState(long state) {
        this.state = state;
        this.triggerFieldChange();
    }

    @Override
    public boolean triggerToolBarItem(long activationType, Object datasource) {
        ToolBarItem.ToolBarItemListener[] array;
        for (ToolBarItem.ToolBarItemListener l : array = this.toolBarItemListeners.toArray(new ToolBarItem.ToolBarItemListener[0])) {
            if (!l.triggerToolBarItem(this, activationType, datasource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDefaultActivationListener(UIToolBarActivationListener defaultActivation) {
        this.defaultActivation = defaultActivation;
    }

    @Override
    public UIToolBarActivationListener getDefaultActivationListener() {
        return this.defaultActivation;
    }

    @Override
    public String getTooltipID() {
        return this.tooltipID;
    }

    public void setTooltipID(String tooltipID) {
        this.tooltipID = tooltipID;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    @Override
    public void setToolTip(String text) {
        this.toolTip = text;
    }

    @Override
    public String getToolTip() {
        return this.toolTip;
    }
}

