/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.util.MapUtils;
import java.awt.Frame;
import java.awt.Panel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarEnablerBase;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.plugins.PluginUISWTSkinObject;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventCancelledException;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.views.IViewAlwaysInitialize;

public class UISWTViewImpl
implements UISWTViewCore,
UIPluginViewToolBarListener {
    public static final String CFG_PREFIX = "Views.plugins.";
    private boolean delayInitializeToFirstActivate = true;
    private static final boolean DEBUG_TRIGGERS = false;
    protected PluginUISWTSkinObject skinObject;
    private Object initialDatasource;
    private UISWTView parentView;
    protected Object datasource;
    private boolean useCoreDataSource = false;
    private UISWTViewEventListener eventListener;
    protected Composite composite;
    protected final String id;
    private String title;
    private String titleID;
    private String setTitle;
    private String setTitleID;
    private int iControlType = 0;
    private Boolean hasFocus = null;
    private Map<Object, Object> user_data;
    private boolean haveSentInitialize = false;
    private boolean created = false;
    private String parentViewID;
    private boolean destroyOnDeactivate;
    private Composite masterComposite;
    private Set<UIPluginViewToolBarListener> setToolBarEnablers = new HashSet<UIPluginViewToolBarListener>(1);

    public UISWTViewImpl(String id, String parentViewID, boolean destroyOnDeactivate) {
        this.id = id;
        this.parentViewID = parentViewID;
        this.destroyOnDeactivate = destroyOnDeactivate;
        this.titleID = CFG_PREFIX + this.id + ".title";
        if (!MessageText.keyExists(this.titleID) && MessageText.keyExists(this.id)) {
            this.titleID = id;
        } else if (id.contains(" ")) {
            this.titleID = "!" + id + "!";
        }
    }

    public void setEventListener(UISWTViewEventListener _eventListener, boolean doCreate) throws UISWTViewEventCancelledException {
        UISWTViewEventListenerHolder h;
        UISWTViewEventListener delegatedEventListener;
        this.eventListener = _eventListener;
        if (this.eventListener == null) {
            return;
        }
        if (_eventListener instanceof UISWTViewEventListenerHolder && (delegatedEventListener = (h = (UISWTViewEventListenerHolder)_eventListener).getDelegatedEventListener(this)) != null) {
            this.eventListener = delegatedEventListener;
        }
        if (this.eventListener instanceof IViewAlwaysInitialize) {
            this.delayInitializeToFirstActivate = false;
        }
        if (this.eventListener instanceof UISWTViewCoreEventListener) {
            this.setUseCoreDataSource(true);
        }
        if (doCreate && !this.triggerBooleanEvent(0, this)) {
            throw new UISWTViewEventCancelledException();
        }
    }

    @Override
    public UISWTViewEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public Object getInitialDataSource() {
        return this.initialDatasource;
    }

    public void setDatasource(Object datasource) {
        if (this.initialDatasource == null) {
            this.initialDatasource = datasource;
        }
        this.triggerEvent(1, datasource);
    }

    @Override
    public Object getDataSource() {
        return PluginCoreUtils.convert(this.datasource, this.useCoreDataSource());
    }

    @Override
    public void setParentView(UISWTView parentView) {
        this.parentView = parentView;
    }

    @Override
    public UISWTView getParentView() {
        return this.parentView;
    }

    @Override
    public String getViewID() {
        return this.id;
    }

    @Override
    public void closeView() {
        try {
            Composite c = this.getComposite();
            if (c != null && !c.isDisposed()) {
                Composite parent = c.getParent();
                this.triggerEvent(7, null);
                if (parent instanceof CTabFolder) {
                    for (CTabItem item : ((CTabFolder)parent).getItems()) {
                        if (item.getControl() != c) continue;
                        item.dispose();
                    }
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public void setControlType(int iControlType) {
        if (iControlType == 1 || iControlType == 0 || iControlType == 257) {
            this.iControlType = iControlType;
        }
    }

    @Override
    public int getControlType() {
        return this.iControlType;
    }

    @Override
    public void triggerEvent(int eventType, Object data) {
        try {
            this.triggerBooleanEvent(eventType, data);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    private boolean triggerBooleanEvent(int eventType, Object data) {
        if (eventType == 6) {
            this.titleID = CFG_PREFIX + this.id + ".title";
            if (!MessageText.keyExists(this.titleID) && MessageText.keyExists(this.id)) {
                this.titleID = this.id;
            } else if (this.id.contains(" ")) {
                this.titleID = "!" + this.id + "!";
            }
            this.title = null;
            if (this.setTitleID != null) {
                this.setTitleID(this.setTitleID);
            }
            if (this.setTitle != null) {
                this.setTitle(this.setTitle);
            }
            this.refreshTitle();
            Messages.updateLanguageForControl(this.getComposite());
        }
        if (this.eventListener == null && eventType != 1) {
            return false;
        }
        if (eventType == 2) {
            if (this.haveSentInitialize) {
                return false;
            }
            if (!this.created) {
                this.triggerBooleanEvent(0, this);
            } else if (this.datasource != null) {
                this.triggerBooleanEvent(1, this.datasource);
            }
            this.haveSentInitialize = true;
        }
        if (eventType == 0) {
            this.created = true;
        }
        if (this.delayInitializeToFirstActivate && eventType == 3 && !this.haveSentInitialize) {
            this.swt_triggerInitialize();
        }
        if (eventType == 3 && this.hasFocus != null && this.hasFocus.booleanValue()) {
            return true;
        }
        if (eventType == 4 && this.hasFocus != null && !this.hasFocus.booleanValue()) {
            return true;
        }
        if (eventType == 1) {
            Object newDataSource = PluginCoreUtils.convert(data, true);
            if (this.datasource == newDataSource) {
                return true;
            }
            if (newDataSource instanceof Object[] && this.datasource instanceof Object[] && Arrays.equals((Object[])newDataSource, (Object[])this.datasource)) {
                return true;
            }
            this.datasource = newDataSource;
            data = PluginCoreUtils.convert(this.datasource, this.useCoreDataSource);
            if (this.initialDatasource == null) {
                this.initialDatasource = this.datasource;
            }
            if (this.eventListener == null) {
                return true;
            }
        } else if (eventType == 9 && this.eventListener instanceof ObfusticateImage) {
            if (data instanceof Map) {
                ((ObfusticateImage)((Object)this.eventListener)).obfusticatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        } else if (eventType == 3) {
            this.hasFocus = true;
            if (!this.haveSentInitialize) {
                this.swt_triggerInitialize();
            }
        } else if (eventType == 4) {
            this.hasFocus = false;
            if (this.isDestroyOnDeactivate()) {
                this.triggerEvent(7, null);
            }
        } else if (eventType == 7) {
            if (this.hasFocus != null && this.hasFocus.booleanValue()) {
                this.triggerEvent(4, null);
            }
            if (!this.created && !this.haveSentInitialize && this.getComposite() == null) {
                return true;
            }
        }
        boolean result = false;
        try {
            result = this.eventListener.eventOccurred(new UISWTViewEventImpl(this.parentViewID, this, eventType, data));
        }
        catch (Throwable t) {
            Debug.out("ViewID=" + this.id + "; EventID=" + UISWTViewEvent.DEBUG_TYPES[eventType] + "; data=" + data, t);
        }
        if (eventType == 7) {
            if (this.masterComposite != null && !this.masterComposite.isDisposed()) {
                Composite parent = this.masterComposite.getParent();
                Utils.disposeComposite(this.masterComposite);
                Utils.relayoutUp(parent);
            }
            this.masterComposite = null;
            this.composite = null;
            this.haveSentInitialize = false;
            this.hasFocus = false;
            this.created = false;
            this.initialDatasource = this.datasource;
            this.datasource = null;
        } else if (eventType == 0) {
            UISWTViewEventListenerHolder h;
            UISWTViewEventListener delegatedEventListener;
            if (this.eventListener instanceof UISWTViewEventListenerHolder && (delegatedEventListener = (h = (UISWTViewEventListenerHolder)this.eventListener).getDelegatedEventListener(this)) != null) {
                try {
                    this.setEventListener(delegatedEventListener, false);
                }
                catch (UISWTViewEventCancelledException e) {
                    // empty catch block
                }
            }
            this.triggerEventRaw(1, PluginCoreUtils.convert(this.datasource, this.useCoreDataSource));
        }
        return result;
    }

    protected boolean triggerEventRaw(int eventType, Object data) {
        if (this.eventListener == null) {
            System.err.println("null eventListener for " + UISWTViewEvent.DEBUG_TYPES[eventType] + " " + Debug.getCompressedStackTrace());
            return eventType == 8;
        }
        try {
            return this.eventListener.eventOccurred(new UISWTViewEventImpl(this.parentViewID, this, eventType, data));
        }
        catch (Throwable t) {
            throw new UIRuntimeException("UISWTView.triggerEvent:: ViewID=" + this.id + "; EventID=" + eventType + "; data=" + data, t);
        }
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            return;
        }
        this.setTitle = title;
        if (title.startsWith("{") && title.endsWith("}") && title.length() > 2) {
            this.setTitleID(title.substring(1, title.length() - 1));
            return;
        }
        if (title.equals(this.title)) {
            return;
        }
        if (title.contains(".") && MessageText.keyExists(title)) {
            this.setTitleID(title);
            return;
        }
        this.title = title;
        this.titleID = null;
    }

    public void setTitleID(String titleID) {
        if (titleID != null && (MessageText.keyExists(titleID) || titleID.startsWith("!"))) {
            this.setTitleID = titleID;
            this.titleID = titleID;
            this.title = null;
        }
    }

    protected void refreshTitle() {
    }

    @Override
    public PluginInterface getPluginInterface() {
        if (this.eventListener instanceof UISWTViewEventListenerHolder) {
            return ((UISWTViewEventListenerHolder)this.eventListener).getPluginInterface();
        }
        return null;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public String getTitleID() {
        if (this.title == null) {
            if (MessageText.keyExists(this.id)) {
                return this.id;
            }
            String id = CFG_PREFIX + this.id + ".title";
            if (MessageText.keyExists(id)) {
                return id;
            }
            return "!" + id + "!";
        }
        return "!" + this.title + "!";
    }

    @Override
    public String getFullTitle() {
        if (this.titleID != null) {
            return MessageText.getString(this.titleID);
        }
        return this.title;
    }

    @Override
    public void initialize(Composite parent) {
        this.masterComposite = parent;
        if (this.iControlType == 0) {
            Layout parentLayout = parent.getLayout();
            if (parentLayout instanceof FormLayout) {
                this.composite = parent;
            } else {
                this.composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(1, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                this.composite.setLayout(layout);
                GridData gridData = new GridData(1808);
                this.composite.setLayoutData(gridData);
            }
            Listener showListener = new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    CTabFolder tabFolder;
                    Control selectedControl;
                    if (UISWTViewImpl.this.composite == null || UISWTViewImpl.this.composite.isDisposed()) {
                        return;
                    }
                    Composite parent = UISWTViewImpl.this.composite.getParent();
                    if (parent instanceof CTabFolder ? (selectedControl = (tabFolder = (CTabFolder)parent).getSelection().getControl()) != UISWTViewImpl.this.composite : parent instanceof TabFolder && (selectedControl = (tabFolder = (TabFolder)parent).getSelection()) != null && selectedControl.length == 1 && selectedControl[0].getControl() != UISWTViewImpl.this.composite) {
                        return;
                    }
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        @Override
                        public void runSupport() {
                            UISWTViewImpl.this.triggerEvent(3, null);
                        }
                    });
                }
            };
            this.composite.addListener(22, showListener);
            if (parent != this.composite) {
                parent.addListener(22, showListener);
            }
            if (this.composite.isVisible()) {
                boolean focusGained = true;
                if (parent instanceof CTabFolder || parent instanceof TabFolder) {
                    focusGained = false;
                }
                if (focusGained) {
                    this.triggerEvent(3, null);
                }
            }
            if (this.delayInitializeToFirstActivate) {
                return;
            }
            this.swt_triggerInitialize();
        } else if (this.iControlType == 1) {
            this.composite = new Composite(parent, 0x1000000);
            FillLayout layout = new FillLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout(layout);
            GridData gridData = new GridData(1808);
            this.composite.setLayoutData(gridData);
            Frame f = SWT_AWT.new_Frame(this.composite);
            Panel pan = new Panel();
            f.add(pan);
            this.triggerEvent(2, pan);
        } else if (this.iControlType == 257) {
            this.triggerEvent(2, this.getPluginSkinObject());
        }
    }

    private void swt_triggerInitialize() {
        if (this.haveSentInitialize) {
            return;
        }
        if (!this.created) {
            this.triggerBooleanEvent(0, this);
        }
        if (this.composite != null) {
            this.composite.setRedraw(false);
            this.composite.setLayoutDeferred(true);
            this.triggerEvent(2, this.composite);
            if (this.composite.getLayout() instanceof GridLayout) {
                Control[] children = this.composite.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    Control control = children[i];
                    Object layoutData = control.getLayoutData();
                    if (layoutData != null && layoutData instanceof GridData) continue;
                    if (layoutData != null) {
                        Logger.log(new LogEvent(LogIDs.PLUGIN, 1, "Plugin View '" + this.id + "' tried to setLayoutData of " + control + " to a " + layoutData.getClass().getName()));
                    }
                    GridData gridData = children.length == 1 ? new GridData(4, 4, true, true) : new GridData();
                    control.setLayoutData(gridData);
                }
            }
            this.composite.layout();
            this.composite.setLayoutDeferred(false);
            this.composite.setRedraw(true);
        }
    }

    @Override
    public boolean useCoreDataSource() {
        return this.useCoreDataSource;
    }

    @Override
    public void setUseCoreDataSource(boolean useCoreDataSource) {
        if (this.useCoreDataSource == useCoreDataSource) {
            return;
        }
        this.useCoreDataSource = useCoreDataSource;
        if (this.datasource != null) {
            this.setDatasource(this.datasource);
        }
    }

    @Override
    public PluginUISWTSkinObject getPluginSkinObject() {
        return this.skinObject;
    }

    @Override
    public void setPluginSkinObject(PluginUISWTSkinObject so) {
        this.skinObject = so;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        UIToolBarEnablerBase[] toolbarEnablers;
        for (UIToolBarEnablerBase tbEnablerBase : toolbarEnablers = this.getToolbarEnablers()) {
            UIPluginViewToolBarListener tbEnabler;
            if (!(tbEnablerBase instanceof UIPluginViewToolBarListener) || !(tbEnabler = (UIPluginViewToolBarListener)tbEnablerBase).toolBarItemActivated(item, activationType, datasource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        UIToolBarEnablerBase[] toolbarEnablers;
        for (UIToolBarEnablerBase tbEnablerBase : toolbarEnablers = this.getToolbarEnablers()) {
            if (!(tbEnablerBase instanceof UIPluginViewToolBarListener)) continue;
            UIPluginViewToolBarListener tbEnabler = (UIPluginViewToolBarListener)tbEnablerBase;
            tbEnabler.refreshToolBarItems(list);
        }
    }

    @Override
    public void setToolBarListener(UIPluginViewToolBarListener l) {
        this.addToolbarEnabler(l);
    }

    @Override
    public UIPluginViewToolBarListener getToolBarListener() {
        return this.setToolBarEnablers.size() == 0 ? null : this.setToolBarEnablers.iterator().next();
    }

    public UIToolBarEnablerBase[] getToolbarEnablers() {
        return this.setToolBarEnablers.toArray(new UIToolBarEnablerBase[0]);
    }

    public boolean hasToolbarEnableers() {
        return this.setToolBarEnablers.size() > 0;
    }

    public void addToolbarEnabler(UIToolBarEnablerBase enabler) {
        if (this.setToolBarEnablers.contains(enabler)) {
            return;
        }
        this.setToolBarEnablers.add((UIPluginViewToolBarListener)enabler);
        this.setToolbarVisibility(this.setToolBarEnablers.size() > 0);
    }

    public void removeToolbarEnabler(UIToolBarEnablerBase enabler) {
        this.setToolBarEnablers.remove(enabler);
        this.setToolbarVisibility(this.setToolBarEnablers.size() > 0);
    }

    protected void setToolbarVisibility(boolean visible) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object data) {
        UISWTViewImpl uISWTViewImpl = this;
        synchronized (uISWTViewImpl) {
            if (this.user_data == null) {
                this.user_data = new LightHashMap<Object, Object>();
            }
            if (data == null) {
                this.user_data.remove(key);
                if (this.user_data.isEmpty()) {
                    this.user_data = null;
                }
            } else {
                this.user_data.put(key, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        UISWTViewImpl uISWTViewImpl = this;
        synchronized (uISWTViewImpl) {
            if (this.user_data == null) {
                return null;
            }
            return this.user_data.get(key);
        }
    }

    @Override
    public void setDestroyOnDeactivate(boolean b) {
        this.destroyOnDeactivate = b;
    }

    @Override
    public boolean isDestroyOnDeactivate() {
        return this.destroyOnDeactivate;
    }

    public boolean isDelayInitializeToFirstActivate() {
        return this.delayInitializeToFirstActivate;
    }

    public void setDelayInitializeToFirstActivate(boolean delayInitializeToFirstActivate) {
        this.delayInitializeToFirstActivate = delayInitializeToFirstActivate;
    }
}

