/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.menus.MenuContext;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuContextImpl;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntry;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntryListener;

public class UISWTStatusEntryImpl
implements UISWTStatusEntry,
IMainStatusBar.CLabelUpdater {
    private AEMonitor this_mon = new AEMonitor("UISWTStatusEntryImpl@" + Integer.toHexString(this.hashCode()));
    private UISWTStatusEntryListener listener = null;
    private MenuContextImpl menu_context = MenuContextImpl.create("status_entry");
    private boolean needs_update = false;
    private boolean needs_layout = false;
    private String text = null;
    private String tooltip = null;
    private boolean image_enabled = false;
    private Image original_image = null;
    private boolean check_scaled_image;
    private Image scaled_image = null;
    private boolean is_visible = false;
    private boolean needs_disposing = false;
    private boolean is_destroyed = false;
    private Menu menu;
    private CopyOnWriteArrayList<String> imageIDstoDispose = new CopyOnWriteArrayList();
    private String imageID = null;

    private void checkDestroyed() {
        if (this.is_destroyed) {
            throw new RuntimeException("object is destroyed, cannot be reused");
        }
    }

    @Override
    public MenuContext getMenuContext() {
        return this.menu_context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(MainStatusBar.CLabelPadding label) {
        if (this.needs_disposing && !label.isDisposed()) {
            if (this.menu != null && !this.menu.isDisposed()) {
                this.menu.dispose();
                this.menu = null;
            }
            label.dispose();
            if (this.imageID != null) {
                this.imageIDstoDispose.add(this.imageID);
            }
            this.releaseOldImages();
            if (this.scaled_image != null) {
                this.scaled_image.dispose();
                this.scaled_image = null;
            }
            return true;
        }
        boolean do_layout = this.needs_layout;
        this.needs_layout = false;
        if (this.menu_context.is_dirty) {
            this.needs_update = true;
            this.menu_context.is_dirty = false;
        }
        if (!this.needs_update) {
            return do_layout;
        }
        try {
            this.this_mon.enter();
            this.update0(label);
        }
        finally {
            this.this_mon.exit();
        }
        return do_layout;
    }

    private void releaseOldImages() {
        if (this.imageIDstoDispose.size() > 0) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            Iterator<String> iter = this.imageIDstoDispose.iterator();
            while (iter.hasNext()) {
                String id = iter.next();
                imageLoader.releaseImage(id);
                iter.remove();
            }
        }
    }

    private void update0(MainStatusBar.CLabelPadding label) {
        label.setText(this.text);
        label.setToolTipText(this.tooltip);
        if (this.check_scaled_image) {
            this.check_scaled_image = false;
            if (this.scaled_image != null) {
                this.scaled_image.dispose();
                this.scaled_image = null;
            }
            if (this.original_image != null && Utils.adjustPXForDPIRequired(this.original_image)) {
                this.scaled_image = Utils.adjustPXForDPI(label.getDisplay(), this.original_image);
            }
        }
        label.setImage(this.image_enabled ? (this.scaled_image == null ? this.original_image : this.scaled_image) : null);
        label.setVisible(this.is_visible);
        this.releaseOldImages();
        MenuItem[] items = MenuItemManager.getInstance().getAllAsArray(this.menu_context.context);
        if (items.length > 0 & this.menu == null) {
            this.menu = new Menu(label);
            label.setMenu(this.menu);
            MenuBuildUtils.addMaintenanceListenerForMenu(this.menu, new MenuBuildUtils.MenuBuilder(){

                @Override
                public void buildMenu(Menu menu, MenuEvent menuEvent) {
                    MenuItem[] items = MenuItemManager.getInstance().getAllAsArray(((UISWTStatusEntryImpl)UISWTStatusEntryImpl.this).menu_context.context);
                    MenuBuildUtils.addPluginMenuItems(items, menu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
                }
            });
        } else if (this.menu != null && items.length == 0) {
            label.setMenu(null);
            if (!this.menu.isDisposed()) {
                this.menu.dispose();
            }
            this.menu = null;
        }
        this.needs_update = false;
    }

    void onClick() {
        UISWTStatusEntryListener listener0 = this.listener;
        if (listener0 != null) {
            this.listener.entryClicked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            this.this_mon.enter();
            this.is_visible = false;
            this.listener = null;
            this.original_image = null;
            this.needs_disposing = true;
            this.is_destroyed = true;
            MenuItemManager.getInstance().removeAllMenuItems(this.menu_context.context);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setImage(int image_id) {
        if (this.imageID != null) {
            this.imageIDstoDispose.add(this.imageID);
        }
        switch (image_id) {
            case 3: {
                this.imageID = "greenled";
                break;
            }
            case 1: {
                this.imageID = "redled";
                break;
            }
            case 2: {
                this.imageID = "yellowled";
                break;
            }
            default: {
                this.imageID = "grayled";
            }
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.setImage(imageLoader.getImage(this.imageID));
    }

    @Override
    public void setImage(Image image) {
        this.checkDestroyed();
        this.this_mon.enter();
        if (image != this.original_image) {
            this.needs_layout = true;
            this.check_scaled_image = true;
            this.original_image = image;
        }
        this.needs_update = true;
        this.this_mon.exit();
    }

    @Override
    public void setImageEnabled(boolean enabled) {
        this.checkDestroyed();
        this.this_mon.enter();
        if (enabled != this.image_enabled) {
            this.needs_layout = true;
        }
        this.image_enabled = enabled;
        this.needs_update = true;
        this.this_mon.exit();
    }

    @Override
    public void setListener(UISWTStatusEntryListener listener) {
        this.checkDestroyed();
        this.listener = listener;
    }

    @Override
    public void setText(String text) {
        this.checkDestroyed();
        this.this_mon.enter();
        this.text = text;
        this.needs_update = true;
        this.this_mon.exit();
    }

    @Override
    public void setTooltipText(String text) {
        this.checkDestroyed();
        this.this_mon.enter();
        this.tooltip = text;
        this.needs_update = true;
        this.this_mon.exit();
    }

    @Override
    public void setVisible(boolean visible) {
        this.checkDestroyed();
        this.this_mon.enter();
        if (this.is_visible != visible) {
            this.needs_layout = true;
        }
        this.is_visible = visible;
        this.needs_update = true;
        this.this_mon.exit();
    }

    @Override
    public void created(final MainStatusBar.CLabelPadding label) {
        final Listener click_listener = new Listener(){

            @Override
            public void handleEvent(Event e) {
                UISWTStatusEntryImpl.this.onClick();
            }
        };
        Utils.execSWTThread((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                label.addListener(8, click_listener);
            }
        }, true);
    }
}

