/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.networks;

import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AENetworkClassifierListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class SWTNetworkSelection
implements AENetworkClassifierListener {
    public SWTNetworkSelection() {
        AENetworkClassifier.addListener(this);
    }

    @Override
    public String[] selectNetworks(final String description, final String[] tracker_networks) {
        final Display display = SWTThread.getInstance().getDisplay();
        if (display.isDisposed()) {
            return null;
        }
        final AESemaphore sem = new AESemaphore("NetworkClassifier");
        final classifierDialog[] dialog = new classifierDialog[1];
        try {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    dialog[0] = new classifierDialog(sem, display, description, tracker_networks);
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
        sem.reserve();
        return dialog[0].getSelection();
    }

    protected static class classifierDialog {
        protected Shell shell;
        protected AESemaphore sem;
        protected String[] selection;
        private Button[] checkboxes;

        protected classifierDialog(AESemaphore _sem, Display display, String description, String[] tracker_networks) {
            this.sem = _sem;
            if (display.isDisposed()) {
                this.sem.releaseForever();
                return;
            }
            this.shell = ShellFactory.createMainShell(67680);
            Utils.setShellIcon(this.shell);
            this.shell.setText(MessageText.getString("window.networkselection.title"));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout(layout);
            Label info_label = new Label(this.shell, 0);
            info_label.setText(MessageText.getString("window.networkselection.info"));
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)info_label, gridData);
            Label labelSeparator = new Label(this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)labelSeparator, gridData);
            Label desc_label = new Label(this.shell, 0);
            desc_label.setText(MessageText.getString("window.networkselection.description"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)desc_label, gridData);
            Label desc_value = new Label(this.shell, 0);
            desc_value.setText(description);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)desc_value, gridData);
            this.checkboxes = new Button[AENetworkClassifier.AT_NETWORKS.length];
            for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                String network = AENetworkClassifier.AT_NETWORKS[i];
                String msg_text = "ConfigView.section.connection.networks." + network;
                Label label = new Label(this.shell, 0);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                Utils.setLayoutData((Control)label, gridData);
                Messages.setLanguageText(label, msg_text);
                Button checkBox = new Button(this.shell, 32);
                checkBox.setSelection(false);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                Utils.setLayoutData((Control)checkBox, gridData);
                this.checkboxes[i] = checkBox;
                for (int j = 0; j < tracker_networks.length; ++j) {
                    if (tracker_networks[j] != network) continue;
                    checkBox.setSelection(true);
                }
            }
            labelSeparator = new Label(this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)labelSeparator, gridData);
            new Label(this.shell, 0);
            Button bOk = new Button(this.shell, 8);
            bOk.setText(MessageText.getString("Button.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bOk, gridData);
            bOk.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    classifierDialog.this.close(true);
                }
            });
            Button bCancel = new Button(this.shell, 8);
            bCancel.setText(MessageText.getString("Button.cancel"));
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bCancel, gridData);
            bCancel.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    classifierDialog.this.close(false);
                }
            });
            this.shell.setDefaultButton(bOk);
            this.shell.addListener(31, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        classifierDialog.this.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (display.isDisposed() || display.readAndDispatch()) continue;
                display.sleep();
            }
        }

        protected void close(boolean ok) {
            if (!ok) {
                this.selection = null;
            } else {
                ArrayList<String> l = new ArrayList<String>();
                for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                    if (!this.checkboxes[i].getSelection()) continue;
                    l.add(AENetworkClassifier.AT_NETWORKS[i]);
                }
                this.selection = new String[l.size()];
                l.toArray(this.selection);
            }
            this.shell.dispose();
            this.sem.releaseForever();
        }

        protected String[] getSelection() {
            return this.selection;
        }
    }
}

