/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.minibar;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import java.util.ArrayList;
import java.util.ListIterator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.minibar.MiniBar;

public class MiniBarManager
implements UIUpdatable {
    private boolean global;
    private String type;
    private ArrayList minibars = new ArrayList();
    private static final AEMonitor minibars_mon = new AEMonitor("MiniBarManager");
    private final ShellManager shellManager = new ShellManager();
    private static MiniBarManager global_instance = new MiniBarManager();

    public static MiniBarManager getManager() {
        return global_instance;
    }

    MiniBarManager(String type) {
        this.global = false;
        this.type = type;
    }

    private MiniBarManager() {
        this.global = true;
        this.type = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(MiniBar bar) {
        this.shellManager.addWindow(bar.getShell());
        try {
            minibars_mon.enter();
            this.minibars.add(bar);
            if (!this.global) {
                global_instance.register(bar);
            }
        }
        finally {
            minibars_mon.exit();
        }
        if (this.minibars.size() == 1) {
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(this);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(MiniBar bar) {
        try {
            minibars_mon.enter();
            this.minibars.remove(bar);
            if (!this.global) {
                global_instance.unregister(bar);
            }
        }
        finally {
            minibars_mon.exit();
        }
        if (this.minibars.isEmpty()) {
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(this);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public ShellManager getShellManager() {
        return this.shellManager;
    }

    public AEMonitor getMiniBarMonitor() {
        return minibars_mon;
    }

    public ListIterator getMiniBarIterator() {
        return this.minibars.listIterator();
    }

    public int countMiniBars() {
        return this.minibars.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllVisible(boolean visible) {
        try {
            minibars_mon.enter();
            for (MiniBar bar : this.minibars) {
                bar.setVisible(visible);
            }
        }
        finally {
            minibars_mon.exit();
        }
    }

    public void close(MiniBar mini_bar) {
        if (mini_bar != null) {
            mini_bar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniBar getMiniBarForObject(Object context2) {
        try {
            minibars_mon.enter();
            for (MiniBar bar : this.minibars) {
                if (!bar.hasContext(context2)) continue;
                MiniBar miniBar = bar;
                return miniBar;
            }
            MiniBar miniBar = null;
            return miniBar;
        }
        finally {
            minibars_mon.exit();
        }
    }

    public void close(Object context2) {
        MiniBar bar = this.getMiniBarForObject(context2);
        if (bar != null) {
            bar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        try {
            minibars_mon.enter();
            for (MiniBar bar : new ArrayList(this.minibars)) {
                bar.close();
            }
        }
        finally {
            minibars_mon.exit();
        }
    }

    public boolean isOpen(Object context2) {
        return this.getMiniBarForObject(context2) != null;
    }

    @Override
    public String getUpdateUIName() {
        return "MiniBar-" + this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUI() {
        try {
            minibars_mon.enter();
            for (MiniBar bar : this.minibars) {
                try {
                    bar.refresh();
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        finally {
            minibars_mon.exit();
        }
    }
}

