/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.minibar;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.List;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.DoubleBufferedLabel;
import org.gudy.azureus2.ui.swt.mainwindow.SelectableSpeedMenu;
import org.gudy.azureus2.ui.swt.minibar.MiniBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class AllTransfersBar
extends MiniBar {
    private static MiniBarManager manager = new MiniBarManager("AllTransfersBar");
    private GlobalManager g_manager;
    private DoubleBufferedLabel down_speed;
    private DoubleBufferedLabel up_speed;
    private DoubleBufferedLabel next_eta;
    private Label icon_label;

    public static MiniBarManager getManager() {
        return manager;
    }

    public static AllTransfersBar getBarIfOpen(GlobalManager g_manager) {
        return (AllTransfersBar)manager.getMiniBarForObject(g_manager);
    }

    public static void open(final Shell main) {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                GlobalManager g_manager = core.getGlobalManager();
                AllTransfersBar result = AllTransfersBar.getBarIfOpen(g_manager);
                if (result == null) {
                    result = new AllTransfersBar(g_manager, main);
                }
            }
        });
    }

    public static void closeAllTransfersBar() {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                GlobalManager g_manager = core.getGlobalManager();
                AllTransfersBar result = AllTransfersBar.getBarIfOpen(g_manager);
                if (result != null) {
                    result.close();
                }
            }
        });
    }

    private AllTransfersBar(GlobalManager gmanager, Shell main) {
        super(manager);
        this.g_manager = gmanager;
        this.construct(main);
    }

    @Override
    public Object getContextObject() {
        return this.g_manager;
    }

    @Override
    public void beginConstruction() {
        this.createFixedTextLabel("MinimizedWindow.all_transfers", false, true);
        this.createGap(40);
        Label dlab = this.createFixedTextLabel("ConfigView.download.abbreviated", false, false);
        this.down_speed = this.createSpeedLabel();
        final Menu downloadSpeedMenu = new Menu(this.getShell(), 8);
        downloadSpeedMenu.addListener(22, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                if (AzureusCoreFactory.isCoreRunning()) {
                    SelectableSpeedMenu.generateMenuItems(downloadSpeedMenu, AzureusCoreFactory.getSingleton(), AllTransfersBar.this.g_manager, false);
                }
            }
        });
        dlab.setMenu(downloadSpeedMenu);
        this.down_speed.setMenu(downloadSpeedMenu);
        Label ulab = this.createFixedTextLabel("ConfigView.upload.abbreviated", false, false);
        this.up_speed = this.createSpeedLabel();
        final Menu uploadSpeedMenu = new Menu(this.getShell(), 8);
        uploadSpeedMenu.addListener(22, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                if (AzureusCoreFactory.isCoreRunning()) {
                    SelectableSpeedMenu.generateMenuItems(uploadSpeedMenu, AzureusCoreFactory.getSingleton(), AllTransfersBar.this.g_manager, true);
                }
            }
        });
        ulab.setMenu(uploadSpeedMenu);
        this.up_speed.setMenu(uploadSpeedMenu);
        this.createFixedTextLabel("TableColumn.header.eta_next", true, false);
        this.next_eta = this.createDataLabel(65);
        if (COConfigurationManager.getBooleanParameter("Transfer Bar Show Icon Area")) {
            this.icon_label = this.createFixedLabel(16);
        }
    }

    public void setIconImage(Image image) {
        if (this.icon_label != null && image != this.icon_label.getImage()) {
            this.icon_label.setImage(image);
            this.icon_label.pack();
            this.icon_label.redraw();
        }
    }

    @Override
    protected void doubleClick() {
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT != null) {
            functionsSWT.bringToFront();
        }
    }

    @Override
    public void buildMenu(Menu menu, MenuEvent menuEvent) {
        MenuItem start_all = new MenuItem(menu, 8);
        Messages.setLanguageText(start_all, "MainWindow.menu.transfers.startalltransfers");
        Utils.setMenuItemImage(start_all, "start");
        start_all.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                ManagerUtils.asyncStartAll();
            }
        });
        start_all.setEnabled(true);
        MenuItem stop_all = new MenuItem(menu, 8);
        Messages.setLanguageText(stop_all, "MainWindow.menu.transfers.stopalltransfers");
        Utils.setMenuItemImage(stop_all, "stop");
        stop_all.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                ManagerUtils.asyncStopAll();
            }
        });
        stop_all.setEnabled(true);
        MenuItem pause_all = new MenuItem(menu, 8);
        Messages.setLanguageText(pause_all, "MainWindow.menu.transfers.pausetransfers");
        Utils.setMenuItemImage(pause_all, "pause");
        pause_all.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                ManagerUtils.asyncPause();
            }
        });
        pause_all.setEnabled(this.g_manager.canPauseDownloads());
        MenuItem resume_all = new MenuItem(menu, 8);
        Messages.setLanguageText(resume_all, "MainWindow.menu.transfers.resumetransfers");
        Utils.setMenuItemImage(resume_all, "resume");
        resume_all.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                ManagerUtils.asyncResume();
            }
        });
        resume_all.setEnabled(this.g_manager.canResumeDownloads());
        new MenuItem(menu, 2);
        super.buildMenu(menu);
    }

    @Override
    protected void refresh0() {
        GlobalManagerStats stats2 = this.g_manager.getStats();
        this.updateSpeedLabel(this.down_speed, stats2.getDataReceiveRate(), stats2.getProtocolReceiveRate());
        this.updateSpeedLabel(this.up_speed, stats2.getDataSendRate(), stats2.getProtocolSendRate());
        long min_eta = Long.MAX_VALUE;
        int num_downloading = 0;
        List<DownloadManager> dms = this.g_manager.getDownloadManagers();
        for (DownloadManager dm : dms) {
            if (dm.getState() != 50) continue;
            ++num_downloading;
            long eta = dm.getStats().getSmoothedETA();
            if (eta >= min_eta) continue;
            min_eta = eta;
        }
        if (min_eta == Long.MAX_VALUE) {
            min_eta = 1827387392L;
        }
        this.next_eta.setText(num_downloading == 0 ? "" : DisplayFormatters.formatETA(min_eta));
    }

    @Override
    public String[] getPluginMenuIdentifiers(Object[] context2) {
        if (context2 == null) {
            return null;
        }
        return new String[]{"transfersbar"};
    }

    @Override
    protected void storeLastLocation(Point location) {
        COConfigurationManager.setParameter("transferbar.x", location.x);
        COConfigurationManager.setParameter("transferbar.y", location.y);
    }

    @Override
    protected Point getInitialLocation() {
        if (!COConfigurationManager.getBooleanParameter("Remember transfer bar location")) {
            return null;
        }
        if (!COConfigurationManager.hasParameter("transferbar.x", false)) {
            return null;
        }
        int x = COConfigurationManager.getIntParameter("transferbar.x");
        int y = COConfigurationManager.getIntParameter("transferbar.y");
        return new Point(x, y);
    }
}

