/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.maketorrent.BYOPanel;
import org.gudy.azureus2.ui.swt.maketorrent.DirectoryPanel;
import org.gudy.azureus2.ui.swt.maketorrent.ModePanel;
import org.gudy.azureus2.ui.swt.maketorrent.SingleFilePanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class NewTorrentWizard
extends Wizard {
    static final int TT_LOCAL = 1;
    static final int TT_EXTERNAL = 2;
    static final int TT_DECENTRAL = 3;
    static final String TT_EXTERNAL_DEFAULT = "http://";
    static final String TT_DECENTRAL_DEFAULT = TorrentUtils.getDecentralisedEmptyURL().toString();
    private static String default_open_dir = COConfigurationManager.getStringParameter("CreateTorrent.default.open", "");
    private static String default_save_dir = COConfigurationManager.getStringParameter("CreateTorrent.default.save", "");
    private static String comment = COConfigurationManager.getStringParameter("CreateTorrent.default.comment", "");
    private static int tracker_type = COConfigurationManager.getIntParameter("CreateTorrent.default.trackertype", 1);
    protected static final int MODE_SINGLE_FILE = 1;
    protected static final int MODE_DIRECTORY = 2;
    protected static final int MODE_BYO = 3;
    int create_mode = 3;
    String singlePath = "";
    String directoryPath = "";
    String savePath = "";
    File byo_desc_file;
    Map byo_map;
    String trackerURL = "http://";
    boolean computed_piece_size = true;
    long manual_piece_size;
    boolean useMultiTracker = false;
    boolean useWebSeed = false;
    private boolean addOtherHashes = COConfigurationManager.getBooleanParameter("CreateTorrent.default.addhashes", false);
    String multiTrackerConfig = "";
    List trackers = new ArrayList();
    String webSeedConfig = "";
    Map webseeds = new HashMap();
    boolean autoOpen = false;
    boolean autoHost = false;
    boolean forceStart = false;
    String initialTags = COConfigurationManager.getStringParameter("CreateTorrent.default.initialTags", "");
    boolean superseed = false;
    boolean permitDHT = true;
    TOTorrentCreator creator = null;

    public NewTorrentWizard(Display display) {
        super("wizard.title");
        this.cancel.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                if (NewTorrentWizard.this.creator != null) {
                    NewTorrentWizard.this.creator.cancel();
                }
            }
        });
        this.trackers.add(new ArrayList());
        this.trackerURL = Utils.getLinkFromClipboard(display, false, false);
        ModePanel panel = new ModePanel(this, null);
        this.createDropTarget(this.getWizardWindow());
        this.setFirstPanel(panel);
    }

    protected int getTrackerType() {
        return tracker_type;
    }

    protected void setTrackerType(int type) {
        tracker_type = type;
        COConfigurationManager.setParameter("CreateTorrent.default.trackertype", tracker_type);
    }

    protected String getDefaultOpenDir() {
        return default_open_dir;
    }

    protected void setDefaultOpenDir(String d) {
        default_open_dir = d;
        COConfigurationManager.setParameter("CreateTorrent.default.open", default_open_dir);
    }

    protected String getDefaultSaveDir() {
        return default_save_dir;
    }

    protected void setDefaultSaveDir(String d) {
        default_save_dir = d;
        COConfigurationManager.setParameter("CreateTorrent.default.save", default_save_dir);
    }

    protected String getInitialTags(boolean save) {
        if (save) {
            COConfigurationManager.setParameter("CreateTorrent.default.initialTags", this.initialTags);
        }
        return this.initialTags;
    }

    protected void setInitialTags(String tags) {
        this.initialTags = tags;
    }

    void setComment(String s) {
        comment = s;
        COConfigurationManager.setParameter("CreateTorrent.default.comment", comment);
    }

    String getComment() {
        return comment;
    }

    private void createDropTarget(Control control) {
        DropTarget dropTarget = new DropTarget(control, 23);
        dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetEvent event2) {
                if (URLTransfer.getInstance().isSupportedType(event2.currentDataType)) {
                    event2.detail = NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel ? 4 : 0;
                }
            }

            @Override
            public void drop(DropTargetEvent event2) {
                if (event2.data instanceof String[]) {
                    String[] sourceNames = (String[])event2.data;
                    if (sourceNames == null) {
                        event2.detail = 0;
                    }
                    if (event2.detail == 0) {
                        return;
                    }
                    for (String droppedFileStr : sourceNames) {
                        File droppedFile = new File(droppedFileStr);
                        if (NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel) break;
                        if (NewTorrentWizard.this.getCurrentPanel() instanceof DirectoryPanel) {
                            if (droppedFile.isDirectory()) {
                                ((DirectoryPanel)NewTorrentWizard.this.getCurrentPanel()).setFilename(droppedFile.getAbsolutePath());
                            }
                        } else if (NewTorrentWizard.this.getCurrentPanel() instanceof SingleFilePanel) {
                            if (droppedFile.isFile()) {
                                ((SingleFilePanel)NewTorrentWizard.this.getCurrentPanel()).setFilename(droppedFile.getAbsolutePath());
                            }
                        } else if (NewTorrentWizard.this.getCurrentPanel() instanceof BYOPanel) {
                            ((BYOPanel)NewTorrentWizard.this.getCurrentPanel()).addFilename(droppedFile);
                            continue;
                        }
                        break;
                    }
                } else if (NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel) {
                    NewTorrentWizard.this.trackerURL = ((URLTransfer.URLType)event2.data).linkURL;
                    ((ModePanel)NewTorrentWizard.this.getCurrentPanel()).updateTrackerURL();
                }
            }
        });
    }

    protected void setPieceSizeComputed() {
        this.computed_piece_size = true;
    }

    public boolean getPieceSizeComputed() {
        return this.computed_piece_size;
    }

    protected void setPieceSizeManual(long _value) {
        this.computed_piece_size = false;
        this.manual_piece_size = _value;
    }

    protected long getPieceSizeManual() {
        return this.manual_piece_size;
    }

    protected void setAddOtherHashes(boolean o) {
        this.addOtherHashes = o;
        COConfigurationManager.setParameter("CreateTorrent.default.addhashes", this.addOtherHashes);
    }

    protected boolean getPrivateTorrent() {
        return COConfigurationManager.getBooleanParameter("CreateTorrent.default.privatetorrent", false);
    }

    protected void setPrivateTorrent(boolean privateTorrent) {
        COConfigurationManager.setParameter("CreateTorrent.default.privatetorrent", privateTorrent);
    }

    protected boolean getAddOtherHashes() {
        return this.addOtherHashes;
    }

    protected IWizardPanel<NewTorrentWizard> getNextPanelForMode(AbstractWizardPanel<NewTorrentWizard> prev) {
        switch (this.create_mode) {
            case 2: {
                return new DirectoryPanel(this, (IWizardPanel<NewTorrentWizard>)prev);
            }
            case 1: {
                return new SingleFilePanel(this, prev);
            }
        }
        return new BYOPanel(this, (IWizardPanel<NewTorrentWizard>)prev);
    }

    static {
        if (default_save_dir.length() == 0) {
            default_save_dir = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory", "");
        }
    }
}

