/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import com.aelitis.azureus.ui.UserPrompterResultListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.TrackersUtil;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class MultiTrackerEditor {
    TrackerEditorListener listener;
    String oldName;
    String currentName;
    boolean anonymous;
    boolean showTemplates;
    List<List<String>> trackers;
    Shell shell;
    Text textName;
    Tree treeGroups;
    TreeEditor editor;
    TreeItem itemEdited;
    Button btnSave;
    Button btnCancel;
    Menu menu;

    public MultiTrackerEditor(Shell parent_shell, String name, List<List<String>> trackers, TrackerEditorListener listener) {
        this(parent_shell, name, trackers, listener, false);
    }

    public MultiTrackerEditor(Shell parent_shell, String name, List<List<String>> trackers, TrackerEditorListener listener, boolean anonymous) {
        this(parent_shell, name, trackers, listener, anonymous, false);
    }

    public MultiTrackerEditor(Shell parent_shell, String name, List<List<String>> trackers, TrackerEditorListener listener, boolean _anonymous, boolean _showTemplates) {
        this.oldName = name;
        this.currentName = name != null ? name : "";
        this.listener = listener;
        this.anonymous = _anonymous;
        this.showTemplates = _showTemplates;
        this.trackers = new ArrayList<List<String>>(trackers);
        this.createWindow(parent_shell);
    }

    private void createWindow(Shell parent_shell) {
        GridData gridData;
        this.shell = parent_shell == null ? ShellFactory.createMainShell(2160) : ShellFactory.createShell(parent_shell, 2160);
        Messages.setLanguageText(this.shell, this.anonymous ? "wizard.multitracker.edit.title" : "wizard.multitracker.template.title");
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout(layout);
        if (!this.anonymous) {
            Label labelName = new Label(this.shell, 0);
            Messages.setLanguageText(labelName, "wizard.multitracker.edit.name");
            this.textName = new Text(this.shell, 2048);
            this.textName.setText(this.currentName);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.textName.setLayoutData(gridData);
            this.textName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent arg0) {
                    MultiTrackerEditor.this.currentName = MultiTrackerEditor.this.textName.getText();
                    MultiTrackerEditor.this.computeSaveEnable();
                }
            });
        }
        this.treeGroups = new Tree(this.shell, 2048);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 150;
        this.treeGroups.setLayoutData(gridData);
        this.treeGroups.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
                TreeItem treeItem;
                String type;
                if (MultiTrackerEditor.this.treeGroups.getSelectionCount() == 1 && (type = (String)(treeItem = MultiTrackerEditor.this.treeGroups.getSelection()[0]).getData("type")).equals("tracker")) {
                    MultiTrackerEditor.this.editTreeItem(treeItem);
                }
            }
        });
        if (this.showTemplates) {
            Composite cTemplate = new Composite(this.shell, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            cTemplate.setLayoutData(gridData);
            GridLayout layoutTemplate = new GridLayout();
            layoutTemplate.numColumns = 5;
            cTemplate.setLayout(layoutTemplate);
            Label labelTitle = new Label(cTemplate, 0);
            Messages.setLanguageText(labelTitle, "Search.menu.engines");
            final Combo configList = new Combo(cTemplate, 8);
            gridData = new GridData(768);
            configList.setLayoutData(gridData);
            final ArrayList<Button> buttons = new ArrayList<Button>();
            String sel_str = COConfigurationManager.getStringParameter("multitrackereditor.last.selection", null);
            final String[] currentTemplate = new String[]{sel_str == null || sel_str.length() == 0 ? null : sel_str};
            final Runnable updateSelection = new Runnable(){

                @Override
                public void run() {
                    int selection = configList.getSelectionIndex();
                    boolean enabled = selection != -1;
                    currentTemplate[0] = enabled ? configList.getItem(selection) : null;
                    String sel_str = currentTemplate[0];
                    COConfigurationManager.setParameter("multitrackereditor.last.selection", sel_str == null ? "" : sel_str);
                    Iterator it = buttons.iterator();
                    it.next();
                    while (it.hasNext()) {
                        ((Button)it.next()).setEnabled(enabled);
                    }
                }
            };
            final Runnable updateTemplates = new Runnable(){

                @Override
                public void run() {
                    Map<String, List<List<String>>> multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
                    configList.removeAll();
                    for (String str : multiTrackers.keySet()) {
                        configList.add(str);
                    }
                    String toBeSelected = currentTemplate[0];
                    if (toBeSelected != null) {
                        int selection = configList.indexOf(toBeSelected);
                        if (selection != -1) {
                            configList.select(selection);
                        } else if (configList.getItemCount() > 0) {
                            currentTemplate[0] = configList.getItem(0);
                            configList.select(0);
                        }
                    }
                    updateSelection.run();
                }
            };
            final TrackerEditorListener templateTEL = new TrackerEditorListener(){

                @Override
                public void trackersChanged(String oldName, String newName, List<List<String>> trackers) {
                    TrackersUtil util = TrackersUtil.getInstance();
                    if (oldName != null && !oldName.equals(newName)) {
                        util.removeMultiTracker(oldName);
                    }
                    util.addMultiTracker(newName, trackers);
                    currentTemplate[0] = newName;
                    updateTemplates.run();
                }
            };
            final Button btnNew = new Button(cTemplate, 8);
            buttons.add(btnNew);
            Messages.setLanguageText(btnNew, "wizard.multitracker.new");
            btnNew.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    ArrayList<List<String>> group = new ArrayList<List<String>>();
                    ArrayList tracker = new ArrayList();
                    group.add(tracker);
                    new MultiTrackerEditor(btnNew.getShell(), null, group, templateTEL);
                }
            });
            configList.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    updateSelection.run();
                }
            });
            final Button btnEdit = new Button(cTemplate, 8);
            buttons.add(btnEdit);
            Messages.setLanguageText(btnEdit, "wizard.multitracker.edit");
            btnEdit.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    Map<String, List<List<String>>> multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
                    String selected = currentTemplate[0];
                    new MultiTrackerEditor(btnEdit.getShell(), selected, multiTrackers.get(selected), templateTEL);
                }
            });
            Button btnDelete = new Button(cTemplate, 8);
            buttons.add(btnDelete);
            Messages.setLanguageText(btnDelete, "wizard.multitracker.delete");
            btnDelete.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    final String selected = currentTemplate[0];
                    MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{selected}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                    mb.open(new UserPrompterResultListener(){

                        @Override
                        public void prompterClosed(int result) {
                            if (result == 0) {
                                TrackersUtil.getInstance().removeMultiTracker(selected);
                                updateTemplates.run();
                            }
                        }
                    });
                }
            });
            Label labelApply = new Label(cTemplate, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            labelApply.setLayoutData(gridData);
            Messages.setLanguageText(labelApply, "apply.selected.template");
            Button btnReplace = new Button(cTemplate, 8);
            buttons.add(btnReplace);
            Messages.setLanguageText(btnReplace, "label.replace");
            btnReplace.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    Map<String, List<List<String>>> multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
                    String selected = currentTemplate[0];
                    MultiTrackerEditor.this.trackers = TorrentUtils.getClone(multiTrackers.get(selected));
                    MultiTrackerEditor.this.refresh();
                    MultiTrackerEditor.this.computeSaveEnable();
                }
            });
            Button btnMerge = new Button(cTemplate, 8);
            buttons.add(btnMerge);
            Messages.setLanguageText(btnMerge, "label.merge");
            btnMerge.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    Map<String, List<List<String>>> multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
                    String selected = currentTemplate[0];
                    MultiTrackerEditor.this.trackers = TorrentUtils.mergeAnnounceURLs(MultiTrackerEditor.this.trackers, multiTrackers.get(selected));
                    MultiTrackerEditor.this.refresh();
                    MultiTrackerEditor.this.computeSaveEnable();
                }
            });
            Button btnRemove = new Button(cTemplate, 8);
            buttons.add(btnRemove);
            Messages.setLanguageText(btnRemove, "Button.remove");
            btnRemove.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    Map<String, List<List<String>>> multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
                    String selected = currentTemplate[0];
                    MultiTrackerEditor.this.trackers = TorrentUtils.removeAnnounceURLs(MultiTrackerEditor.this.trackers, multiTrackers.get(selected), false);
                    MultiTrackerEditor.this.refresh();
                    MultiTrackerEditor.this.computeSaveEnable();
                }
            });
            updateTemplates.run();
            Utils.makeButtonsEqualWidth(buttons);
        }
        Label labelSeparator = new Label(this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData(gridData);
        Composite cButtons = new Composite(this.shell, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        cButtons.setLayoutData(gridData);
        GridLayout layoutButtons = new GridLayout();
        layoutButtons.numColumns = 4;
        cButtons.setLayout(layoutButtons);
        ArrayList<Button> buttons = new ArrayList<Button>();
        final Button btnedittext = new Button(cButtons, 8);
        buttons.add(btnedittext);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        btnedittext.setLayoutData(gridData);
        Messages.setLanguageText(btnedittext, "wizard.multitracker.edit.text");
        btnedittext.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                MultiTrackerEditor.this.btnSave.setEnabled(false);
                btnedittext.setEnabled(false);
                MultiTrackerEditor.this.trackers = new ArrayList<List<String>>();
                TreeItem[] groupItems = MultiTrackerEditor.this.treeGroups.getItems();
                for (int i = 0; i < groupItems.length; ++i) {
                    TreeItem group = groupItems[i];
                    TreeItem[] trackerItems = group.getItems();
                    ArrayList<String> groupList = new ArrayList<String>(group.getItemCount());
                    for (int j = 0; j < trackerItems.length; ++j) {
                        groupList.add(trackerItems[j].getText());
                    }
                    MultiTrackerEditor.this.trackers.add(groupList);
                }
                final String old_text = TorrentUtils.announceGroupsToText(MultiTrackerEditor.this.trackers);
                final TextViewerWindow viewer = new TextViewerWindow(MultiTrackerEditor.this.shell, "wizard.multitracker.edit.text.title", "wizard.multitracker.edit.text.msg", old_text, false, false);
                viewer.setEditable(true);
                viewer.addListener(new TextViewerWindow.TextViewerWindowListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void closed() {
                        try {
                            String new_text = viewer.getText();
                            if (!old_text.equals(new_text)) {
                                String[] lines = new_text.split("\n");
                                StringBuilder valid_text = new StringBuilder(new_text.length() + 1);
                                for (String line : lines) {
                                    if ((line = line.trim()).length() > 0 && !MultiTrackerEditor.this.validURL(line)) continue;
                                    valid_text.append(line);
                                    valid_text.append("\n");
                                }
                                MultiTrackerEditor.this.trackers = TorrentUtils.announceTextToGroups(valid_text.toString());
                                MultiTrackerEditor.this.refresh();
                            }
                        }
                        finally {
                            MultiTrackerEditor.this.computeSaveEnable();
                            btnedittext.setEnabled(true);
                        }
                    }
                });
            }
        });
        Label label = new Label(cButtons, 0);
        gridData = new GridData(768);
        label.setLayoutData(gridData);
        this.btnSave = new Button(cButtons, 8);
        buttons.add(this.btnSave);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.btnSave.setLayoutData(gridData);
        Messages.setLanguageText(this.btnSave, "wizard.multitracker.edit.save");
        this.btnSave.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                MultiTrackerEditor.this.update();
                MultiTrackerEditor.this.shell.dispose();
            }
        });
        this.btnCancel = new Button(cButtons, 8);
        buttons.add(this.btnCancel);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.btnCancel.setLayoutData(gridData);
        Messages.setLanguageText(this.btnCancel, "Button.cancel");
        this.btnCancel.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                MultiTrackerEditor.this.shell.dispose();
            }
        });
        Utils.makeButtonsEqualWidth(buttons);
        this.shell.setDefaultButton(this.btnSave);
        this.shell.addListener(31, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    MultiTrackerEditor.this.shell.dispose();
                }
            }
        });
        this.computeSaveEnable();
        this.refresh();
        this.constructMenu();
        this.editor = new TreeEditor(this.treeGroups);
        this.treeGroups.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (MultiTrackerEditor.this.itemEdited != null && !MultiTrackerEditor.this.itemEdited.isDisposed() && !MultiTrackerEditor.this.editor.getEditor().isDisposed()) {
                    MultiTrackerEditor.this.itemEdited.setText(((Text)MultiTrackerEditor.this.editor.getEditor()).getText());
                }
                MultiTrackerEditor.this.removeEditor();
            }
        });
        Point size = this.shell.computeSize(500, -1);
        this.shell.setSize(size);
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    private void update() {
        this.trackers = new ArrayList<List<String>>();
        TreeItem[] groupItems = this.treeGroups.getItems();
        for (int i = 0; i < groupItems.length; ++i) {
            TreeItem group = groupItems[i];
            TreeItem[] trackerItems = group.getItems();
            ArrayList<String> groupList = new ArrayList<String>(group.getItemCount());
            for (int j = 0; j < trackerItems.length; ++j) {
                groupList.add(trackerItems[j].getText());
            }
            this.trackers.add(groupList);
        }
        this.listener.trackersChanged(this.oldName, this.currentName, this.trackers);
        this.oldName = this.currentName;
    }

    private void computeSaveEnable() {
        boolean enabled;
        boolean bl = enabled = this.anonymous || !"".equals(this.currentName);
        if (enabled) {
            TreeItem[] groupItems = this.treeGroups.getItems();
            block0: for (int i = 0; i < groupItems.length; ++i) {
                TreeItem group = groupItems[i];
                TreeItem[] trackerItems = group.getItems();
                for (int j = 0; j < trackerItems.length; ++j) {
                    if (this.validURL(trackerItems[j].getText())) continue;
                    enabled = false;
                    break block0;
                }
            }
        }
        if (enabled != this.btnSave.getEnabled()) {
            this.btnSave.setEnabled(enabled);
        }
    }

    private void refresh() {
        this.treeGroups.removeAll();
        for (List<String> trackerGroup : this.trackers) {
            TreeItem itemRoot = this.newGroup();
            for (String url : trackerGroup) {
                this.newTracker(itemRoot, url);
            }
        }
    }

    private void constructMenu() {
        this.menu = new Menu(this.shell, 0);
        this.menu.addListener(22, new Listener(){

            @Override
            public void handleEvent(Event e) {
                MenuItem[] items = MultiTrackerEditor.this.menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                if (MultiTrackerEditor.this.treeGroups.getSelectionCount() != 1) {
                    MenuItem item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText(item, "wizard.multitracker.edit.newgroup");
                    item.addListener(13, new Listener(){

                        @Override
                        public void handleEvent(Event arg0) {
                            TreeItem group = MultiTrackerEditor.this.newGroup();
                            TreeItem itemTracker = MultiTrackerEditor.this.newTracker(group, "http://");
                            MultiTrackerEditor.this.editTreeItem(itemTracker);
                        }
                    });
                    return;
                }
                final TreeItem treeItem = MultiTrackerEditor.this.treeGroups.getSelection()[0];
                String type = (String)treeItem.getData("type");
                if (type.equals("tracker")) {
                    MenuItem item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText(item, "wizard.multitracker.edit.deletetracker");
                    item.addListener(13, new Listener(){

                        @Override
                        public void handleEvent(Event arg0) {
                            treeItem.dispose();
                        }
                    });
                    item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText(item, "wizard.multitracker.edit.edit");
                    item.addListener(13, new Listener(){

                        @Override
                        public void handleEvent(Event arg0) {
                            MultiTrackerEditor.this.editTreeItem(treeItem);
                        }
                    });
                } else if (type.equals("group")) {
                    MenuItem item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText(item, "wizard.multitracker.edit.newgroup");
                    item.addListener(13, new Listener(){

                        @Override
                        public void handleEvent(Event arg0) {
                            TreeItem group = MultiTrackerEditor.this.newGroup();
                            TreeItem itemTracker = MultiTrackerEditor.this.newTracker(group, "http://");
                            MultiTrackerEditor.this.editTreeItem(itemTracker);
                        }
                    });
                    item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText(item, "wizard.multitracker.edit.deletegroup");
                    item.addListener(13, new Listener(){

                        @Override
                        public void handleEvent(Event arg0) {
                            TreeItem[] subItems = treeItem.getItems();
                            for (int i = 0; i < subItems.length; ++i) {
                                subItems[i].dispose();
                            }
                            treeItem.dispose();
                        }
                    });
                    new MenuItem(MultiTrackerEditor.this.menu, 2);
                    item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText(item, "wizard.multitracker.edit.newtracker");
                    item.addListener(13, new Listener(){

                        @Override
                        public void handleEvent(Event arg0) {
                            TreeItem itemTracker = MultiTrackerEditor.this.newTracker(treeItem, "http://");
                            MultiTrackerEditor.this.editTreeItem(itemTracker);
                        }
                    });
                }
            }
        });
        this.treeGroups.setMenu(this.menu);
    }

    private void editTreeItem(final TreeItem item) {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        this.itemEdited = item;
        final Text text = new Text(this.treeGroups, 2048);
        text.setText(item.getText());
        text.setForeground(item.getForeground());
        text.setSelection(item.getText().length());
        text.addListener(14, new Listener(){

            @Override
            public void handleEvent(Event e) {
                String url = text.getText();
                if (MultiTrackerEditor.this.validURL(url)) {
                    text.setForeground(null);
                    item.setForeground(null);
                } else {
                    text.setForeground(Colors.colorError);
                    item.setForeground(Colors.colorError);
                }
                item.setText(url);
                MultiTrackerEditor.this.computeSaveEnable();
                MultiTrackerEditor.this.removeEditor();
            }
        });
        text.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event e) {
                String url = text.getText();
                if (MultiTrackerEditor.this.validURL(url)) {
                    text.setForeground(null);
                    item.setForeground(null);
                } else {
                    text.setForeground(Colors.colorError);
                    item.setForeground(Colors.colorError);
                }
                item.setText(url);
                MultiTrackerEditor.this.computeSaveEnable();
            }
        });
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    MultiTrackerEditor.this.removeEditor();
                }
            }
        });
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        Rectangle r = text.computeTrim(0, 0, 100, text.getLineHeight());
        this.editor.minimumHeight = r.height;
        this.editor.setEditor(text, item);
        text.setFocus();
    }

    private boolean validURL(String str) {
        try {
            URL url = new URL(str);
            String prot = url.getProtocol().toLowerCase();
            return prot.equals("http") || prot.equals("https") || prot.equals("ws") || prot.equals("wss") || prot.equals("udp") || prot.equals("dht");
        }
        catch (Throwable e) {
            return false;
        }
    }

    private void removeEditor() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
    }

    private TreeItem newGroup() {
        TreeItem item = new TreeItem(this.treeGroups, 0);
        item.setData("type", "group");
        Messages.setLanguageText(item, "wizard.multitracker.group");
        return item;
    }

    private TreeItem newTracker(TreeItem root, String url) {
        TreeItem item = new TreeItem(root, 0);
        item.setText(url);
        item.setData("type", "tracker");
        root.setExpanded(true);
        return item;
    }
}

