/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.maketorrent.SavePathPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class DirectoryPanel
extends AbstractWizardPanel<NewTorrentWizard> {
    private Text file;

    public DirectoryPanel(NewTorrentWizard wizard, IWizardPanel<NewTorrentWizard> previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((NewTorrentWizard)this.wizard).setTitle(MessageText.getString("wizard.directory"));
        ((NewTorrentWizard)this.wizard).setCurrentInfo(MessageText.getString("wizard.choosedirectory"));
        Composite panel = ((NewTorrentWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout(layout);
        Label label = new Label(panel, 0);
        Messages.setLanguageText(label, "wizard.directory");
        this.file = new Text(panel, 2048);
        this.file.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent arg0) {
                String fName;
                ((NewTorrentWizard)((DirectoryPanel)DirectoryPanel.this).wizard).directoryPath = fName = DirectoryPanel.this.file.getText();
                String error = "";
                if (!fName.equals("")) {
                    File f = new File(DirectoryPanel.this.file.getText());
                    if (!f.exists() || !f.isDirectory()) {
                        error = MessageText.getString("wizard.invaliddirectory");
                    } else {
                        String parent = f.getParent();
                        if (parent != null) {
                            ((NewTorrentWizard)DirectoryPanel.this.wizard).setDefaultOpenDir(parent);
                        }
                    }
                }
                ((NewTorrentWizard)DirectoryPanel.this.wizard).setErrorMessage(error);
                ((NewTorrentWizard)DirectoryPanel.this.wizard).setNextEnabled(!((NewTorrentWizard)((DirectoryPanel)DirectoryPanel.this).wizard).directoryPath.equals("") && error.equals(""));
            }
        });
        this.file.setText(((NewTorrentWizard)this.wizard).directoryPath);
        GridData gridData = new GridData(768);
        this.file.setLayoutData(gridData);
        Button browse = new Button(panel, 8);
        browse.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                DirectoryDialog fd = new DirectoryDialog(((NewTorrentWizard)DirectoryPanel.this.wizard).getWizardWindow());
                if (((NewTorrentWizard)DirectoryPanel.this.wizard).getErrorMessage().equals("") && !((NewTorrentWizard)((DirectoryPanel)DirectoryPanel.this).wizard).directoryPath.equals("")) {
                    fd.setFilterPath(((NewTorrentWizard)((DirectoryPanel)DirectoryPanel.this).wizard).directoryPath);
                } else {
                    String def = ((NewTorrentWizard)DirectoryPanel.this.wizard).getDefaultOpenDir();
                    if (def.length() > 0) {
                        fd.setFilterPath(def);
                    }
                }
                String f = fd.open();
                if (f != null) {
                    DirectoryPanel.this.file.setText(f);
                    File ff = new File(f);
                    String parent = ff.getParent();
                    if (parent != null) {
                        ((NewTorrentWizard)DirectoryPanel.this.wizard).setDefaultOpenDir(parent);
                    }
                }
            }
        });
        Messages.setLanguageText(browse, "wizard.browse");
        label = new Label(panel, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setText("\n");
        label = new Label(panel, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setForeground(Colors.blue);
        Messages.setLanguageText(label, "wizard.hint.directory");
    }

    @Override
    public IWizardPanel<NewTorrentWizard> getNextPanel() {
        return new SavePathPanel((NewTorrentWizard)this.wizard, this);
    }

    public void setFilename(String filename) {
        this.file.setText(filename);
    }
}

