/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunStateHandler;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.ui.swt.UISwitcherListener;
import org.gudy.azureus2.ui.swt.UISwitcherUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class SWTThread {
    private static SWTThread instance;
    Display display;
    private boolean sleak;
    private boolean terminated;
    private Thread runner;
    private final IUIIntializer initializer;
    private Monitor primaryMonitor;
    protected boolean displayDispoed;
    private boolean isRetinaDisplay;

    public static SWTThread getInstance() {
        return instance;
    }

    public static void createInstance(IUIIntializer initializer) throws SWTThreadAlreadyInstanciatedException {
        if (instance != null) {
            throw new SWTThreadAlreadyInstanciatedException();
        }
        new SWTThread(initializer);
    }

    private SWTThread(final IUIIntializer app) {
        this.initializer = app;
        instance = this;
        Display.setAppName(Constants.APP_NAME);
        try {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = new Display();
                this.sleak = false;
            } else {
                this.sleak = true;
            }
        }
        catch (Exception e) {
            this.display = new Display();
            this.sleak = false;
        }
        catch (UnsatisfiedLinkError ue) {
            String sMin = "3.4";
            try {
                sMin = "" + (double)(SWT.getVersion() / 100) / 10.0;
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String tempDir = System.getProperty("swt.library.path");
                if (tempDir == null) {
                    tempDir = System.getProperty("java.io.tmpdir");
                }
                Debug.out("Loading SWT Libraries failed. Typical causes:\n\n(1) swt.jar is not for your os architecture (" + System.getProperty("os.arch") + ").  " + "You can get a new swt.jar (Min Version: " + sMin + ") " + "from http://eclipse.org/swt" + "\n\n" + "(2) No write access to '" + tempDir + "'. SWT will extract libraries contained in the swt.jar to this dir.\n", ue);
                app.stopIt(false, false);
                this.terminated = true;
                PlatformManagerFactory.getPlatformManager().dispose();
            }
            catch (Throwable t) {
                // empty catch block
            }
            return;
        }
        Thread.currentThread().setName("SWT Thread");
        Utils.initialize(this.display);
        this.primaryMonitor = this.display.getPrimaryMonitor();
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generate(IndentWriter writer) {
                writer.println("SWT");
                try {
                    writer.indent();
                    writer.println("SWT Version:" + SWT.getVersion() + "/" + SWT.getPlatform());
                    writer.println("org.eclipse.swt.browser.XULRunnerPath: " + System.getProperty("org.eclipse.swt.browser.XULRunnerPath", ""));
                    writer.println("MOZILLA_FIVE_HOME: " + SystemProperties.getEnvironmentalVariable("MOZILLA_FIVE_HOME"));
                }
                finally {
                    writer.exdent();
                }
            }
        });
        UISwitcherUtil.addListener(new UISwitcherListener(){

            @Override
            public void uiSwitched(String ui) {
                MessageBoxShell mb = new MessageBoxShell(MessageText.getString("dialog.uiswitcher.restart.title"), MessageText.getString("dialog.uiswitcher.restart.text"), new String[]{MessageText.getString("UpdateWindow.restart"), MessageText.getString("UpdateWindow.restartLater")}, 0);
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        if (result != 0) {
                            return;
                        }
                        UIFunctions uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) {
                            uif.dispose(true, false);
                        }
                    }
                });
            }
        });
        try {
            Field fldOpenDoc = SWT.class.getDeclaredField("OpenDocument");
            int SWT_OpenDocument = fldOpenDoc.getInt(null);
            this.display.addListener(SWT_OpenDocument, new Listener(){

                @Override
                public void handleEvent(final Event event2) {
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        @Override
                        public void azureusCoreRunning(AzureusCore core) {
                            UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentOpenOptions(Utils.findAnyShell(), null, new String[]{event2.text}, false, false);
                        }
                    });
                }
            });
        }
        catch (Throwable t) {
            // empty catch block
        }
        Listener lShowMainWindow = new Listener(){

            @Override
            public void handleEvent(Event event2) {
                Shell mainShell;
                if (event2.type == 26 && AERunStateHandler.isDelayedUI()) {
                    Debug.out("Ignoring activate event as delay start");
                    return;
                }
                Shell as = Display.getDefault().getActiveShell();
                if (as != null) {
                    as.setVisible(true);
                    as.forceActive();
                    return;
                }
                UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (!(uif == null || (mainShell = uif.getMainShell()) != null && mainShell.isVisible() && !mainShell.getMinimized() || COConfigurationManager.getBooleanParameter("Reduce Auto Activate Window"))) {
                    uif.bringToFront(false);
                }
            }
        };
        this.display.addListener(26, lShowMainWindow);
        this.display.addListener(13, lShowMainWindow);
        this.display.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                SWTThread.this.displayDispoed = true;
            }
        });
        if (Constants.isOSX) {
            Class<?> ehancerClass;
            this.display.addListener(21, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        event2.doit = uiFunctions.dispose(false, false);
                    }
                }
            });
            String platform = SWT.getPlatform();
            if (platform.equals("carbon")) {
                try {
                    ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CarbonUIEnhancer");
                    Constructor<?> constructor = ehancerClass.getConstructor(new Class[0]);
                    constructor.newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            } else if (platform.equals("cocoa")) {
                try {
                    Method mIsRetinaDisplay;
                    Method mHookDocOpen;
                    ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CocoaUIEnhancer");
                    Method mGetInstance = ehancerClass.getMethod("getInstance", new Class[0]);
                    Object claObj = mGetInstance.invoke(null, new Object[0]);
                    Method mHookAppMenu = claObj.getClass().getMethod("hookApplicationMenu", new Class[0]);
                    if (mHookAppMenu != null) {
                        mHookAppMenu.invoke(claObj, new Object[0]);
                    }
                    if ((mHookDocOpen = claObj.getClass().getMethod("hookDocumentOpen", new Class[0])) != null) {
                        mHookDocOpen.invoke(claObj, new Object[0]);
                    }
                    if ((mIsRetinaDisplay = claObj.getClass().getMethod("isRetinaDisplay", new Class[0])) != null) {
                        this.isRetinaDisplay = (Boolean)mIsRetinaDisplay.invoke(claObj, new Object[0]);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (app != null) {
            app.runInSWTThread();
            this.runner = new Thread((Runnable)new AERunnable(){

                @Override
                public void runSupport() {
                    app.run();
                }
            }, "Main Thread");
            this.runner.start();
        }
        if (!this.sleak) {
            while (!this.display.isDisposed() && !this.terminated) {
                try {
                    if (this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
                catch (Throwable e) {
                    if (this.terminated) {
                        Logger.log(new LogEvent(LogIDs.GUI, "Weird non-critical error after terminated in readAndDispatch: " + e.toString()));
                        continue;
                    }
                    String stackTrace = Debug.getStackTrace(e);
                    if (Constants.isOSX && stackTrace.indexOf("Device.dispose") > 0 && stackTrace.indexOf("DropTarget") > 0) {
                        Logger.log(new LogEvent(LogIDs.GUI, "Weird non-critical display disposal in readAndDispatch"));
                        continue;
                    }
                    if (SWT.getVersion() < 3119) {
                        e.printStackTrace();
                    }
                    if (Constants.isCVSVersion()) {
                        Logger.log(new LogAlert(false, MessageText.getString("SWT.alert.erroringuithread"), e));
                        continue;
                    }
                    Debug.out(MessageText.getString("SWT.alert.erroringuithread"), e);
                }
            }
            if (!this.terminated) {
                if (app != null) {
                    app.stopIt(false, false);
                }
                this.terminated = true;
            }
            try {
                if (!this.display.isDisposed()) {
                    this.display.dispose();
                }
            }
            catch (Throwable t) {
                if (SWT.getVersion() < 3119) {
                    t.printStackTrace();
                }
                Debug.printStackTrace(t);
            }
            PlatformManagerFactory.getPlatformManager().dispose();
        }
    }

    public void terminate() {
        this.terminated = true;
        if (!this.display.isDisposed()) {
            try {
                Shell[] shells = this.display.getShells();
                for (int i = 0; i < shells.length; ++i) {
                    try {
                        Shell shell = shells[i];
                        shell.dispose();
                        continue;
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
            }
            catch (Throwable t) {
                Debug.out(t);
            }
            this.display.dispose();
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public boolean isTerminated() {
        return this.terminated || this.displayDispoed || this.display.isDisposed();
    }

    public IUIIntializer getInitializer() {
        return this.initializer;
    }

    public Monitor getPrimaryMonitor() {
        return this.primaryMonitor;
    }

    public boolean isRetinaDisplay() {
        return this.isRetinaDisplay;
    }
}

