/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;

public class PluginsMenuHelper {
    private static PluginsMenuHelper INSTANCE = null;
    private AEMonitor plugin_helper_mon = new AEMonitor("plugin_helper_mon");
    private Comparator<String> alpha_comparator = new FormattersImpl().getAlphanumericComparator(true);
    private Map<String, IViewInfo> plugin_view_info_map = new TreeMap<String, IViewInfo>(this.alpha_comparator);
    private Map<String, IViewInfo> plugin_logs_view_info_map = new TreeMap<String, IViewInfo>(this.alpha_comparator);
    private List<PluginAddedViewListener> pluginAddedViewListener = new ArrayList<PluginAddedViewListener>();

    private PluginsMenuHelper() {
    }

    public static PluginsMenuHelper getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new PluginsMenuHelper();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildPluginLogsMenu(Menu parentMenu) {
        try {
            this.plugin_helper_mon.enter();
            this.createViewInfoMenuItems(parentMenu, this.plugin_logs_view_info_map);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
    }

    private void sort(MenuItem[] plugin_items) {
        Arrays.sort(plugin_items, new Comparator<MenuItem>(){

            @Override
            public int compare(MenuItem o1, MenuItem o2) {
                return PluginsMenuHelper.this.alpha_comparator.compare(o1.getText(), o2.getText());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildViewMenu(Menu viewMenu, Shell parent) {
        int itemCount = viewMenu.getItemCount();
        MenuItem[] plugin_items = MenuItemManager.getInstance().getAllAsArray("mainmenu");
        if (plugin_items.length > 0) {
            this.sort(plugin_items);
            MenuBuildUtils.addPluginMenuItems(plugin_items, viewMenu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
        }
        try {
            this.plugin_helper_mon.enter();
            if (plugin_items.length > 0 && this.plugin_view_info_map.size() > 0) {
                new org.eclipse.swt.widgets.MenuItem(viewMenu, 2);
            }
            this.createViewInfoMenuItems(viewMenu, this.plugin_view_info_map);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
        return viewMenu.getItemCount() > itemCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildPluginMenu(Menu pluginMenu, Shell parent, boolean includeGetPluginsMenu) {
        try {
            this.plugin_helper_mon.enter();
            this.createViewInfoMenuItems(pluginMenu, this.plugin_view_info_map);
            org.eclipse.swt.widgets.MenuItem menu_plugin_logViews = MenuFactory.addLogsViewMenuItem(pluginMenu);
            this.createViewInfoMenuItems(menu_plugin_logViews.getMenu(), this.plugin_logs_view_info_map);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
        MenuFactory.addSeparatorMenuItem(pluginMenu);
        MenuItem[] plugin_items = MenuItemManager.getInstance().getAllAsArray("mainmenu");
        if (plugin_items.length > 0) {
            this.sort(plugin_items);
            MenuBuildUtils.addPluginMenuItems(plugin_items, pluginMenu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
            MenuFactory.addSeparatorMenuItem(pluginMenu);
        }
        MenuFactory.addPluginInstallMenuItem(pluginMenu);
        MenuFactory.addPluginUnInstallMenuItem(pluginMenu);
        if (includeGetPluginsMenu) {
            MenuFactory.addGetPluginsMenuItem(pluginMenu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(String sViewID, UISWTViewEventListener l) {
        IViewInfo view_info = new IViewInfo();
        view_info.viewID = sViewID;
        view_info.event_listener = l;
        String name = null;
        String sResourceID = "Views.plugins." + sViewID + ".title";
        boolean bResourceExists = MessageText.keyExists(sResourceID);
        if (!bResourceExists && l instanceof UISWTViewEventListenerHolder) {
            name = ((UISWTViewEventListenerHolder)l).getPluginInterface().getPluginconfig().getPluginStringParameter(sResourceID, null);
        }
        if (bResourceExists) {
            name = MessageText.getString(sResourceID);
        } else if (name == null) {
            sResourceID = sViewID;
            bResourceExists = MessageText.keyExists(sResourceID);
            name = bResourceExists ? MessageText.getString(sResourceID) : sViewID.replace('.', ' ');
        }
        view_info.name = name;
        Map<String, IViewInfo> map_to_use = l instanceof BasicPluginViewImpl || l instanceof UISWTViewEventListenerHolder && ((UISWTViewEventListenerHolder)l).isLogView() ? this.plugin_logs_view_info_map : this.plugin_view_info_map;
        try {
            this.plugin_helper_mon.enter();
            map_to_use.put(name, view_info);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
        this.triggerPluginAddedViewListeners(view_info);
    }

    private void removePluginViewsWithID(String sViewID, Map map) {
        if (sViewID == null) {
            return;
        }
        Iterator itr = map.values().iterator();
        IViewInfo view_info = null;
        while (itr.hasNext()) {
            view_info = (IViewInfo)itr.next();
            if (!sViewID.equals(view_info.viewID)) continue;
            itr.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginViews(final String sViewID) {
        try {
            this.plugin_helper_mon.enter();
            this.removePluginViewsWithID(sViewID, this.plugin_view_info_map);
            this.removePluginViewsWithID(sViewID, this.plugin_logs_view_info_map);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    uiFunctions.closePluginViews(sViewID);
                }
            }
        });
    }

    private void createViewInfoMenuItem(Menu parent, final IViewInfo info) {
        org.eclipse.swt.widgets.MenuItem item = new org.eclipse.swt.widgets.MenuItem(parent, 0);
        item.setText(info.name);
        if (info.viewID != null) {
            item.setData("ViewID", info.viewID);
        }
        item.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    info.openView(uiFunctions);
                }
            }
        });
    }

    private void createViewInfoMenuItems(Menu parent, Map menu_data) {
        Iterator itr = menu_data.values().iterator();
        while (itr.hasNext()) {
            this.createViewInfoMenuItem(parent, (IViewInfo)itr.next());
        }
    }

    public IViewInfo[] getPluginViewsInfo() {
        return this.plugin_view_info_map.values().toArray(new IViewInfo[0]);
    }

    public IViewInfo[] getPluginLogViewsInfo() {
        return this.plugin_logs_view_info_map.values().toArray(new IViewInfo[0]);
    }

    public void addPluginAddedViewListener(PluginAddedViewListener l) {
        IViewInfo[] viewsInfo;
        this.pluginAddedViewListener.add(l);
        for (IViewInfo info : viewsInfo = this.getPluginViewsInfo()) {
            l.pluginViewAdded(info);
        }
        for (IViewInfo info : viewsInfo = this.getPluginLogViewsInfo()) {
            l.pluginViewAdded(info);
        }
    }

    public void triggerPluginAddedViewListeners(final IViewInfo viewInfo) {
        final Object[] listeners = this.pluginAddedViewListener.toArray();
        if (this.pluginAddedViewListener.size() > 0) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    for (int i = 0; i < listeners.length; ++i) {
                        PluginAddedViewListener l = (PluginAddedViewListener)listeners[i];
                        l.pluginViewAdded(viewInfo);
                    }
                }
            });
        }
    }

    public IViewInfo findIViewInfo(UISWTViewEventListener l) {
        IViewInfo viewInfo;
        int i;
        IViewInfo foundViewInfo = null;
        IViewInfo[] pluginViewsInfo = this.getPluginViewsInfo();
        for (i = 0; i < pluginViewsInfo.length; ++i) {
            viewInfo = pluginViewsInfo[i];
            if (viewInfo.event_listener != l) continue;
            foundViewInfo = viewInfo;
            break;
        }
        if (foundViewInfo == null) {
            pluginViewsInfo = this.getPluginLogViewsInfo();
            for (i = 0; i < pluginViewsInfo.length; ++i) {
                viewInfo = pluginViewsInfo[i];
                if (viewInfo.event_listener != l) continue;
                foundViewInfo = viewInfo;
                break;
            }
        }
        return foundViewInfo;
    }

    public static class IViewInfo {
        public String name;
        public String viewID;
        public UISWTViewEventListener event_listener;

        public void openView(UIFunctionsSWT uiFunctions) {
            if (this.event_listener != null) {
                uiFunctions.openPluginView("Main", this.viewID, this.event_listener, null, true);
            }
        }
    }

    public static interface PluginAddedViewListener {
        public void pluginViewAdded(IViewInfo var1);
    }
}

