/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

public class HSLColor {
    private static final int HSLMAX = 255;
    private static final int RGBMAX = 255;
    private static final int UNDEFINED = 170;
    private int pHue;
    private int pSat;
    private int pLum;
    private int pRed;
    private int pGreen;
    private int pBlue;

    public void initHSLbyRGB(int R, int G, int B) {
        this.pRed = R;
        this.pGreen = G;
        this.pBlue = B;
        int cMax = this.iMax(this.iMax(R, G), B);
        int cMin = this.iMin(this.iMin(R, G), B);
        int cMinus = cMax - cMin;
        int cPlus = cMax + cMin;
        this.pLum = (cPlus * 255 + 255) / 510;
        if (cMax == cMin) {
            this.pSat = 0;
            this.pHue = 170;
        } else {
            this.pSat = this.pLum <= 127 ? (int)(((double)(cMinus * 255) + 0.5) / (double)cPlus) : (int)(((double)(cMinus * 255) + 0.5) / (double)(510 - cPlus));
            int RDelta = (int)(((double)((cMax - R) * 42) + 0.5) / (double)cMinus);
            int GDelta = (int)(((double)((cMax - G) * 42) + 0.5) / (double)cMinus);
            int BDelta = (int)(((double)((cMax - B) * 42) + 0.5) / (double)cMinus);
            if (cMax == R) {
                this.pHue = BDelta - GDelta;
            } else if (cMax == G) {
                this.pHue = 85 + RDelta - BDelta;
            } else if (cMax == B) {
                this.pHue = 170 + GDelta - RDelta;
            }
            if (this.pHue < 0) {
                this.pHue += 255;
            }
        }
    }

    public void initRGBbyHSL(int H, int S, int L) {
        this.pHue = H;
        this.pLum = L;
        this.pSat = S;
        if (S == 0) {
            this.pGreen = this.pRed = L * 255 / 255;
            this.pBlue = this.pRed;
        } else {
            int Magic2 = L <= 127 ? (L * (255 + S) + 127) / 255 : L + S - (L * S + 127) / 255;
            int Magic1 = 2 * L - Magic2;
            this.pRed = (this.hueToRGB(Magic1, Magic2, H + 85) * 255 + 127) / 255;
            if (this.pRed > 255) {
                this.pRed = 255;
            }
            this.pGreen = (this.hueToRGB(Magic1, Magic2, H) * 255 + 127) / 255;
            if (this.pGreen > 255) {
                this.pGreen = 255;
            }
            this.pBlue = (this.hueToRGB(Magic1, Magic2, H - 85) * 255 + 127) / 255;
            if (this.pBlue > 255) {
                this.pBlue = 255;
            }
        }
    }

    private int hueToRGB(int mag1, int mag2, int Hue) {
        if (Hue < 0) {
            Hue += 255;
        } else if (Hue > 255) {
            Hue -= 255;
        }
        if (Hue < 42) {
            return mag1 + ((mag2 - mag1) * Hue + 21) / 42;
        }
        if (Hue < 127) {
            return mag2;
        }
        if (Hue < 170) {
            return mag1 + ((mag2 - mag1) * (170 - Hue) + 21) / 42;
        }
        return mag1;
    }

    private int iMax(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    private int iMin(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private void greyscale() {
        this.initRGBbyHSL(170, 0, this.pLum);
    }

    public int getHue() {
        return this.pHue;
    }

    public void setHue(int iToValue) {
        while (iToValue < 0) {
            iToValue = 255 + iToValue;
        }
        while (iToValue > 255) {
            iToValue -= 255;
        }
        this.initRGBbyHSL(iToValue, this.pSat, this.pLum);
    }

    public int getSaturation() {
        return this.pSat;
    }

    public void setSaturation(int iToValue) {
        if (iToValue < 0) {
            iToValue = 0;
        } else if (iToValue > 255) {
            iToValue = 255;
        }
        this.initRGBbyHSL(this.pHue, iToValue, this.pLum);
    }

    public int getLuminence() {
        return this.pLum;
    }

    public void setLuminence(int iToValue) {
        if (iToValue < 0) {
            iToValue = 0;
        } else if (iToValue > 255) {
            iToValue = 255;
        }
        this.initRGBbyHSL(this.pHue, this.pSat, iToValue);
    }

    public int getRed() {
        return this.pRed;
    }

    private void setRed(int iNewValue) {
        this.initHSLbyRGB(iNewValue, this.pGreen, this.pBlue);
    }

    public int getGreen() {
        return this.pGreen;
    }

    private void setGreen(int iNewValue) {
        this.initHSLbyRGB(this.pRed, iNewValue, this.pBlue);
    }

    public int getBlue() {
        return this.pBlue;
    }

    private void setBlue(int iNewValue) {
        this.initHSLbyRGB(this.pRed, this.pGreen, iNewValue);
    }

    public void reverseColor() {
        this.setHue(this.pHue + 127);
    }

    private void reverseLight() {
        this.setLuminence(255 - this.pLum);
    }

    public void brighten(float fPercent) {
        if (fPercent == 0.0f) {
            return;
        }
        int L = (int)((float)this.pLum * fPercent);
        if (L < 0) {
            L = 0;
        }
        if (L > 255) {
            L = 255;
        }
        this.setLuminence(L);
    }

    public void blend(int R, int G, int B, float fPercent) {
        if (fPercent >= 1.0f) {
            this.initHSLbyRGB(R, G, B);
            return;
        }
        if (fPercent <= 0.0f) {
            return;
        }
        int newR = (int)((double)((float)R * fPercent) + (double)this.pRed * (1.0 - (double)fPercent));
        int newG = (int)((double)((float)G * fPercent) + (double)this.pGreen * (1.0 - (double)fPercent));
        int newB = (int)((double)((float)B * fPercent) + (double)this.pBlue * (1.0 - (double)fPercent));
        this.initHSLbyRGB(newR, newG, newB);
    }
}

