/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.exporttorrent.wizard;

import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizardFinishPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class ExportTorrentWizardOutputPanel
extends AbstractWizardPanel {
    protected boolean file_valid = false;

    public ExportTorrentWizardOutputPanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        this.wizard.setTitle(MessageText.getString("exportTorrentWizard.exportfile.title"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        Utils.setLayoutData((Control)panel, gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout(layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 380;
        Utils.setLayoutData((Control)label, gridData);
        Messages.setLanguageText(label, "exportTorrentWizard.exportfile.message");
        label = new Label(panel, 0);
        Messages.setLanguageText(label, "exportTorrentWizard.exportfile.path");
        final Text textPath = new Text(panel, 2048);
        gridData = new GridData(768);
        Utils.setLayoutData((Control)textPath, gridData);
        textPath.setText(((ExportTorrentWizard)this.wizard).getExportFile());
        Button browse = new Button(panel, 8);
        Messages.setLanguageText(browse, "exportTorrentWizard.exportfile.browse");
        browse.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                FileDialog fd = new FileDialog(ExportTorrentWizardOutputPanel.this.wizard.getWizardWindow(), 8192);
                fd.setFileName(textPath.getText());
                fd.setFilterExtensions(new String[]{"*.xml", Constants.FILE_WILDCARD});
                String path = fd.open();
                if (path != null) {
                    textPath.setText(path);
                }
            }
        });
        textPath.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                String path = textPath.getText();
                ExportTorrentWizardOutputPanel.this.pathSet(path);
            }
        });
        textPath.setText(((ExportTorrentWizard)this.wizard).getExportFile());
        textPath.setFocus();
    }

    protected void pathSet(String path) {
        ((ExportTorrentWizard)this.wizard).setExportFile(path);
        this.file_valid = false;
        try {
            File f = new File(path);
            if (f.exists()) {
                if (f.isFile()) {
                    this.wizard.setErrorMessage("");
                    this.file_valid = true;
                } else {
                    this.wizard.setErrorMessage(MessageText.getString("exportTorrentWizard.exportfile.invalidPath"));
                }
            } else {
                this.wizard.setErrorMessage("");
                this.file_valid = true;
            }
        }
        catch (Exception e) {
            this.wizard.setErrorMessage(MessageText.getString("exportTorrentWizard.exportfile.invalidPath"));
        }
        this.wizard.setFinishEnabled(this.file_valid);
    }

    @Override
    public boolean isFinishEnabled() {
        return this.file_valid;
    }

    @Override
    public boolean isFinishSelectionOK() {
        return ((ExportTorrentWizard)this.wizard).performExport();
    }

    @Override
    public IWizardPanel getFinishPanel() {
        return new ExportTorrentWizardFinishPanel((ExportTorrentWizard)this.wizard, (IWizardPanel)this);
    }
}

