/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProgressListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatChecker;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.config.wizard.FilePanel;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class NatPanel
extends AbstractWizardPanel {
    StyledText textResults;
    Button bTestTCP;
    Button bTestUDP;

    public NatPanel(ConfigureWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        this.wizard.setTitle(MessageText.getString("configureWizard.nat.title"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        Utils.setLayoutData((Control)panel, gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        panel.setLayout(layout);
        Label label = new Label(panel, 64);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        Utils.setLayoutData((Control)label, gridData);
        Messages.setLanguageText(label, "configureWizard.nat.message");
        label = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        Utils.setLayoutData((Control)label, gridData);
        label = new Label(panel, 0);
        gridData = new GridData();
        Utils.setLayoutData((Control)label, gridData);
        Messages.setLanguageText(label, "configureWizard.nat.server.tcp_listen_port");
        final Text textServerTCPListen = new Text(panel, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 80;
        Utils.setLayoutData((Control)textServerTCPListen, gridData);
        textServerTCPListen.setText("" + ((ConfigureWizard)this.wizard).serverTCPListenPort);
        textServerTCPListen.addListener(25, new Listener(){

            @Override
            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        textServerTCPListen.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event e) {
                try {
                    int TCPListenPort;
                    ((ConfigureWizard)((NatPanel)NatPanel.this).wizard).serverTCPListenPort = TCPListenPort = Integer.parseInt(textServerTCPListen.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.bTestTCP = new Button(panel, 8);
        Messages.setLanguageText(this.bTestTCP, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        Utils.setLayoutData((Control)this.bTestTCP, gridData);
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        gridData = new GridData();
        Utils.setLayoutData((Control)label, gridData);
        Messages.setLanguageText(label, "configureWizard.nat.server.udp_listen_port");
        final Text textServerUDPListen = new Text(panel, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 80;
        Utils.setLayoutData((Control)textServerUDPListen, gridData);
        textServerUDPListen.setText("" + ((ConfigureWizard)this.wizard).serverUDPListenPort);
        textServerUDPListen.addListener(25, new Listener(){

            @Override
            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        textServerUDPListen.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event e) {
                try {
                    int UDPListenPort;
                    ((ConfigureWizard)((NatPanel)NatPanel.this).wizard).serverUDPListenPort = UDPListenPort = Integer.parseInt(textServerUDPListen.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.bTestUDP = new Button(panel, 8);
        Messages.setLanguageText(this.bTestUDP, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        Utils.setLayoutData((Control)this.bTestUDP, gridData);
        label = new Label(panel, 0);
        this.textResults = new StyledText(panel, 2626);
        gridData = new GridData(1808);
        gridData.heightHint = 70;
        gridData.horizontalSpan = 4;
        Utils.setLayoutData((Control)this.textResults, gridData);
        this.textResults.setBackground(panel.getDisplay().getSystemColor(1));
        this.bTestTCP.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                NatPanel.this.wizard.setNextEnabled(false);
                NatPanel.this.bTestTCP.setEnabled(false);
                NatPanel.this.bTestUDP.setEnabled(false);
                NatPanel.this.textResults.setText("");
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    @Override
                    public void azureusCoreRunning(AzureusCore core) {
                        ConfigureWizard cw = (ConfigureWizard)NatPanel.this.wizard;
                        int TCPListenPort = cw.serverTCPListenPort;
                        CheckerTCP checker = new CheckerTCP(core, TCPListenPort);
                        checker.start();
                    }
                });
            }
        });
        this.bTestUDP.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                NatPanel.this.wizard.setNextEnabled(false);
                NatPanel.this.bTestTCP.setEnabled(false);
                NatPanel.this.bTestUDP.setEnabled(false);
                NatPanel.this.textResults.setText("");
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    @Override
                    public void azureusCoreRunning(AzureusCore core) {
                        ConfigureWizard cw = (ConfigureWizard)NatPanel.this.wizard;
                        int UDPListenPort = cw.serverUDPListenPort;
                        CheckerUDP checker = new CheckerUDP(core, UDPListenPort);
                        checker.start();
                    }
                });
            }
        });
    }

    public void printMessage(final String message) {
        Display display = this.wizard.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new AERunnable(){

            @Override
            public void runSupport() {
                if (NatPanel.this.textResults == null || NatPanel.this.textResults.isDisposed()) {
                    return;
                }
                NatPanel.this.textResults.append(message);
            }
        });
    }

    private void enableNext() {
        Display display = this.wizard.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new AERunnable(){

            @Override
            public void runSupport() {
                if (NatPanel.this.bTestTCP == null || NatPanel.this.bTestTCP.isDisposed()) {
                    return;
                }
                if (NatPanel.this.bTestUDP == null || NatPanel.this.bTestUDP.isDisposed()) {
                    return;
                }
                NatPanel.this.wizard.setNextEnabled(true);
                NatPanel.this.bTestTCP.setEnabled(true);
                NatPanel.this.bTestUDP.setEnabled(true);
            }
        });
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    @Override
    public IWizardPanel getNextPanel() {
        return new FilePanel((ConfigureWizard)this.wizard, (IWizardPanel)this);
    }

    public class CheckerTCP
    extends AEThread {
        private AzureusCore core;
        private int TCPListenPort;

        public CheckerTCP(AzureusCore _core, int tcp_listen_port) {
            super("NAT Checker TCP");
            this.core = _core;
            this.TCPListenPort = tcp_listen_port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void runSupport() {
            try {
                NatPanel.this.printMessage(MessageText.getString("configureWizard.nat.testing") + " TCP " + this.TCPListenPort + " ... ");
                NatChecker checker = new NatChecker(this.core, NetworkAdmin.getSingleton().getMultiHomedServiceBindAddresses(true)[0], this.TCPListenPort, false);
                switch (checker.getResult()) {
                    case 1: {
                        NatPanel.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ok") + "\n" + checker.getAdditionalInfo());
                        return;
                    }
                    case 2: {
                        NatPanel.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ko") + " - " + checker.getAdditionalInfo() + ".\n");
                        return;
                    }
                    default: {
                        NatPanel.this.printMessage("\n" + MessageText.getString("configureWizard.nat.unable") + ". \n(" + checker.getAdditionalInfo() + ").\n");
                        return;
                    }
                }
            }
            finally {
                NatPanel.this.enableNext();
            }
        }
    }

    public class CheckerUDP
    extends AEThread {
        private AzureusCore core;
        private int udp_port;

        public CheckerUDP(AzureusCore _core, int _udp_port) {
            super("NAT Checker UDP");
            this.core = _core;
            this.udp_port = _udp_port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runSupport() {
            try {
                NetworkAdmin admin = NetworkAdmin.getSingleton();
                NetworkAdminProtocol[] inbound_protocols = admin.getInboundProtocols(this.core);
                NetworkAdminProtocol selected = null;
                for (NetworkAdminProtocol p : inbound_protocols) {
                    if (p.getType() != 3 || p.getPort() != this.udp_port) continue;
                    selected = p;
                    break;
                }
                if (selected == null) {
                    selected = admin.createInboundProtocol(this.core, 3, this.udp_port);
                }
                if (selected == null) {
                    NatPanel.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ko") + ". \n( No UDP protocols enabled ).\n");
                } else {
                    NatPanel.this.printMessage(MessageText.getString("configureWizard.nat.testing") + " UDP " + this.udp_port + " ... ");
                    try {
                        selected.test(null, true, new NetworkAdminProgressListener(){

                            @Override
                            public void reportProgress(String task2) {
                                NatPanel.this.printMessage("\n    " + task2);
                            }
                        });
                        NatPanel.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ok"));
                    }
                    catch (Throwable e) {
                        NatPanel.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ko") + ". " + Debug.getNestedExceptionMessage(e) + ".\n");
                    }
                }
            }
            finally {
                NatPanel.this.enableNext();
            }
        }
    }
}

