/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.config.wizard.WelcomePanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class LanguagePanel
extends AbstractWizardPanel {
    public LanguagePanel(Wizard wizard, IWizardPanel previousPanel) {
        super(wizard, previousPanel);
    }

    @Override
    public void show() {
        this.wizard.setTitleAsResourceID("configureWizard.welcome.title");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        final Label lblChoose = new Label(rootPanel, 64);
        this.setChooseLabel(lblChoose);
        GridData gridData = new GridData(768);
        Utils.setLayoutData((Control)lblChoose, gridData);
        final List lstLanguage = new List(rootPanel, 2564);
        gridData = new GridData(1808);
        gridData.heightHint = 350;
        Utils.setLayoutData((Control)lstLanguage, gridData);
        final Locale[] locales = MessageText.getLocales(true);
        int iUsingLocale = -1;
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            lstLanguage.add(this.buildName(locale));
            if (!MessageText.isCurrentLocale(locale)) continue;
            iUsingLocale = i;
        }
        lstLanguage.select(iUsingLocale);
        lstLanguage.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                int index = lstLanguage.getSelectionIndex();
                if (index >= 0 && index < locales.length) {
                    COConfigurationManager.setParameter("locale", locales[index].toString());
                    MessageText.loadBundle();
                    DisplayFormatters.setUnits();
                    DisplayFormatters.loadMessages();
                    Shell shell = LanguagePanel.this.wizard.getWizardWindow();
                    Messages.updateLanguageForControl(shell);
                    LanguagePanel.this.setChooseLabel(lblChoose);
                    shell.layout(true, true);
                    lstLanguage.setRedraw(false);
                    for (int i = 0; i < locales.length; ++i) {
                        lstLanguage.setItem(i, LanguagePanel.this.buildName(locales[i]));
                    }
                    lstLanguage.setRedraw(true);
                    try {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        if (uiFunctions != null) {
                            uiFunctions.refreshLanguage();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        });
        FontData[] fontData = lstLanguage.getFont().getFontData();
        for (int i = 0; i < fontData.length; ++i) {
            if (fontData[i].getHeight() >= 10) continue;
            fontData[i].setHeight(10);
        }
        final Font font = new Font((Device)rootPanel.getDisplay(), fontData);
        lstLanguage.setFont(font);
        lstLanguage.getShell().addListener(22, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                lstLanguage.showSelection();
            }
        });
        lstLanguage.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                if (font != null && !font.isDisposed()) {
                    font.dispose();
                }
            }
        });
    }

    private void setChooseLabel(Label lblChoose) {
        String sDefChooseString;
        String sLocaleChooseString = MessageText.getString("ConfigureWizard.language.choose");
        if (sLocaleChooseString.equals(sDefChooseString = MessageText.getDefaultLocaleString("ConfigureWizard.language.choose"))) {
            lblChoose.setText(sLocaleChooseString);
        } else {
            lblChoose.setText(sLocaleChooseString + "\n" + sDefChooseString);
        }
    }

    private String buildName(Locale locale) {
        StringBuilder sName = new StringBuilder();
        String sName1 = locale.getDisplayLanguage(locale);
        String sName2 = locale.getDisplayLanguage();
        sName.append(sName1);
        if (!sName1.equals(sName2)) {
            sName.append("/").append(sName2);
        }
        sName1 = locale.getDisplayCountry(locale);
        sName2 = locale.getDisplayCountry();
        if (sName1.length() > 0 || sName2.length() > 0) {
            sName.append(" (");
            if (sName1.length() > 0) {
                sName.append(sName1);
            }
            if (sName2.length() > 0 && !sName1.equals(sName2)) {
                sName.append("/").append(sName2);
            }
            sName1 = locale.getDisplayVariant(locale);
            sName2 = locale.getDisplayVariant();
            if (sName1.length() > 0 || sName2.length() > 0) {
                sName.append(", ");
                if (sName1.length() > 0) {
                    sName.append(sName1);
                }
                if (sName2.length() > 0 && !sName1.equals(sName2)) {
                    sName.append("/").append(sName2);
                }
            }
            sName.append(")");
        }
        return sName.toString();
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    @Override
    public IWizardPanel getNextPanel() {
        return new WelcomePanel((ConfigureWizard)this.wizard, (IWizardPanel)this);
    }
}

