/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class FinishPanel
extends AbstractWizardPanel<ConfigureWizard> {
    public FinishPanel(ConfigureWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((ConfigureWizard)this.wizard).setTitle(MessageText.getString("configureWizard.finish.title"));
        Composite rootPanel = ((ConfigureWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        Utils.setLayoutData((Control)panel, gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout(layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 380;
        Utils.setLayoutData((Control)label, gridData);
        Messages.setLanguageText(label, "configureWizard.finish.message");
    }

    @Override
    public void finish() {
        ((ConfigureWizard)this.wizard).completed = true;
        int upLimit = ((ConfigureWizard)this.wizard).getUploadLimit();
        if (upLimit > 0) {
            COConfigurationManager.setParameter("Auto Upload Speed Enabled", false);
            COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", false);
            COConfigurationManager.setParameter("Max Upload Speed KBs", upLimit / DisplayFormatters.getKinB());
            COConfigurationManager.setParameter("enable.seedingonly.upload.rate", false);
            COConfigurationManager.setParameter("max active torrents", ((ConfigureWizard)this.wizard).maxActiveTorrents);
            COConfigurationManager.setParameter("max downloads", ((ConfigureWizard)this.wizard).maxDownloads);
            try {
                SpeedManager sm = AzureusCoreFactory.getSingleton().getSpeedManager();
                boolean is_manual = ((ConfigureWizard)this.wizard).isUploadLimitManual();
                sm.setEstimatedUploadCapacityBytesPerSec(upLimit, is_manual ? 1.0f : 0.9f);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            COConfigurationManager.setParameter("Auto Adjust Transfer Defaults", false);
            COConfigurationManager.setParameter("Auto Adjust Transfer Defaults", true);
        }
        if (((ConfigureWizard)this.wizard).getWizardMode() != 0) {
            ((ConfigureWizard)this.wizard).close();
        } else {
            COConfigurationManager.setParameter("TCP.Listen.Port", ((ConfigureWizard)this.wizard).serverTCPListenPort);
            COConfigurationManager.setParameter("UDP.Listen.Port", ((ConfigureWizard)this.wizard).serverUDPListenPort);
            COConfigurationManager.setParameter("UDP.NonData.Listen.Port", ((ConfigureWizard)this.wizard).serverUDPListenPort);
            COConfigurationManager.setParameter("General_sDefaultTorrent_Directory", ((ConfigureWizard)this.wizard).torrentPath);
            if (((ConfigureWizard)this.wizard).hasDataPathChanged()) {
                COConfigurationManager.setParameter("Default save path", ((ConfigureWizard)this.wizard).getDataPath());
            }
            COConfigurationManager.setParameter("Wizard Completed", true);
            COConfigurationManager.save();
            ((ConfigureWizard)this.wizard).switchToClose();
        }
    }

    @Override
    public boolean isPreviousEnabled() {
        return false;
    }
}

