/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.generic;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;

public class GenericIntParameter {
    private static boolean DEBUG = false;
    private GenericParameterAdapter adapter;
    private int iMinValue = Integer.MIN_VALUE;
    private int iMaxValue = Integer.MAX_VALUE;
    private int iDefaultValue;
    private String sParamName;
    private boolean bGenerateIntermediateEvents = false;
    private boolean bTriggerOnFocusOut = Utils.isCarbon;
    private Spinner spinner;
    private TimerEvent timedSaveEvent = null;
    private TimerEventPerformer timerEventSave;
    private final boolean delayIntialSet = Utils.isCarbon && System.getProperty("os.version", "").startsWith("10.6");
    private boolean isZeroHidden = false;
    private boolean disableTimedSave = false;

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name) {
        this.iDefaultValue = adapter.getIntValue(name);
        this.initialize(adapter, composite, name);
    }

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name, int defaultValue) {
        this.iDefaultValue = defaultValue;
        this.initialize(adapter, composite, name);
    }

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name, int minValue, int maxValue) {
        this.iDefaultValue = adapter.getIntValue(name);
        if (maxValue < minValue) {
            Debug.out("max < min, not good");
            maxValue = Integer.MAX_VALUE;
        }
        this.iMinValue = minValue;
        this.iMaxValue = maxValue;
        this.initialize(adapter, composite, name);
    }

    public void initialize(GenericParameterAdapter _adapter, Composite composite, String name) {
        this.adapter = _adapter;
        this.sParamName = name;
        this.timerEventSave = new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (GenericIntParameter.this.spinner.isDisposed()) {
                            return;
                        }
                        if (DEBUG) {
                            GenericIntParameter.this.debug("setIntValue to " + GenericIntParameter.this.spinner.getSelection() + " via timeEventSave");
                        }
                        GenericIntParameter.this.adapter.setIntValue(GenericIntParameter.this.sParamName, GenericIntParameter.this.spinner.getSelection());
                    }
                });
            }
        };
        int value = this.adapter.getIntValue(name, this.iDefaultValue);
        this.spinner = new Spinner(composite, 133120);
        this.setMinimumValue(this.iMinValue);
        this.setMaximumValue(this.iMaxValue);
        this.swt_setSpinnerValue(value);
        if (this.delayIntialSet) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                @Override
                public void runSupport() {
                    GenericIntParameter.this.swt_setSpinnerValue(GenericIntParameter.this.adapter.getIntValue(GenericIntParameter.this.sParamName, GenericIntParameter.this.iDefaultValue));
                }
            });
        }
        this.spinner.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                if (GenericIntParameter.this.bGenerateIntermediateEvents || !GenericIntParameter.this.spinner.isFocusControl()) {
                    GenericIntParameter.this.adapter.setIntValue(GenericIntParameter.this.sParamName, GenericIntParameter.this.spinner.getSelection());
                } else {
                    GenericIntParameter.this.bTriggerOnFocusOut = true;
                    GenericIntParameter.this.cancelTimedSaveEvent();
                    if (DEBUG) {
                        GenericIntParameter.this.debug("create timeSaveEvent (" + GenericIntParameter.this.spinner.getSelection() + ") ");
                    }
                    if (!GenericIntParameter.this.disableTimedSave) {
                        GenericIntParameter.this.timedSaveEvent = SimpleTimer.addEvent("IntParam Saver", SystemTime.getOffsetTime(750L), GenericIntParameter.this.timerEventSave);
                    }
                }
            }
        });
        this.spinner.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                if (GenericIntParameter.this.spinner.isFocusControl()) {
                    if (DEBUG) {
                        GenericIntParameter.this.debug("next");
                    }
                    GenericIntParameter.this.spinner.traverse(16);
                }
            }
        });
        this.spinner.addListener(16, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                if (GenericIntParameter.this.bTriggerOnFocusOut) {
                    if (DEBUG) {
                        GenericIntParameter.this.debug("focus out setIntValue(" + GenericIntParameter.this.spinner.getSelection() + "/trigger");
                    }
                    GenericIntParameter.this.cancelTimedSaveEvent();
                    GenericIntParameter.this.adapter.setIntValue(GenericIntParameter.this.sParamName, GenericIntParameter.this.spinner.getSelection());
                }
            }
        });
    }

    private void swt_setSpinnerValue(int value) {
        this.spinner.setSelection(value);
        if (this.isZeroHidden) {
            Display display = this.spinner.getDisplay();
            this.spinner.setBackground(value == 0 ? display.getSystemColor(29) : null);
            this.spinner.setForeground(value == 0 ? display.getSystemColor(28) : null);
        }
    }

    private void cancelTimedSaveEvent() {
        if (!(this.timedSaveEvent == null || this.timedSaveEvent.hasRun() && this.timedSaveEvent.isCancelled())) {
            if (DEBUG) {
                this.debug("cancel timeSaveEvent");
            }
            this.timedSaveEvent.cancel();
        }
    }

    private void debug(String string) {
        System.out.println("[GenericIntParameter:" + this.sParamName + "] " + string);
    }

    public void setMinimumValue(final int value) {
        this.iMinValue = value;
        if (this.iMinValue != Integer.MIN_VALUE && this.getValue() < this.iMinValue) {
            this.setValue(this.iMinValue);
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                GenericIntParameter.this.spinner.setMinimum(value);
            }
        });
    }

    public void setMaximumValue(final int value) {
        this.iMaxValue = value;
        if (this.iMaxValue != Integer.MAX_VALUE && this.getValue() > this.iMaxValue) {
            this.setValue(this.iMaxValue);
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                GenericIntParameter.this.spinner.setMaximum(value);
            }
        });
    }

    public String getName() {
        return this.sParamName;
    }

    public void setValue(int value) {
        int newValue = this.iMaxValue != Integer.MAX_VALUE && value > this.iMaxValue ? this.iMaxValue : (this.iMinValue != Integer.MIN_VALUE && value < this.iMinValue ? this.iMinValue : value);
        final int finalNewValue = newValue;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (!GenericIntParameter.this.spinner.isDisposed()) {
                    if (GenericIntParameter.this.spinner.getSelection() != finalNewValue) {
                        if (DEBUG) {
                            GenericIntParameter.this.debug("spinner.setSelection(" + finalNewValue + ")");
                        }
                        GenericIntParameter.this.swt_setSpinnerValue(finalNewValue);
                    }
                    if (DEBUG) {
                        GenericIntParameter.this.debug("setIntValue to " + GenericIntParameter.this.spinner.getSelection() + " via setValue(int)");
                    }
                }
            }
        });
        if (finalNewValue != this.getValue()) {
            this.adapter.setIntValue(this.sParamName, finalNewValue);
        }
    }

    public void setValue(final int value, boolean force_adapter_set) {
        if (force_adapter_set) {
            this.setValue(value);
        } else {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (GenericIntParameter.this.spinner.getSelection() != value) {
                        GenericIntParameter.this.swt_setSpinnerValue(value);
                    }
                }
            });
        }
    }

    public int getValue() {
        return this.adapter.getIntValue(this.sParamName, this.iDefaultValue);
    }

    public void resetToDefault() {
        if (this.adapter.resetIntDefault(this.sParamName)) {
            this.setValue(this.adapter.getIntValue(this.sParamName));
        } else {
            this.setValue(this.getValue());
        }
    }

    public void refresh() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (!GenericIntParameter.this.spinner.isDisposed()) {
                    GenericIntParameter.this.spinner.setSelection(GenericIntParameter.this.adapter.getIntValue(GenericIntParameter.this.sParamName));
                }
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        Utils.adjustPXForDPI(layoutData);
        this.spinner.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.spinner;
    }

    public boolean isGeneratingIntermediateEvents() {
        return this.bGenerateIntermediateEvents;
    }

    public void setGenerateIntermediateEvents(boolean generateIntermediateEvents) {
        this.bGenerateIntermediateEvents = generateIntermediateEvents;
    }

    public void disableTimedSave() {
        this.disableTimedSave = true;
    }

    public boolean isZeroHidden() {
        return this.isZeroHidden;
    }

    public void setZeroHidden(boolean isZeroHidden) {
        if (this.isZeroHidden == isZeroHidden) {
            return;
        }
        this.isZeroHidden = isZeroHidden;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                GenericIntParameter.this.swt_setSpinnerValue(GenericIntParameter.this.adapter.getIntValue(GenericIntParameter.this.sParamName, GenericIntParameter.this.iDefaultValue));
            }
        });
    }
}

