/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.generic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.IAdditionalActionPerformer;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;

public class GenericBooleanParameter {
    protected static final boolean DEBUG = false;
    GenericParameterAdapter adapter;
    String name;
    Button checkBox;
    Boolean defaultValue;
    List performers = new ArrayList();

    public GenericBooleanParameter(GenericParameterAdapter adapter, Composite composite, String name) {
        this(adapter, composite, name, adapter.getBooleanValue(name), null, null);
    }

    public GenericBooleanParameter(GenericParameterAdapter adapter, Composite composite, String name, String textKey) {
        this(adapter, composite, name, adapter.getBooleanValue(name), textKey, null);
    }

    public GenericBooleanParameter(GenericParameterAdapter adapter, Composite composite, String name, Boolean defaultValue, String textKey) {
        this(adapter, composite, name, defaultValue, textKey, null);
    }

    public GenericBooleanParameter(GenericParameterAdapter adapter, Composite composite, String name, Boolean defaultValue) {
        this(adapter, composite, name, defaultValue, null, null);
    }

    public GenericBooleanParameter(GenericParameterAdapter _adapter, Composite composite, String _name, Boolean _defaultValue, String textKey, IAdditionalActionPerformer actionPerformer) {
        this.adapter = _adapter;
        this.name = _name;
        this.defaultValue = _defaultValue;
        if (actionPerformer != null) {
            this.performers.add(actionPerformer);
        }
        Boolean value = this.adapter.getBooleanValue(this.name, this.defaultValue);
        this.checkBox = new Button(composite, 32);
        if (textKey != null) {
            Messages.setLanguageText(this.checkBox, textKey);
        }
        if (value != null) {
            this.checkBox.setGrayed(false);
            this.checkBox.setSelection(value);
        } else {
            this.checkBox.setGrayed(true);
            this.checkBox.setSelection(true);
        }
        this.checkBox.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                GenericBooleanParameter.this.setSelected(GenericBooleanParameter.this.checkBox.getSelection(), true);
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        Utils.adjustPXForDPI(layoutData);
        this.checkBox.setLayoutData(layoutData);
    }

    public void setAdditionalActionPerformer(IAdditionalActionPerformer actionPerformer) {
        this.performers.add(actionPerformer);
        Boolean selected = this.isSelected();
        if (selected != null) {
            actionPerformer.setSelected(selected);
        }
        actionPerformer.performAction();
    }

    public Control getControl() {
        return this.checkBox;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public Boolean isSelected() {
        return this.adapter.getBooleanValue(this.name);
    }

    public void setSelected(final boolean selected) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (!GenericBooleanParameter.this.checkBox.isDisposed()) {
                    if (GenericBooleanParameter.this.checkBox.getSelection() != selected) {
                        GenericBooleanParameter.this.checkBox.setSelection(selected);
                    }
                    GenericBooleanParameter.this.adapter.setBooleanValue(GenericBooleanParameter.this.name, GenericBooleanParameter.this.checkBox.getSelection());
                } else {
                    GenericBooleanParameter.this.adapter.setBooleanValue(GenericBooleanParameter.this.name, selected);
                }
                if (GenericBooleanParameter.this.performers.size() > 0) {
                    for (int i = 0; i < GenericBooleanParameter.this.performers.size(); ++i) {
                        IAdditionalActionPerformer performer = (IAdditionalActionPerformer)GenericBooleanParameter.this.performers.get(i);
                        performer.setSelected(selected);
                        performer.performAction();
                    }
                }
                GenericBooleanParameter.this.adapter.informChanged(false);
            }
        });
    }

    protected void setSelected(final boolean selected, boolean force) {
        if (force) {
            this.setSelected(selected);
        } else {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (GenericBooleanParameter.this.checkBox.getSelection() != selected) {
                        GenericBooleanParameter.this.checkBox.setSelection(selected);
                    }
                }
            });
        }
    }

    public void refresh() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Boolean selected = GenericBooleanParameter.this.isSelected();
                if (selected == null) {
                    GenericBooleanParameter.this.checkBox.setGrayed(true);
                    GenericBooleanParameter.this.checkBox.setSelection(true);
                } else {
                    GenericBooleanParameter.this.checkBox.setGrayed(false);
                    if (GenericBooleanParameter.this.checkBox.getSelection() != selected.booleanValue()) {
                        GenericBooleanParameter.this.checkBox.setSelection(selected);
                    }
                }
            }
        });
    }

    private void debug(String string) {
        System.out.println("[GenericBooleanParameter:" + this.name + "] " + string);
    }
}

