/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.Utils;

public class FloatParameter {
    Text inputField;
    float fMinValue = 0.0f;
    float fMaxValue = -1.0f;
    float fDefaultValue;
    int iDigitsAfterDecimal = 1;
    String sParamName;
    boolean allowZero = false;

    public FloatParameter(Composite composite, String name) {
        this.fDefaultValue = COConfigurationManager.getFloatParameter(name);
        this.initialize(composite, name);
    }

    public FloatParameter(Composite composite, String name, float minValue, float maxValue, boolean allowZero, int digitsAfterDecimal) {
        this.fDefaultValue = COConfigurationManager.getFloatParameter(name);
        this.initialize(composite, name);
        this.fMinValue = minValue;
        this.fMaxValue = maxValue;
        this.allowZero = allowZero;
        this.iDigitsAfterDecimal = digitsAfterDecimal;
    }

    public void initialize(Composite composite, final String name) {
        this.sParamName = name;
        this.inputField = new Text(composite, 133120);
        float value = COConfigurationManager.getFloatParameter(name);
        this.inputField.setText(String.valueOf(value));
        this.inputField.addListener(25, new Listener(){

            @Override
            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] >= '0' && chars[i] <= '9' || chars[i] == '.') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        this.inputField.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                try {
                    float val = Float.parseFloat(FloatParameter.this.inputField.getText());
                    if (val < FloatParameter.this.fMinValue && (!FloatParameter.this.allowZero || val != 0.0f)) {
                        val = FloatParameter.this.fMinValue;
                    }
                    if (val > FloatParameter.this.fMaxValue && FloatParameter.this.fMaxValue > -1.0f) {
                        val = FloatParameter.this.fMaxValue;
                    }
                    COConfigurationManager.setParameter(name, val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.inputField.addListener(16, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                try {
                    float val = Float.parseFloat(FloatParameter.this.inputField.getText());
                    if (val < FloatParameter.this.fMinValue && (!FloatParameter.this.allowZero || val != 0.0f)) {
                        FloatParameter.this.inputField.setText(String.valueOf(FloatParameter.this.fMinValue));
                        COConfigurationManager.setParameter(name, FloatParameter.this.fMinValue);
                    }
                    if (val > FloatParameter.this.fMaxValue && FloatParameter.this.fMaxValue > -1.0f) {
                        FloatParameter.this.inputField.setText(String.valueOf(FloatParameter.this.fMaxValue));
                        COConfigurationManager.setParameter(name, FloatParameter.this.fMaxValue);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        Utils.adjustPXForDPI(layoutData);
        this.inputField.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.inputField;
    }
}

