/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.ui.swt.components.graphics.Scale;
import org.gudy.azureus2.ui.swt.components.graphics.ScaledGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class PingGraphic
extends ScaledGraphic
implements ParameterListener {
    private static final int ENTRIES = 2000;
    private static final int COLOR_AVERAGE = 0;
    public static Color[] defaultColors = new Color[]{Colors.grey, Colors.blues[7], Colors.fadedGreen, Colors.fadedRed};
    private int internalLoop;
    private int graphicsUpdate;
    private Point oldSize;
    protected Image bufferImage;
    private int nbValues = 0;
    private int[][] all_values = new int[1][2000];
    private int currentPosition = 0;
    private boolean externalAverage;
    private Color[] colors = defaultColors;

    private PingGraphic(Scale scale, ValueFormater formater) {
        super(scale, formater);
        COConfigurationManager.addParameterListener("Graphics Update", (ParameterListener)this);
        this.parameterChanged("Graphics Update");
    }

    public static PingGraphic getInstance() {
        return new PingGraphic(new Scale(false), new ValueFormater(){

            @Override
            public String format(int value) {
                return value + " ms";
            }
        });
    }

    public void setColors(Color[] _colors) {
        this.colors = _colors;
    }

    public void setExternalAverage(boolean b) {
        this.externalAverage = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIntsValue(int[] new_values) {
        try {
            this.this_mon.enter();
            if (this.all_values.length < new_values.length) {
                int[][] new_all_values = new int[new_values.length][];
                System.arraycopy(this.all_values, 0, new_all_values, 0, this.all_values.length);
                for (int i = this.all_values.length; i < new_all_values.length; ++i) {
                    new_all_values[i] = new int[2000];
                }
                this.all_values = new_all_values;
            }
            for (int i = 0; i < new_values.length; ++i) {
                this.all_values[i][this.currentPosition] = new_values[i];
            }
            ++this.currentPosition;
            if (this.nbValues < 2000) {
                ++this.nbValues;
            }
            if (this.currentPosition >= 2000) {
                this.currentPosition = 0;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void refresh(boolean force) {
        this.refresh();
    }

    public void refresh() {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        Rectangle bounds = this.drawCanvas.getClientArea();
        if (bounds.height < 30 || bounds.width < 100 || bounds.width > 2000 || bounds.height > 2000) {
            return;
        }
        boolean sizeChanged = this.oldSize == null || this.oldSize.x != bounds.width || this.oldSize.y != bounds.height;
        this.oldSize = new Point(bounds.width, bounds.height);
        ++this.internalLoop;
        if (this.internalLoop > this.graphicsUpdate) {
            this.internalLoop = 0;
        }
        if (this.internalLoop == 0 || sizeChanged) {
            this.drawChart(sizeChanged);
        }
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            GC gc = new GC(this.drawCanvas);
            gc.drawImage(this.bufferImage, bounds.x, bounds.y);
            gc.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawChart(boolean sizeChanged) {
        try {
            this.this_mon.enter();
            this.drawScale(sizeChanged);
            if (this.bufferScale == null || this.bufferScale.isDisposed()) {
                return;
            }
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
                this.bufferImage.dispose();
            }
            this.bufferImage = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            GC gcImage = new GC(this.bufferImage);
            gcImage.drawImage(this.bufferScale, 0, 0);
            gcImage.setAntialias(1);
            int oldAverage = 0;
            int[] oldTargetValues = new int[this.all_values.length];
            int[] maxs = new int[this.all_values.length];
            for (int x = 0; x < bounds.width - 71; ++x) {
                int position = this.currentPosition - x - 1;
                if (position < 0) {
                    position += 2000;
                }
                for (int z = 0; z < this.all_values.length; ++z) {
                    int value = this.all_values[z][position];
                    if (value <= maxs[z]) continue;
                    maxs[z] = value;
                }
            }
            int max = 0;
            for (int i = 0; i < maxs.length; ++i) {
                if (maxs[i] <= max) continue;
                max = maxs[i];
            }
            this.scale.setMax(max);
            for (int x = 0; x < bounds.width - 71; ++x) {
                int z;
                int position = this.currentPosition - x - 1;
                if (position < 0) {
                    position += 2000;
                }
                int xDraw = bounds.width - 71 - x;
                gcImage.setLineWidth(1);
                int n = z = this.externalAverage ? 1 : 0;
                while (z < this.all_values.length) {
                    int targetValue = this.all_values[z][position];
                    int oldTargetValue = oldTargetValues[z];
                    if (x > 1) {
                        int h1 = bounds.height - this.scale.getScaledValue(targetValue) - 2;
                        int h2 = bounds.height - this.scale.getScaledValue(oldTargetValue) - 2;
                        gcImage.setForeground(this.externalAverage ? this.colors[z] : (z <= 2 ? this.colors[z + 1] : this.colors[3]));
                        gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                    }
                    oldTargetValues[z] = this.all_values[z][position];
                    ++z;
                }
                int average = this.computeAverage(position);
                if (x > 6) {
                    int h1 = bounds.height - this.scale.getScaledValue(average) - 2;
                    int h2 = bounds.height - this.scale.getScaledValue(oldAverage) - 2;
                    gcImage.setForeground(this.colors[0]);
                    gcImage.setLineWidth(2);
                    gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                }
                oldAverage = average;
            }
            if (this.nbValues > 0) {
                int height = bounds.height - this.scale.getScaledValue(this.computeAverage(this.currentPosition - 6)) - 2;
                gcImage.setForeground(this.colors[0]);
                gcImage.drawText(this.formater.format(this.computeAverage(this.currentPosition - 6)), bounds.width - 65, height - 12, true);
            }
            gcImage.dispose();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int computeAverage(int position) {
        int sum = 0;
        int nbItems = 0;
        for (int i = -5; i < 6; ++i) {
            int pos = position + i;
            if (pos < 0) {
                pos += 2000;
            }
            if (pos >= 2000) {
                pos -= 2000;
            }
            for (int z = 0; z < (this.externalAverage ? 1 : this.all_values.length); ++z) {
                sum += this.all_values[z][pos];
                ++nbItems;
            }
        }
        return sum / nbItems;
    }

    @Override
    public void parameterChanged(String parameter) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            this.bufferImage.dispose();
        }
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }
}

