/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class Legend {
    public static Composite createLegendComposite(Composite panel, Color[] blockColors, String[] keys) {
        return Legend.createLegendComposite(panel, blockColors, keys, true);
    }

    public static Composite createLegendComposite(Composite panel, Color[] blockColors, String[] keys, boolean horizontal) {
        Layout layout = panel.getLayout();
        GridData layoutData = null;
        if (layout instanceof GridLayout) {
            layoutData = new GridData(768);
        }
        return Legend.createLegendComposite(panel, blockColors, keys, null, layoutData, horizontal);
    }

    public static Composite createLegendComposite(Composite panel, Color[] blockColors, String[] keys, Object layoutData) {
        return Legend.createLegendComposite(panel, blockColors, keys, null, layoutData, true);
    }

    public static Composite createLegendComposite(Composite panel, Color[] blockColors, String[] keys, String[] key_texts, Object layoutData, boolean horizontal) {
        return Legend.createLegendComposite(panel, blockColors, keys, key_texts, layoutData, horizontal, null);
    }

    public static Composite createLegendComposite(final Composite panel, final Color[] blockColors, final String[] keys, String[] key_texts, Object layoutData, boolean horizontal, final LegendListener listener) {
        final ConfigurationManager config = ConfigurationManager.getInstance();
        if (blockColors.length != keys.length) {
            return null;
        }
        final Color[] defaultColors = new Color[blockColors.length];
        final ParameterListener[] paramListeners = new ParameterListener[keys.length];
        System.arraycopy(blockColors, 0, defaultColors, 0, blockColors.length);
        Composite legend = new Composite(panel, 0);
        if (layoutData != null) {
            legend.setLayoutData(layoutData);
        }
        RowLayout layout = new RowLayout(horizontal ? 256 : 512);
        layout.wrap = true;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.spacing = 0;
        legend.setLayout(layout);
        final int[] hover_state = new int[]{-1, 0};
        for (int i = 0; i < blockColors.length; ++i) {
            int f_i;
            int r = config.getIntParameter(keys[i] + ".red", -1);
            if (r >= 0) {
                Color color;
                int g = config.getIntParameter(keys[i] + ".green");
                int b = config.getIntParameter(keys[i] + ".blue");
                blockColors[i] = color = ColorCache.getColor(panel.getDisplay(), r, g, b);
            }
            Composite colorSet = new Composite(legend, 0);
            Utils.setLayout(colorSet, new RowLayout(256));
            final Canvas cColor = new Canvas(colorSet, 2048);
            cColor.setData("Index", new Integer(i));
            Messages.setLanguageTooltip(cColor, "label.click.to.change");
            cColor.addPaintListener(new PaintListener(){

                @Override
                public void paintControl(PaintEvent e) {
                    int i = (Integer)cColor.getData("Index");
                    e.gc.setBackground(blockColors[i]);
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                }
            });
            cColor.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseUp(MouseEvent e) {
                    Integer iIndex = (Integer)cColor.getData("Index");
                    if (iIndex == null) {
                        return;
                    }
                    int index = iIndex;
                    if (e.button == 1) {
                        RGB rgb = Utils.showColorDialog(panel, blockColors[index].getRGB());
                        if (rgb != null) {
                            config.setRGBParameter(keys[index], rgb.red, rgb.green, rgb.blue);
                        }
                    } else {
                        config.removeRGBParameter(keys[index]);
                    }
                }
            });
            final Label lblDesc = new Label(colorSet, 0);
            if (key_texts == null) {
                Messages.setLanguageText(lblDesc, keys[i]);
            } else {
                lblDesc.setText(key_texts[i]);
            }
            if (listener != null) {
                Messages.setLanguageTooltip(lblDesc, "label.click.to.showhide");
                f_i = i;
                lblDesc.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseUp(MouseEvent e) {
                        boolean vis = !config.getBooleanParameter(keys[f_i] + ".vis", true);
                        config.setParameter(keys[f_i] + ".vis", vis);
                        listener.visibilityChange(vis, f_i);
                        lblDesc.setForeground(vis ? lblDesc.getDisplay().getSystemColor(2) : Colors.grey);
                    }
                });
                boolean vis = config.getBooleanParameter(keys[f_i] + ".vis", true);
                if (!vis) {
                    listener.visibilityChange(vis, i);
                    lblDesc.setForeground(Colors.grey);
                }
            }
            RowData data = new RowData();
            data.width = 20;
            data.height = lblDesc.computeSize((int)-1, (int)-1).y - 3;
            cColor.setLayoutData(data);
            paramListeners[i] = new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    for (int j = 0; j < keys.length; ++j) {
                        if (!keys[j].equals(parameterName)) continue;
                        final int index = j;
                        final int r = config.getIntParameter(keys[j] + ".red", -1);
                        if (r >= 0) {
                            final int g = config.getIntParameter(keys[j] + ".green");
                            final int b = config.getIntParameter(keys[j] + ".blue");
                            Utils.execSWTThread(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    Color color;
                                    if (panel == null || panel.isDisposed()) {
                                        return;
                                    }
                                    blockColors[index] = color = ColorCache.getColor(panel.getDisplay(), r, g, b);
                                    cColor.redraw();
                                }
                            });
                            continue;
                        }
                        Utils.execSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                if (panel == null || panel.isDisposed()) {
                                    return;
                                }
                                blockColors[index] = defaultColors[index];
                                cColor.redraw();
                            }
                        });
                    }
                }
            };
            config.addParameterListener(keys[i], paramListeners[i]);
            if (listener == null) continue;
            f_i = i;
            Control[] controls = new Control[]{colorSet, cColor, lblDesc};
            MouseTrackListener ml = new MouseTrackListener(){

                @Override
                public void mouseEnter(MouseEvent e) {
                    Legend.handleHover(listener, true, f_i, hover_state);
                }

                @Override
                public void mouseExit(MouseEvent e) {
                    Legend.handleHover(listener, false, f_i, hover_state);
                }

                @Override
                public void mouseHover(MouseEvent e) {
                }
            };
            for (Control c : controls) {
                c.addMouseTrackListener(ml);
            }
        }
        legend.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                System.arraycopy(defaultColors, 0, blockColors, 0, blockColors.length);
                for (int i = 0; i < keys.length; ++i) {
                    config.removeParameterListener(keys[i], paramListeners[i]);
                }
            }
        });
        return legend;
    }

    private static void handleHover(final LegendListener listener, boolean entry, int index, final int[] state) {
        if (entry) {
            state[1] = state[1] + 1;
            if (state[0] != index) {
                state[0] = index;
                listener.hoverChange(true, index);
            }
        } else {
            if (state[0] == -1) {
                return;
            }
            final int timer_index = state[1] = state[1] + 1;
            Utils.execSWTThreadLater(100, new Runnable(){

                @Override
                public void run() {
                    int leaving = state[0];
                    if (timer_index != state[1] || leaving == -1) {
                        return;
                    }
                    state[0] = -1;
                    listener.hoverChange(false, leaving);
                }
            });
        }
    }

    public static interface LegendListener {
        public void hoverChange(boolean var1, int var2);

        public void visibilityChange(boolean var1, int var2);
    }
}

