/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.beta;

import com.aelitis.azureus.core.AzureusCoreFactory;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.ui.swt.beta.BetaWizardStart;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class BetaWizard
extends Wizard {
    private boolean beta_enabled;
    private boolean beta_was_enabled;
    private boolean finished;

    public BetaWizard() {
        super("beta.wizard.title", false);
        this.beta_was_enabled = this.beta_enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
        BetaWizardStart panel = new BetaWizardStart(this);
        this.setFirstPanel(panel);
    }

    @Override
    public void onClose() {
        super.onClose();
        if (this.finished) {
            COConfigurationManager.setParameter("Beta Programme Enabled", this.beta_enabled);
            if (!this.beta_enabled && Constants.IS_CVS_VERSION) {
                MessageBoxShell mb = new MessageBoxShell(34, MessageText.getString("beta.wizard.disable.title"), MessageText.getString("beta.wizard.disable.text"));
                mb.open(null);
            } else if (this.beta_enabled && !this.beta_was_enabled) {
                UpdateMonitor.getSingleton(AzureusCoreFactory.getSingleton()).performCheck(true, false, false, new UpdateCheckInstanceListener(){

                    @Override
                    public void cancelled(UpdateCheckInstance instance) {
                    }

                    @Override
                    public void complete(UpdateCheckInstance instance) {
                    }
                });
            }
        }
    }

    protected boolean getBetaEnabled() {
        return this.beta_enabled;
    }

    protected void setBetaEnabled(boolean b) {
        this.beta_enabled = b;
    }

    public void finish() {
        this.finished = true;
        this.close();
    }
}

