/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.auth;

import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.security.CryptoManagerPasswordHandler;
import java.util.Arrays;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class CryptoWindow
implements CryptoManagerPasswordHandler {
    private static final int DAY = 86400;

    public CryptoWindow() {
        this(false);
    }

    public CryptoWindow(boolean stand_alone) {
        if (!stand_alone) {
            CryptoManagerFactory.getSingleton().addPasswordHandler(this);
        }
    }

    @Override
    public int getHandlerType() {
        return 1;
    }

    @Override
    public CryptoManagerPasswordHandler.passwordDetails getPassword(final int handler_type, final int action_type, final boolean last_pw_incorrect, final String reason) {
        final Display display = SWTThread.getInstance().getDisplay();
        if (display.isDisposed()) {
            return null;
        }
        final cryptoDialog[] dialog = new cryptoDialog[1];
        final AESemaphore sem = new AESemaphore("CryptoWindowSem");
        try {
            if (display.getThread() == Thread.currentThread()) {
                dialog[0] = new cryptoDialog(sem, display, handler_type, action_type, last_pw_incorrect, reason);
                while (!display.isDisposed() && !sem.isReleasedForever()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (display.isDisposed()) {
                    return null;
                }
            } else {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        dialog[0] = new cryptoDialog(sem, display, handler_type, action_type, last_pw_incorrect, reason);
                    }
                });
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
        sem.reserve();
        final char[] pw = dialog[0].getPassword();
        final int persist_for = dialog[0].getPersistForSeconds();
        if (pw == null) {
            return null;
        }
        return new CryptoManagerPasswordHandler.passwordDetails(){

            @Override
            public char[] getPassword() {
                return pw;
            }

            @Override
            public int getPersistForSeconds() {
                return persist_for;
            }
        };
    }

    @Override
    public void passwordOK(int handler_type, CryptoManagerPasswordHandler.passwordDetails details) {
    }

    protected static class cryptoDialog {
        private AESemaphore sem;
        private Shell shell;
        private char[] password;
        private char[] password2;
        private int persist_for_secs;
        private boolean verify_password;

        protected cryptoDialog(AESemaphore _sem, Display display, int handler_type, int action_type, boolean last_pw_incorrect, String reason) {
            GridData gridData;
            this.sem = _sem;
            if (display.isDisposed()) {
                this.sem.releaseForever();
                return;
            }
            this.shell = ShellFactory.createMainShell(67680);
            Utils.setShellIcon(this.shell);
            boolean set_password = action_type == 3;
            Messages.setLanguageText(this.shell, set_password ? "security.crypto.pw.title" : "security.crypto.title");
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout(layout);
            if (action_type == 1) {
                Label reason_label = new Label(this.shell, 64);
                Messages.setLanguageText(reason_label, "security.crypto.encrypt");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 3;
                gridData.widthHint = 300;
                Utils.setLayoutData((Control)reason_label, gridData);
            } else if (action_type == 2) {
                Label decrypt_label = new Label(this.shell, 64);
                Messages.setLanguageText(decrypt_label, "security.crypto.decrypt");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 3;
                gridData.widthHint = 300;
                Utils.setLayoutData((Control)decrypt_label, gridData);
                Label reason_label = new Label(this.shell, 0);
                Messages.setLanguageText(reason_label, "security.crypto.reason");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                Utils.setLayoutData((Control)reason_label, gridData);
                Label reason_value = new Label(this.shell, 0);
                reason_value.setText(reason.replaceAll("&", "&&"));
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                Utils.setLayoutData((Control)reason_value, gridData);
                if (last_pw_incorrect) {
                    Label pw_wrong_label = new Label(this.shell, 64);
                    Messages.setLanguageText(pw_wrong_label, "security.crypto.badpw");
                    gridData = new GridData(1808);
                    gridData.horizontalSpan = 3;
                    Utils.setLayoutData((Control)pw_wrong_label, gridData);
                    pw_wrong_label.setForeground(Colors.red);
                }
            }
            Label password_label = new Label(this.shell, 0);
            Messages.setLanguageText(password_label, "security.crypto.password");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)password_label, gridData);
            final Text password_value = new Text(this.shell, 2048);
            password_value.setEchoChar('*');
            password_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)password_value, gridData);
            password_value.addListener(24, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    cryptoDialog.access$002(cryptoDialog.this, password_value.getText().toCharArray());
                }
            });
            if (action_type == 1 || set_password) {
                this.verify_password = true;
                Label password2_label = new Label(this.shell, 0);
                Messages.setLanguageText(password2_label, "security.crypto.password2");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                Utils.setLayoutData((Control)password2_label, gridData);
                final Text password2_value = new Text(this.shell, 2048);
                password2_value.setEchoChar('*');
                password2_value.setText("");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                Utils.setLayoutData((Control)password2_value, gridData);
                password2_value.addListener(24, new Listener(){

                    @Override
                    public void handleEvent(Event event2) {
                        cryptoDialog.access$102(cryptoDialog.this, password2_value.getText().toCharArray());
                    }
                });
            }
            if (!set_password) {
                Label strength_label = new Label(this.shell, 0);
                Messages.setLanguageText(strength_label, "security.crypto.persist_for");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                Utils.setLayoutData((Control)strength_label, gridData);
                String[] duration_keys = new String[]{"dont_save", "session", "day", "week", "30days", "forever"};
                final int[] duration_secs = new int[]{0, -1, 86400, 604800, 2592000, Integer.MAX_VALUE};
                final Combo durations_combo = new Combo(this.shell, 12);
                for (int i = 0; i < duration_keys.length; ++i) {
                    String text = MessageText.getString("security.crypto.persist_for." + duration_keys[i]);
                    durations_combo.add(text);
                }
                durations_combo.select(4);
                this.persist_for_secs = duration_secs[4];
                durations_combo.addListener(13, new Listener(){

                    @Override
                    public void handleEvent(Event e) {
                        cryptoDialog.this.persist_for_secs = duration_secs[durations_combo.getSelectionIndex()];
                    }
                });
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                Utils.setLayoutData((Control)durations_combo, gridData);
                new Label(this.shell, 0);
                Label linkLabel = new Label(this.shell, 0);
                linkLabel.setText(MessageText.getString("ConfigView.label.please.visit.here"));
                linkLabel.setData("http://wiki.vuze.com/w/Public_Private_Keys");
                linkLabel.setCursor(display.getSystemCursor(21));
                linkLabel.setForeground(Colors.blue);
                gridData = new GridData();
                gridData.horizontalSpan = 3;
                Utils.setLayoutData((Control)linkLabel, gridData);
                linkLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseDoubleClick(MouseEvent arg0) {
                        Utils.launch((String)((Label)arg0.widget).getData());
                    }

                    @Override
                    public void mouseDown(MouseEvent arg0) {
                        Utils.launch((String)((Label)arg0.widget).getData());
                    }
                });
                ClipboardCopy.addCopyToClipMenu(linkLabel);
            }
            Label labelSeparator = new Label(this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)labelSeparator, gridData);
            new Label(this.shell, 0);
            Button bOk = new Button(this.shell, 8);
            Messages.setLanguageText(bOk, "Button.ok");
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bOk, gridData);
            bOk.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    cryptoDialog.this.close(true);
                }
            });
            Button bCancel = new Button(this.shell, 8);
            Messages.setLanguageText(bCancel, "Button.cancel");
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bCancel, gridData);
            bCancel.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    cryptoDialog.this.close(false);
                }
            });
            this.shell.setDefaultButton(bOk);
            this.shell.addListener(31, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        cryptoDialog.this.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close(boolean ok) {
            try {
                if (ok) {
                    if (this.password == null) {
                        this.password = new char[0];
                    }
                    if (this.password2 == null) {
                        this.password2 = new char[0];
                    }
                    if (this.verify_password && !Arrays.equals(this.password, this.password2)) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setText(MessageText.getString("security.crypto.password.mismatch.title"));
                        mb.setMessage(MessageText.getString("security.crypto.password.mismatch"));
                        mb.open();
                        return;
                    }
                } else {
                    this.password = null;
                }
                this.shell.dispose();
            }
            finally {
                this.sem.releaseForever();
            }
        }

        protected char[] getPassword() {
            return this.password;
        }

        protected int getPersistForSeconds() {
            return this.persist_for_secs;
        }

        static /* synthetic */ char[] access$002(cryptoDialog x0, char[] x1) {
            x0.password = x1;
            return x1;
        }

        static /* synthetic */ char[] access$102(cryptoDialog x0, char[] x1) {
            x0.password2 = x1;
            return x1;
        }
    }
}

