/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.auth;

import java.security.cert.X509Certificate;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class CertificateTrustWindow
implements SECertificateListener {
    public CertificateTrustWindow() {
        SESecurityManager.addCertificateListener(this);
    }

    @Override
    public boolean trustCertificate(String _resource, final X509Certificate cert) {
        final Display display = SWTThread.getInstance().getDisplay();
        if (display.isDisposed()) {
            return false;
        }
        TOTorrent torrent = TorrentUtils.getTLSTorrent();
        final String resource = torrent != null ? TorrentUtils.getLocalisedName(torrent) + "\n" + _resource : _resource;
        final trustDialog[] dialog = new trustDialog[1];
        try {
            Utils.execSWTThread((Runnable)new AERunnable(){

                @Override
                public void runSupport() {
                    dialog[0] = new trustDialog(display, resource, cert);
                }
            }, false);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
        return dialog[0].getTrusted();
    }

    protected static class trustDialog {
        protected Shell shell;
        protected boolean trusted;

        protected trustDialog(Display display, String resource, X509Certificate cert) {
            if (display.isDisposed()) {
                return;
            }
            this.shell = ShellFactory.createMainShell(67680);
            Utils.setShellIcon(this.shell);
            this.shell.setText(MessageText.getString("security.certtruster.title"));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout(layout);
            Label info_label = new Label(this.shell, 0);
            Messages.setLanguageText(info_label, "security.certtruster.intro");
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)info_label, gridData);
            Label resource_label = new Label(this.shell, 0);
            Messages.setLanguageText(resource_label, "security.certtruster.resource");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)resource_label, gridData);
            Label resource_value = new Label(this.shell, 64);
            resource_value.setText(resource.replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)resource_value, gridData);
            Label issued_by_label = new Label(this.shell, 0);
            Messages.setLanguageText(issued_by_label, "security.certtruster.issuedby");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)issued_by_label, gridData);
            Label issued_by_value = new Label(this.shell, 0);
            issued_by_value.setText(this.extractCN(cert.getIssuerDN().getName()).replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)issued_by_value, gridData);
            Label issued_to_label = new Label(this.shell, 0);
            Messages.setLanguageText(issued_to_label, "security.certtruster.issuedto");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)issued_to_label, gridData);
            Label issued_to_value = new Label(this.shell, 0);
            issued_to_value.setText(this.extractCN(cert.getSubjectDN().getName()).replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)issued_to_value, gridData);
            Label prompt_label = new Label(this.shell, 0);
            Messages.setLanguageText(prompt_label, "security.certtruster.prompt");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)prompt_label, gridData);
            Label labelSeparator = new Label(this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)labelSeparator, gridData);
            new Label(this.shell, 0);
            Composite comp2 = new Composite(this.shell, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)comp2, gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 2;
            comp2.setLayout(layoutButtons);
            Button bYes = new Button(comp2, 8);
            bYes.setText(MessageText.getString("security.certtruster.yes"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bYes, gridData);
            bYes.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    trustDialog.this.close(true);
                }
            });
            Button bNo = new Button(comp2, 8);
            bNo.setText(MessageText.getString("security.certtruster.no"));
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bNo, gridData);
            bNo.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    trustDialog.this.close(false);
                }
            });
            this.shell.setDefaultButton(bYes);
            this.shell.addListener(31, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        trustDialog.this.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (this.shell.getDisplay().readAndDispatch()) continue;
                this.shell.getDisplay().sleep();
            }
        }

        protected void close(boolean ok) {
            this.trusted = ok;
            this.shell.dispose();
        }

        protected String extractCN(String dn) {
            int p1 = dn.indexOf("CN=");
            if (p1 == -1) {
                return dn;
            }
            int p2 = dn.indexOf(",", p1);
            if (p2 == -1) {
                return dn.substring(p1 + 3).trim();
            }
            return dn.substring(p1 + 3, p2).trim();
        }

        public boolean getTrusted() {
            return this.trusted;
        }
    }
}

