/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.auth;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class CertificateCreatorWindow {
    public CertificateCreatorWindow() {
        this.createCertificate();
    }

    public void createCertificate() {
        final Display display = SWTThread.getInstance().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        try {
            display.asyncExec(new AERunnable(){

                @Override
                public void runSupport() {
                    new createDialog(display);
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected static class createDialog {
        protected Shell shell;

        protected createDialog(Display display) {
            if (display.isDisposed()) {
                return;
            }
            this.shell = ShellFactory.createMainShell(67680);
            Utils.setShellIcon(this.shell);
            Messages.setLanguageText(this.shell, "security.certcreate.title");
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout(layout);
            Label info_label = new Label(this.shell, 0);
            Messages.setLanguageText(info_label, "security.certcreate.intro");
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)info_label, gridData);
            Label alias_label = new Label(this.shell, 0);
            Messages.setLanguageText(alias_label, "security.certcreate.alias");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)alias_label, gridData);
            final Text alias_field = new Text(this.shell, 2048);
            alias_field.setText("Azureus");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)alias_field, gridData);
            Label strength_label = new Label(this.shell, 0);
            Messages.setLanguageText(strength_label, "security.certcreate.strength");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)strength_label, gridData);
            final Combo strength_combo = new Combo(this.shell, 12);
            final int[] strengths = new int[]{512, 1024, 1536, 2048};
            for (int i = 0; i < strengths.length; ++i) {
                strength_combo.add("" + strengths[i]);
            }
            strength_combo.select(1);
            new Label(this.shell, 0);
            String[] field_names = new String[]{"security.certcreate.firstlastname", "security.certcreate.orgunit", "security.certcreate.org", "security.certcreate.city", "security.certcreate.state", "security.certcreate.country"};
            final String[] field_rns = new String[]{"CN", "OU", "O", "L", "ST", "C"};
            final Text[] fields = new Text[field_names.length];
            for (int i = 0; i < fields.length; ++i) {
                Label resource_label = new Label(this.shell, 0);
                Messages.setLanguageText(resource_label, field_names[i]);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                Utils.setLayoutData((Control)resource_label, gridData);
                Text field = fields[i] = new Text(this.shell, 2048);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                Utils.setLayoutData((Control)field, gridData);
            }
            Label labelSeparator = new Label(this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)labelSeparator, gridData);
            new Label(this.shell, 0);
            Composite comp2 = new Composite(this.shell, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)comp2, gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 2;
            comp2.setLayout(layoutButtons);
            Button bYes = new Button(comp2, 8);
            Messages.setLanguageText(bYes, "security.certcreate.ok");
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bYes, gridData);
            bYes.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    String alias = alias_field.getText().trim();
                    int strength = strengths[strength_combo.getSelectionIndex()];
                    String dn = "";
                    for (int i = 0; i < fields.length; ++i) {
                        String rn = fields[i].getText().trim();
                        if (rn.length() == 0) {
                            rn = "Unknown";
                        }
                        dn = dn + (dn.length() == 0 ? "" : ",") + field_rns[i] + "=" + rn;
                    }
                    try {
                        SESecurityManager.createSelfSignedCertificate(alias, dn, strength);
                        createDialog.this.close(true);
                        Logger.log(new LogAlert(false, 0, MessageText.getString("security.certcreate.createok") + "\n" + alias + ":" + strength + "\n" + dn + "\n" + SystemTime.getCurrentTime()));
                    }
                    catch (Throwable f) {
                        Logger.log(new LogAlert(false, MessageText.getString("security.certcreate.createfail") + "\n" + SystemTime.getCurrentTime(), f));
                    }
                }
            });
            Button bNo = new Button(comp2, 8);
            Messages.setLanguageText(bNo, "security.certcreate.cancel");
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bNo, gridData);
            bNo.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    createDialog.this.close(false);
                }
            });
            this.shell.setDefaultButton(bYes);
            this.shell.addListener(31, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        createDialog.this.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
        }

        protected void close(boolean ok) {
            this.shell.dispose();
        }
    }
}

