/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;

public class UserAlerts {
    private static UserAlerts singleton;
    private AudioClip audio_clip = null;
    private String audio_resource = "";
    private AEMonitor this_mon = new AEMonitor("UserAlerts");
    private boolean startup = true;
    private long last_error_speech;
    private long last_error_sound;

    public static UserAlerts getSingleton() {
        return singleton;
    }

    public UserAlerts(GlobalManager global_manager) {
        singleton = this;
        final DownloadManagerAdapter download_manager_listener = new DownloadManagerAdapter(){

            @Override
            public void downloadComplete(DownloadManager manager) {
                UserAlerts.this.activityFinished(manager, null);
            }

            @Override
            public void stateChanged(final DownloadManager manager, int state) {
                boolean lowNoise = manager.getDownloadState().getFlag(16L);
                if (lowNoise) {
                    return;
                }
                if (state == 50 || state == 60) {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            boolean complete = manager.isDownloadComplete(false);
                            if (!complete && COConfigurationManager.getBooleanParameter("Open Details") || complete && COConfigurationManager.getBooleanParameter("Open Seeding Details")) {
                                UIFunctionsManager.getUIFunctions().getMDI().loadEntryByID("DMDetails", false, false, manager);
                            }
                            if (!complete && COConfigurationManager.getBooleanParameter("Open Bar Incomplete") || complete && COConfigurationManager.getBooleanParameter("Open Bar Complete")) {
                                DownloadBar.open(manager, Utils.findAnyShell());
                            }
                        }
                    });
                }
                boolean error_reported = manager.getDownloadState().getFlag(2048L);
                if (state == 100) {
                    if (!error_reported) {
                        manager.getDownloadState().setFlag(2048L, true);
                        UserAlerts.this.reportError(manager);
                    }
                } else if ((state == 50 || state == 60) && error_reported) {
                    manager.getDownloadState().setFlag(2048L, false);
                }
            }
        };
        final DiskManagerListener disk_listener = new DiskManagerListener(){

            @Override
            public void stateChanged(int oldState, int newState) {
            }

            @Override
            public void filePriorityChanged(DiskManagerFileInfo file) {
            }

            @Override
            public void pieceDoneChanged(DiskManagerPiece piece) {
            }

            @Override
            public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
                DownloadManager dm = file.getDownloadManager();
                if (dm != null && old_mode == 2 && new_mode == 1 && file.getDownloaded() == file.getLength()) {
                    UserAlerts.this.activityFinished(dm, file);
                }
            }
        };
        final DownloadManagerDiskListener dm_disk_listener = new DownloadManagerDiskListener(){

            @Override
            public void diskManagerAdded(DiskManager dm) {
                dm.addListener(disk_listener);
            }

            @Override
            public void diskManagerRemoved(DiskManager dm) {
                dm.removeListener(disk_listener);
            }
        };
        global_manager.addListener(new GlobalManagerAdapter(){

            @Override
            public void downloadManagerAdded(DownloadManager manager) {
                boolean bPopup;
                if (!UserAlerts.this.startup && manager.isPersistent() && (bPopup = COConfigurationManager.getBooleanParameter("Popup Download Added")) && !manager.getDownloadState().getFlag(16L)) {
                    String popup_text = MessageText.getString("popup.download.added", new String[]{manager.getDisplayName()});
                    UserAlerts.this.forceNotify(0, null, popup_text, null, new Object[]{manager}, -1);
                }
                manager.addListener(download_manager_listener);
                manager.addDiskListener(dm_disk_listener);
            }

            @Override
            public void downloadManagerRemoved(DownloadManager manager) {
                manager.removeListener(download_manager_listener);
                manager.removeDiskListener(dm_disk_listener);
            }

            @Override
            public void destroyed() {
                UserAlerts.this.tidyUp();
            }
        });
        this.startup = false;
    }

    private void activityFinished(DownloadManager manager, DiskManagerFileInfo dm_file) {
        String popup_def_text;
        String popup_enabler;
        String speech_text;
        String speech_enabler;
        String sound_file;
        String sound_enabler;
        String item_name;
        Object relatedObject;
        boolean download;
        DownloadManagerState dm_state = manager.getDownloadState();
        if (dm_state.getFlag(16L)) {
            return;
        }
        boolean bl = download = dm_file == null;
        if (download) {
            relatedObject = manager;
            item_name = manager.getDisplayName();
        } else {
            relatedObject = dm_file.getDiskManager();
            item_name = dm_file.getFile(true).getName();
        }
        if (download) {
            sound_enabler = "Play Download Finished";
            sound_file = "Play Download Finished File";
            speech_enabler = "Play Download Finished Announcement";
            speech_text = "Play Download Finished Announcement Text";
            popup_enabler = "Popup Download Finished";
            popup_def_text = "popup.download.finished";
        } else {
            sound_enabler = "Play File Finished";
            sound_file = "Play File Finished File";
            speech_enabler = "Play File Finished Announcement";
            speech_text = "Play File Finished Announcement Text";
            popup_enabler = "Popup File Finished";
            popup_def_text = "popup.file.finished";
        }
        Map dl_file_alerts = dm_state.getMapAttribute("df_alerts");
        String dlf_prefix = download ? "" : String.valueOf(dm_file.getIndex()) + ".";
        boolean do_popup = COConfigurationManager.getBooleanParameter(popup_enabler) || this.isDLFEnabled(dl_file_alerts, dlf_prefix, popup_enabler);
        boolean do_speech = Constants.isOSX && (COConfigurationManager.getBooleanParameter(speech_enabler) || this.isDLFEnabled(dl_file_alerts, dlf_prefix, speech_enabler));
        boolean do_sound = COConfigurationManager.getBooleanParameter(sound_enabler, false) || this.isDLFEnabled(dl_file_alerts, dlf_prefix, sound_enabler);
        this.doStuff(relatedObject, item_name, do_popup, popup_def_text, false, do_speech, speech_text, do_sound, sound_file);
    }

    private void reportError(DownloadManager manager) {
        boolean do_sound;
        DownloadManager relatedObject = manager;
        String item_name = manager.getDisplayName();
        String sound_enabler = "Play Download Error";
        String sound_file = "Play Download Error File";
        String speech_enabler = "Play Download Error Announcement";
        String speech_text = "Play Download Error Announcement Text";
        String popup_enabler = "Popup Download Error";
        String popup_def_text = "popup.download.error";
        long now = SystemTime.getMonotonousTime();
        boolean do_popup = COConfigurationManager.getBooleanParameter("Popup Download Error");
        boolean do_speech = Constants.isOSX && COConfigurationManager.getBooleanParameter("Play Download Error Announcement") && (this.last_error_speech == 0L || now - this.last_error_speech > 5000L);
        boolean bl = do_sound = COConfigurationManager.getBooleanParameter("Play Download Error", false) && (this.last_error_sound == 0L || now - this.last_error_sound > 5000L);
        if (do_speech) {
            this.last_error_speech = now;
        }
        if (do_sound) {
            this.last_error_sound = now;
        }
        this.doStuff(relatedObject, item_name, do_popup, "popup.download.error", true, do_speech, "Play Download Error Announcement Text", do_sound, "Play Download Error File");
    }

    public void notificationAdded() {
        boolean do_popup = false;
        boolean do_speech = Constants.isOSX && COConfigurationManager.getBooleanParameter("Play Notification Added Announcement");
        boolean do_sound = COConfigurationManager.getBooleanParameter("Play Notification Added", false);
        this.doStuff(null, null, do_popup, null, false, do_speech, "Play Notification Added Announcement Text", do_sound, "Play Notification Added File");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStuff(Object relatedObject, String item_name, boolean do_popup, String popup_def_text, boolean popup_is_error, boolean do_speech, final String speech_text, boolean do_sound, String sound_file) {
        block19: {
            String default_sound = "org/gudy/azureus2/ui/icons/downloadFinished.wav";
            try {
                this.this_mon.enter();
                if (do_popup) {
                    String popup_text = MessageText.getString(popup_def_text, new String[]{item_name});
                    this.forceNotify(popup_is_error ? 2 : 0, null, popup_text, null, new Object[]{relatedObject}, -1);
                }
                if (do_speech) {
                    new AEThread2("SaySound"){

                        @Override
                        public void run() {
                            try {
                                Runtime.getRuntime().exec(new String[]{"say", COConfigurationManager.getStringParameter(speech_text)});
                                Thread.sleep(2500L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
                if (!do_sound) break block19;
                String file = COConfigurationManager.getStringParameter(sound_file);
                if ((file = file.trim()).startsWith("<")) {
                    file = "";
                }
                if (this.audio_clip == null || !file.equals(this.audio_resource)) {
                    this.audio_clip = null;
                    if (file.length() != 0) {
                        File f = new File(file);
                        try {
                            if (f.exists()) {
                                URL file_url = f.toURI().toURL();
                                this.audio_clip = Applet.newAudioClip(file_url);
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        finally {
                            if (this.audio_clip == null) {
                                Logger.log(new LogAlert(relatedObject, false, 3, "Failed to load audio file '" + file + "'"));
                            }
                        }
                    }
                    if (this.audio_clip == null) {
                        this.audio_clip = Applet.newAudioClip(UserAlerts.class.getClassLoader().getResource("org/gudy/azureus2/ui/icons/downloadFinished.wav"));
                    }
                    this.audio_resource = file;
                }
                if (this.audio_clip != null) {
                    new AEThread2("DownloadSound"){

                        @Override
                        public void run() {
                            try {
                                UserAlerts.this.audio_clip.play();
                                Thread.sleep(2500L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    private boolean isDLFEnabled(Map map, String prefix, String key) {
        if (map == null) {
            return false;
        }
        key = prefix + key;
        return map.containsKey(key);
    }

    private void forceNotify(final int iconID, final String title, final String text, final String details, final Object[] relatedObjects, final int timeoutSecs) {
        UIFunctionsManager.execWithUIFunctions(new UIFunctionsManager.UIFCallback(){

            @Override
            public void run(UIFunctions uif) {
                uif.forceNotify(iconID, title, text, details, relatedObjects, timeoutSecs);
            }
        });
    }

    protected void tidyUp() {
        try {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            Thread[] threadList = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threadList);
            for (int i = 0; i < threadList.length; ++i) {
                if (threadList[i] == null || !"Java Sound event dispatcher".equals(threadList[i].getName())) continue;
                threadList[i].interrupt();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void requestUserAttention(int type, Object data) {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (pm.hasCapability(PlatformManagerCapabilities.RequestUserAttention)) {
            try {
                pm.requestUserAttention(type, data);
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

