/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class UIExitUtilsSWT {
    private static boolean skipCloseCheck = false;
    private static CopyOnWriteList<canCloseListener> listeners = new CopyOnWriteList();

    public static void addListener(canCloseListener l) {
        listeners.add(l);
    }

    public static void removeListener(canCloseListener l) {
        listeners.remove(l);
    }

    public static void setSkipCloseCheck(boolean b) {
        skipCloseCheck = b;
    }

    public static boolean canClose(GlobalManager globalManager, boolean bForRestart) {
        if (skipCloseCheck) {
            return true;
        }
        Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
        if (mainShell != null && (!mainShell.isVisible() || mainShell.getMinimized()) && COConfigurationManager.getBooleanParameter("Password enabled") && !PasswordWindow.showPasswordWindow(Display.getCurrent())) {
            return false;
        }
        if (COConfigurationManager.getBooleanParameter("confirmationOnExit") && !UIExitUtilsSWT.getExitConfirmation(bForRestart)) {
            return false;
        }
        for (canCloseListener listener : listeners) {
            if (listener.canClose()) continue;
            return false;
        }
        return true;
    }

    private static boolean getExitConfirmation(boolean for_restart) {
        MessageBoxShell mb = new MessageBoxShell(200, for_restart ? "MainWindow.dialog.restartconfirmation" : "MainWindow.dialog.exitconfirmation", (String[])null);
        mb.open(null);
        return mb.waitUntilClosed() == 64;
    }

    public static void uiShutdown() {
        if (SystemProperties.isJavaWebStartInstance()) {
            AEThread close = new AEThread("JWS Force Terminate"){

                @Override
                public void runSupport() {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    SESecurityManager.exitVM(1);
                }
            };
            close.setDaemon(true);
            close.start();
        }
    }

    public static interface canCloseListener {
        public boolean canClose();
    }
}

