/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class PropertiesWindow {
    private final Shell shell;
    private Map<String, BufferedLabel> field_map = new HashMap<String, BufferedLabel>();

    public PropertiesWindow(String object_name, String[] keys, String[] values) {
        this.shell = ShellFactory.createMainShell(112);
        this.shell.setText(MessageText.getString("props.window.title", new String[]{object_name}));
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout(layout);
        final ScrolledComposite scrollable = new ScrolledComposite(this.shell, 768);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        Utils.setLayoutData((Control)scrollable, gridData);
        final Composite main = new Composite(scrollable, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        main.setLayout(layout);
        scrollable.setContent(main);
        scrollable.setExpandVertical(true);
        scrollable.setExpandHorizontal(true);
        scrollable.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent e) {
                Rectangle r = scrollable.getClientArea();
                scrollable.setMinSize(main.computeSize(r.width, -1));
            }
        });
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        Utils.setLayoutData((Control)main, gridData);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null || values[i] == null) continue;
            BufferedLabel msg_label = new BufferedLabel(main, 0);
            String key = keys[i];
            String msg = key.length() == 0 ? "" : (key.startsWith("!") && key.endsWith("!") ? key.substring(1, key.length() - 1) : MessageText.getString(key));
            String value = values[i];
            if (value.equals("<null>")) {
                msg_label.setText(msg);
                value = "";
            } else {
                msg_label.setText(msg.length() == 0 ? "" : msg + ":");
            }
            gridData = new GridData();
            gridData.verticalAlignment = 16;
            Utils.setLayoutData(msg_label, gridData);
            BufferedLabel val_label = new BufferedLabel(main, 64);
            val_label.setText(value);
            gridData = new GridData(768);
            gridData.horizontalIndent = 6;
            Utils.setLayoutData(val_label, gridData);
            this.field_map.put(key, val_label);
        }
        Label labelSeparator = new Label(this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        Utils.setLayoutData((Control)labelSeparator, gridData);
        new Label(this.shell, 0);
        Button bOk = new Button(this.shell, 8);
        Messages.setLanguageText(bOk, "Button.ok");
        gridData = new GridData(896);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 70;
        Utils.setLayoutData((Control)bOk, gridData);
        bOk.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                PropertiesWindow.this.close();
            }
        });
        Button bCancel = new Button(this.shell, 8);
        Messages.setLanguageText(bCancel, "Button.cancel");
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 70;
        Utils.setLayoutData((Control)bCancel, gridData);
        bCancel.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                PropertiesWindow.this.close();
            }
        });
        this.shell.setDefaultButton(bOk);
        this.shell.addListener(31, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    PropertiesWindow.this.close();
                }
            }
        });
        if (!Utils.linkShellMetricsToConfig(this.shell, "PropWin")) {
            int shell_width = 400;
            int main_height = main.computeSize((int)shell_width, (int)-1).y;
            main_height = Math.max(main_height, 250);
            main_height = Math.min(main_height, 500);
            int shell_height = main_height + 50;
            this.shell.setSize(shell_width, shell_height);
        }
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    public void updateProperty(final String key, final String value) {
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                BufferedLabel label = (BufferedLabel)PropertiesWindow.this.field_map.get(key);
                if (label != null && !label.isDisposed()) {
                    label.setText(value);
                }
            }
        });
    }

    protected void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }
}

