/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.BrowserWrapper;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class BrowserWrapperFake
extends BrowserWrapper {
    private Composite parent;
    private Composite browser;
    private Label link_label;
    private Label description_label;
    private String url;
    private String description;
    private List<LocationListener> location_listeners = new ArrayList<LocationListener>();
    private List<ProgressListener> progress_listeners = new ArrayList<ProgressListener>();
    private List<TitleListener> title_listeners = new ArrayList<TitleListener>();

    protected BrowserWrapperFake(Composite _parent, int style, SWTError _failure) {
        GridData grid_data;
        Label label;
        this.parent = _parent;
        this.browser = new Composite(this.parent, 0);
        this.browser.setBackground(Colors.white);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.browser.setLayout(layout);
        if (_failure == null) {
            label = new Label(this.browser, 64);
            Messages.setLanguageText(label, "browser.internal.disabled.info");
            grid_data = new GridData(768);
            grid_data.horizontalSpan = 3;
            Utils.setLayoutData((Control)label, grid_data);
            label.setBackground(Colors.white);
            label = new Label(this.browser, 0);
            Messages.setLanguageText(label, "browser.internal.disabled.reenable");
            final Button button = new Button(this.browser, 0);
            Messages.setLanguageText(button, "label.enable");
            button.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    button.setEnabled(false);
                    COConfigurationManager.setParameter("browser.internal.disable", false);
                }
            });
            label = new Label(this.browser, 0);
            grid_data = new GridData(768);
            Utils.setLayoutData((Control)label, grid_data);
        } else {
            label = new Label(this.browser, 64);
            Messages.setLanguageText((Widget)label, "browser.internal.failed.info", new String[]{Debug.getNestedExceptionMessage(_failure)});
            grid_data = new GridData(768);
            grid_data.horizontalSpan = 3;
            Utils.setLayoutData((Control)label, grid_data);
            label.setBackground(Colors.white);
        }
        Composite details = new Composite(this.browser, 2048);
        layout = new GridLayout();
        layout.numColumns = 2;
        details.setLayout(layout);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 3;
        Utils.setLayoutData((Control)details, grid_data);
        details.setBackground(Colors.white);
        Label label2 = new Label(details, 0);
        label2.setText("URL");
        Utils.setLayoutData((Control)label2, new GridData());
        label2.setBackground(Colors.white);
        this.link_label = new Label(details, 0);
        this.link_label.setText(MessageText.getString("ConfigView.label.please.visit.here"));
        this.link_label.setCursor(this.link_label.getDisplay().getSystemCursor(21));
        this.link_label.setForeground(Colors.blue);
        this.link_label.setBackground(Colors.white);
        this.link_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                Utils.launch(BrowserWrapperFake.this.url);
            }

            @Override
            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && e.stateMask != 262144) {
                    Utils.launch(BrowserWrapperFake.this.url);
                }
            }
        });
        grid_data = new GridData(768);
        grid_data.horizontalIndent = 10;
        Utils.setLayoutData((Control)this.link_label, grid_data);
        ClipboardCopy.addCopyToClipMenu(this.link_label, new ClipboardCopy.copyToClipProvider(){

            @Override
            public String getText() {
                return BrowserWrapperFake.this.url;
            }
        });
        label2 = new Label(details, 0);
        Messages.setLanguageText(label2, "columnChooser.columndescription");
        Utils.setLayoutData((Control)label2, new GridData());
        label2.setBackground(Colors.white);
        this.description_label = new Label(details, 0);
        this.description_label.setText("");
        grid_data = new GridData(768);
        grid_data.horizontalIndent = 10;
        Utils.setLayoutData((Control)this.description_label, grid_data);
        this.description_label.setBackground(Colors.white);
    }

    @Override
    public boolean isFake() {
        return true;
    }

    @Override
    public Composite getControl() {
        return this.browser;
    }

    @Override
    public void setBrowser(WindowEvent event2) {
    }

    @Override
    public void setVisible(boolean visible) {
        this.browser.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this.browser.isVisible();
    }

    @Override
    public boolean isDisposed() {
        return this.browser.isDisposed();
    }

    @Override
    public void dispose() {
        this.browser.dispose();
    }

    @Override
    public boolean execute(String str) {
        return false;
    }

    @Override
    public boolean isBackEnabled() {
        return false;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(final String _url) {
        this.url = _url;
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                TypedEvent event2;
                String url_str = _url;
                int pos = url_str.indexOf(63);
                if (pos != -1) {
                    url_str = url_str.substring(0, pos);
                }
                BrowserWrapperFake.this.link_label.setText(url_str);
                BrowserWrapperFake.this.browser.layout();
                for (SWTEventListener l : BrowserWrapperFake.this.location_listeners) {
                    try {
                        event2 = new LocationEvent(BrowserWrapperFake.this.browser);
                        event2.top = true;
                        event2.location = _url;
                        l.changed((LocationEvent)event2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                for (SWTEventListener l : BrowserWrapperFake.this.progress_listeners) {
                    try {
                        event2 = new ProgressEvent(BrowserWrapperFake.this.browser);
                        l.completed((ProgressEvent)event2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                for (SWTEventListener l : BrowserWrapperFake.this.title_listeners) {
                    try {
                        event2 = new TitleEvent(BrowserWrapperFake.this.browser);
                        ((TitleEvent)event2).title = "Browser Disabled";
                        l.changed((TitleEvent)event2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    @Override
    public void setText(String text) {
        this.description = text;
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                BrowserWrapperFake.this.description_label.setText(BrowserWrapperFake.this.description);
                BrowserWrapperFake.this.browser.layout();
            }
        });
    }

    @Override
    public void setData(String key, Object value) {
        this.browser.setData(key, value);
    }

    @Override
    public Object getData(String key) {
        return this.browser.getData(key);
    }

    @Override
    public void back() {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void update() {
        this.browser.update();
    }

    @Override
    public Shell getShell() {
        return this.browser.getShell();
    }

    @Override
    public Display getDisplay() {
        return this.browser.getDisplay();
    }

    @Override
    public Composite getParent() {
        return this.browser.getParent();
    }

    @Override
    public Object getLayoutData() {
        return this.browser.getLayoutData();
    }

    @Override
    public void setLayoutData(Object data) {
        this.browser.setLayoutData(data);
    }

    @Override
    public void setFocus() {
        this.browser.setFocus();
    }

    @Override
    public void addListener(int type, Listener l) {
        this.browser.addListener(type, l);
    }

    @Override
    public void addLocationListener(LocationListener l) {
        this.location_listeners.add(l);
    }

    @Override
    public void removeLocationListener(LocationListener l) {
        this.location_listeners.remove(l);
    }

    @Override
    public void addTitleListener(TitleListener l) {
        this.title_listeners.add(l);
    }

    @Override
    public void addProgressListener(ProgressListener l) {
        this.progress_listeners.add(l);
    }

    @Override
    public void removeProgressListener(ProgressListener l) {
        this.progress_listeners.remove(l);
    }

    @Override
    public void addOpenWindowListener(OpenWindowListener l) {
    }

    @Override
    public void addCloseWindowListener(CloseWindowListener l) {
    }

    @Override
    public void addDisposeListener(DisposeListener l) {
        this.browser.addDisposeListener(l);
    }

    @Override
    public void removeDisposeListener(DisposeListener l) {
        this.browser.removeDisposeListener(l);
    }

    @Override
    public void addStatusTextListener(StatusTextListener l) {
    }

    @Override
    public void removeStatusTextListener(StatusTextListener l) {
    }

    @Override
    public BrowserWrapper.BrowserFunction addBrowserFunction(String name, BrowserWrapper.BrowserFunction bf) {
        return new BrowserFunctionFake(bf);
    }

    public static class BrowserFunctionFake
    extends BrowserWrapper.BrowserFunction {
        private final BrowserWrapper.BrowserFunction bf;
        private boolean disposed;

        private BrowserFunctionFake(BrowserWrapper.BrowserFunction _bf) {
            this.bf = _bf;
            this.bf.bind(this);
        }

        @Override
        public Object function(Object[] arguments) {
            return this.bf.function(arguments);
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

