/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.PrintStream;
import java.util.List;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;

public class Archive
extends IConsoleCommand {
    public Archive() {
        super("archive", "ar");
    }

    @Override
    public String getCommandDescriptions() {
        return "archive\t\tar\tLists, and allows the restoration of, archived downloads.";
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> -----");
        out.println("Subcommands:");
        out.println("list\t\tl\t\tList archived downloads");
        out.println("show <num>\ts\t\tShow archived download");
        out.println("restore <num>\tres\t\tRestore archived download");
        out.println("delete <num>\tdel\t\tDelete archived download");
        out.println("> -----");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        DownloadStub stub;
        if (args.size() <= 0) {
            this.printHelp(ci.out, args);
            return;
        }
        PluginInterface pi = ci.getCore().getPluginManager().getDefaultPluginInterface();
        DownloadStub[] stubs = pi.getDownloadManager().getDownloadStubs();
        String sub = args.get(0);
        int index = -1;
        if (args.size() > 1) {
            String index_str = args.get(1);
            try {
                index = Integer.parseInt(index_str);
                if (--index < 0 || index >= stubs.length) {
                    index = -1;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (index == -1) {
                ci.out.println("Invalid archive index: " + index_str);
            }
        }
        if (sub.equals("list") || sub.equals("l")) {
            int pos = 1;
            ci.out.println("> -----");
            DownloadStub[] arr$ = stubs;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) {
                    ci.out.println("> -----");
                    return;
                }
                DownloadStub stub2 = arr$[i$];
                System.out.println(" " + pos++ + "\t" + stub2.getName() + " (" + DisplayFormatters.formatByteCountToKiBEtc(stub2.getTorrentSize()) + ")");
                ++i$;
            }
        }
        if (index != -1 && (sub.equals("show") || sub.equals("s"))) {
            try {
                stub = stubs[index];
                ci.out.println("> -----");
                ci.out.println("  " + stub.getName() + " - hash=" + ByteFormatter.encodeString(stub.getTorrentHash()));
                DownloadStub.DownloadStubFile[] files = stub.getStubFiles();
                ci.out.println("  Files: " + files.length);
                DownloadStub.DownloadStubFile[] arr$ = files;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) {
                        ci.out.println("> -----");
                        return;
                    }
                    DownloadStub.DownloadStubFile file = arr$[i$];
                    long length = file.getLength();
                    ci.out.println("    " + file.getFile() + " - " + (length < 0L ? "Not downloaded" : DisplayFormatters.formatByteCountToKiBEtc(length)));
                    ++i$;
                }
            }
            catch (Throwable e) {
                ci.out.print(e);
                return;
            }
        }
        if (index != -1 && (sub.equals("restore") || sub.equals("res"))) {
            try {
                Download d = stubs[index].destubbify();
                ci.out.println("> Restore of " + d.getName() + " succeeded.");
                return;
            }
            catch (Throwable e) {
                ci.out.print(e);
                return;
            }
        }
        if (index != -1 && (sub.equals("delete") || sub.equals("del"))) {
            try {
                stub = stubs[index];
                String name = stub.getName();
                stub.remove();
                ci.out.println("> Delete of " + name + " succeeded.");
                return;
            }
            catch (Throwable e) {
                ci.out.print(e);
                return;
            }
        }
        ci.out.println("Unsupported sub-command: " + sub);
    }
}

