/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser;

import java.io.PrintWriter;
import java.util.Vector;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentAttributeImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SimpleXMLParserDocumentNodeImpl
implements SimpleXMLParserDocumentNode {
    protected SimpleXMLParserDocumentImpl document;
    protected Node node;
    protected SimpleXMLParserDocumentNode[] kids;

    protected SimpleXMLParserDocumentNodeImpl(SimpleXMLParserDocumentImpl _doc, Node _node) {
        this.document = _doc;
        this.node = _node;
    }

    protected Node getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return this.node.getLocalName();
    }

    @Override
    public String getFullName() {
        return this.node.getNodeName();
    }

    @Override
    public String getNameSpaceURI() {
        return this.node.getNamespaceURI();
    }

    @Override
    public String getValue() {
        if (this.node.getNodeType() == 7) {
            return this.node.getNodeValue();
        }
        String res = "";
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type != 4 && type != 3 && type != 12) continue;
            String str = child.getNodeValue();
            res = res + str;
        }
        return res;
    }

    @Override
    public SimpleXMLParserDocumentAttribute getAttribute(String name) {
        SimpleXMLParserDocumentAttribute[] attributes = this.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equalsIgnoreCase(name)) continue;
            return attributes[i];
        }
        return null;
    }

    @Override
    public SimpleXMLParserDocumentAttribute[] getAttributes() {
        Vector<SimpleXMLParserDocumentAttributeImpl> v = new Vector<SimpleXMLParserDocumentAttributeImpl>();
        if (this.node.getNodeType() == 1) {
            NamedNodeMap atts = this.node.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                Node child = atts.item(i);
                v.addElement(new SimpleXMLParserDocumentAttributeImpl(child.getNodeName(), child.getNodeValue()));
            }
        }
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type != 2) continue;
            v.addElement(new SimpleXMLParserDocumentAttributeImpl(child.getNodeName(), child.getNodeValue()));
        }
        Object[] res = new SimpleXMLParserDocumentAttributeImpl[v.size()];
        v.copyInto(res);
        return res;
    }

    @Override
    public SimpleXMLParserDocumentNode[] getChildren() {
        if (this.kids == null) {
            this.kids = this.document.parseNode(this.node, true);
        }
        return this.kids;
    }

    @Override
    public SimpleXMLParserDocumentNode getChild(String name) {
        SimpleXMLParserDocumentNode[] kids = this.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].getName().equalsIgnoreCase(name)) continue;
            return kids[i];
        }
        return null;
    }

    @Override
    public void print() {
        PrintWriter pw = new PrintWriter(System.out);
        this.print(pw);
        pw.flush();
    }

    @Override
    public void print(PrintWriter pw) {
        this.print(pw, "");
    }

    protected void print(PrintWriter pw, String indent) {
        String attr_str = "";
        SimpleXMLParserDocumentAttribute[] attrs = this.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            attr_str = attr_str + (i == 0 ? "" : ",") + attrs[i].getName() + "=" + attrs[i].getValue();
        }
        pw.println(indent + this.getName() + ":" + attr_str + " -> " + this.getValue());
        SimpleXMLParserDocumentNode[] kids = this.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            ((SimpleXMLParserDocumentNodeImpl)kids[i]).print(pw, indent + "  ");
        }
    }
}

