/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSChannel;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSChannelImpl;

public class RSSFeedImpl
implements RSSFeed {
    private boolean is_atom;
    private RSSChannel[] channels;

    public RSSFeedImpl(Utilities utilities, URL source_url, ResourceDownloader downloader) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        this(utilities, source_url, downloader.download());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSSFeedImpl(Utilities utilities, URL source_url, InputStream is) throws SimpleXMLParserDocumentException {
        try {
            SimpleXMLParserDocument doc = utilities.getSimpleXMLParserDocumentFactory().create(source_url, is);
            String doc_name = doc.getName();
            this.is_atom = doc_name != null && doc_name.equalsIgnoreCase("feed");
            ArrayList<RSSChannelImpl> chans = new ArrayList<RSSChannelImpl>();
            if (this.is_atom) {
                chans.add(new RSSChannelImpl(doc, true));
            } else {
                SimpleXMLParserDocumentNode[] xml_channels = doc.getChildren();
                for (int i = 0; i < xml_channels.length; ++i) {
                    SimpleXMLParserDocumentNode xml_channel = xml_channels[i];
                    String name = xml_channel.getName().toLowerCase();
                    if (!name.equals("channel")) continue;
                    chans.add(new RSSChannelImpl(xml_channel, false));
                }
            }
            this.channels = new RSSChannel[chans.size()];
            chans.toArray(this.channels);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public boolean isAtomFeed() {
        return this.is_atom;
    }

    @Override
    public RSSChannel[] getChannels() {
        return this.channels;
    }
}

