/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.security;

import com.aelitis.azureus.core.AzureusCore;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.utils.security.CertificateListener;
import org.gudy.azureus2.plugins.utils.security.PasswordListener;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SEPublicKeyImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SESTSConnectionImpl;

public class SESecurityManagerImpl
implements org.gudy.azureus2.plugins.utils.security.SESecurityManager {
    private AzureusCore core;
    private Map password_listeners = new HashMap();
    private Map certificate_listeners = new HashMap();

    public SESecurityManagerImpl(AzureusCore _core) {
        this.core = _core;
    }

    @Override
    public byte[] calculateSHA1(byte[] data_in) {
        if (data_in == null) {
            data_in = new byte[]{};
        }
        SHA1Hasher hasher = new SHA1Hasher();
        return hasher.calculateHash(data_in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithAuthenticator(Authenticator authenticator, Runnable target) {
        try {
            Authenticator.setDefault(authenticator);
            target.run();
        }
        finally {
            SESecurityManager.installAuthenticator();
        }
    }

    @Override
    public void addPasswordListener(final PasswordListener listener) {
        SEPasswordListener sepl = new SEPasswordListener(){

            @Override
            public PasswordAuthentication getAuthentication(String realm, URL tracker) {
                return listener.getAuthentication(realm, tracker);
            }

            @Override
            public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
                listener.setAuthenticationOutcome(realm, tracker, success);
            }

            @Override
            public void clearPasswords() {
            }
        };
        this.password_listeners.put(listener, sepl);
        SESecurityManager.addPasswordListener(sepl);
    }

    @Override
    public void removePasswordListener(PasswordListener listener) {
        SEPasswordListener sepl = (SEPasswordListener)this.password_listeners.get(listener);
        if (sepl != null) {
            SESecurityManager.removePasswordListener(sepl);
        }
    }

    @Override
    public void addCertificateListener(final CertificateListener listener) {
        SECertificateListener sepl = new SECertificateListener(){

            @Override
            public boolean trustCertificate(String resource, X509Certificate cert) {
                return listener.trustCertificate(resource, cert);
            }
        };
        this.certificate_listeners.put(listener, sepl);
        SESecurityManager.addCertificateListener(sepl);
    }

    @Override
    public void removeCertificateListener(CertificateListener listener) {
        SECertificateListener sepl = (SECertificateListener)this.certificate_listeners.get(listener);
        if (sepl != null) {
            SESecurityManager.removeCertificateListener(sepl);
        }
    }

    @Override
    public SSLSocketFactory installServerCertificate(URL url) {
        return SESecurityManager.installServerCertificates(url);
    }

    @Override
    public KeyStore getKeyStore() throws Exception {
        return SESecurityManager.getKeyStore();
    }

    @Override
    public KeyStore getTrustStore() throws Exception {
        return SESecurityManager.getTrustStore();
    }

    @Override
    public Certificate createSelfSignedCertificate(String alias, String cert_dn, int strength) throws Exception {
        return SESecurityManager.createSelfSignedCertificate(alias, cert_dn, strength);
    }

    @Override
    public byte[] getIdentity() {
        return this.core.getCryptoManager().getSecureID();
    }

    @Override
    public SEPublicKey getPublicKey(int key_type, String reason_resource) throws Exception {
        byte[] encoded = this.core.getCryptoManager().getECCHandler().getPublicKey(reason_resource);
        return new SEPublicKeyImpl(key_type, encoded);
    }

    @Override
    public SEPublicKey decodePublicKey(byte[] encoded) {
        return SEPublicKeyImpl.decode(encoded);
    }

    @Override
    public GenericMessageConnection getSTSConnection(GenericMessageConnection connection, SEPublicKey my_public_key, SEPublicKeyLocator key_locator, String reason_resource, int block_crypto) throws Exception {
        return new SESTSConnectionImpl(this.core, (GenericMessageConnectionImpl)connection, my_public_key, key_locator, reason_resource, block_crypto);
    }
}

