/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.security;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.security.CryptoManagerException;
import com.aelitis.azureus.core.security.CryptoSTSEngine;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnectionListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SEPublicKeyImpl;

public class SESTSConnectionImpl
implements GenericMessageConnection {
    private static final int CRYPTO_SETUP_TIMEOUT = 60000;
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final byte[] AES_IV1 = new byte[]{21, -32, 107, 126, -104, 89, -28, -89, 52, 102, -83, 72, 53, -30, -48, 36};
    private static final byte[] AES_IV2 = new byte[]{-60, -17, 6, 60, -104, 35, -24, -76, 38, 88, -82, -71, 44, 36, -74, 17};
    private final int AES_KEY_SIZE_BYTES = AES_IV1.length;
    private static long last_incoming_sts_create;
    private static List connections;
    private static final int BLOOM_RECREATE = 30000;
    private static final int BLOOM_INCREASE = 500;
    private static BloomFilter generate_bloom;
    private static long generate_bloom_create_time;
    private AzureusCore core;
    private GenericMessageConnectionImpl connection;
    private SEPublicKey my_public_key;
    private SEPublicKeyLocator key_locator;
    private String reason;
    private int block_crypto;
    private long create_time;
    private CryptoSTSEngine sts_engine;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private boolean sent_keys;
    private boolean sent_auth;
    private PooledByteBuffer pending_message;
    private AESemaphore crypto_complete = new AESemaphore("SESTSConnection:send");
    private Cipher outgoing_cipher;
    private Cipher incoming_cipher;
    private volatile boolean failed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SESTSConnectionImpl(AzureusCore _core, GenericMessageConnectionImpl _connection, SEPublicKey _my_public_key, SEPublicKeyLocator _key_locator, String _reason, int _block_crypto) throws Exception {
        this.core = _core;
        this.connection = _connection;
        this.my_public_key = _my_public_key;
        this.key_locator = _key_locator;
        this.reason = _reason;
        this.block_crypto = _block_crypto;
        this.create_time = SystemTime.getCurrentTime();
        List list = connections;
        synchronized (list) {
            connections.add(this);
        }
        if (this.connection.isIncoming()) {
            SESTSConnectionImpl.rateLimit(this.connection.getEndpoint().getNotionalAddress());
        }
        this.sts_engine = this.core.getCryptoManager().getECCHandler().getSTSEngine(this.reason);
        this.connection.addListener(new GenericMessageConnectionListener(){

            @Override
            public void connected(GenericMessageConnection connection) {
                SESTSConnectionImpl.this.reportConnected();
            }

            @Override
            public void receive(GenericMessageConnection connection, PooledByteBuffer message) throws MessageException {
                SESTSConnectionImpl.this.receive(message);
            }

            @Override
            public void failed(GenericMessageConnection connection, Throwable error) throws MessageException {
                SESTSConnectionImpl.this.reportFailed(error);
            }
        });
    }

    protected int getConnectMethodCount() {
        return this.connection.getConnectMethodCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void rateLimit(InetSocketAddress originator) throws Exception {
        Class<SESTSConnectionImpl> clazz = SESTSConnectionImpl.class;
        synchronized (SESTSConnectionImpl.class) {
            int hit_count = generate_bloom.add(AddressUtils.getAddressBytes(originator));
            long now = SystemTime.getCurrentTime();
            if (generate_bloom.getSize() / generate_bloom.getEntryCount() < 10) {
                generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize() + 500);
                generate_bloom_create_time = now;
                Logger.log(new LogEvent(LOGID, "STS bloom: size increased to " + generate_bloom.getSize()));
            } else if (now < generate_bloom_create_time || now - generate_bloom_create_time > 30000L) {
                generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize());
                generate_bloom_create_time = now;
            }
            if (hit_count >= 15) {
                Logger.log(new LogEvent(LOGID, "STS bloom: too many recent connection attempts from " + originator));
                Debug.out("STS: too many recent connection attempts from " + originator);
                throw new IOException("Too many recent connection attempts (sts)");
            }
            long since_last = now - last_incoming_sts_create;
            long delay = 100L - since_last;
            if (delay > 0L && delay < 100L) {
                try {
                    Logger.log(new LogEvent(LOGID, "STS: too many recent connection attempts, delaying " + delay));
                    Thread.sleep(delay);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            last_incoming_sts_create = now;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public GenericMessageEndpoint getEndpoint() {
        return this.connection.getEndpoint();
    }

    @Override
    public int getMaximumMessageSize() {
        int max = this.connection.getMaximumMessageSize();
        if (this.outgoing_cipher != null) {
            max -= this.outgoing_cipher.getBlockSize();
        }
        return max;
    }

    @Override
    public String getType() {
        String con_type = this.connection.getType();
        if (con_type.length() == 0) {
            return "";
        }
        return "AES " + con_type;
    }

    @Override
    public int getTransportType() {
        return this.connection.getTransportType();
    }

    @Override
    public void addInboundRateLimiter(RateLimiter limiter) {
        this.connection.addInboundRateLimiter(limiter);
    }

    @Override
    public void removeInboundRateLimiter(RateLimiter limiter) {
        this.connection.removeInboundRateLimiter(limiter);
    }

    @Override
    public void addOutboundRateLimiter(RateLimiter limiter) {
        this.connection.addOutboundRateLimiter(limiter);
    }

    @Override
    public void removeOutboundRateLimiter(RateLimiter limiter) {
        this.connection.removeOutboundRateLimiter(limiter);
    }

    @Override
    public void connect() throws MessageException {
        if (this.connection.isIncoming()) {
            this.connection.connect();
        } else {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(32768);
                this.sts_engine.getKeys(buffer);
                buffer.flip();
                this.sent_keys = true;
                this.connection.connect(buffer);
            }
            catch (CryptoManagerException e) {
                throw new MessageException("Failed to get initial keys", e);
            }
        }
    }

    protected void setFailed() {
        this.failed = true;
        try {
            this.cryptoComplete();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(PooledByteBuffer message) throws MessageException {
        try {
            boolean forward = false;
            boolean crypto_completed = false;
            ByteBuffer out_buffer = null;
            SESTSConnectionImpl sESTSConnectionImpl = this;
            synchronized (sESTSConnectionImpl) {
                if (this.crypto_complete.isReleasedForever()) {
                    forward = true;
                } else {
                    ByteBuffer in_buffer = ByteBuffer.wrap(message.toByteArray());
                    message.returnToPool();
                    if (!this.sent_keys) {
                        out_buffer = ByteBuffer.allocate(65536);
                        this.sts_engine.getKeys(out_buffer);
                        this.sent_keys = true;
                        this.sts_engine.putKeys(in_buffer);
                        this.sts_engine.getAuth(out_buffer);
                        this.sent_auth = true;
                    } else if (!this.sent_auth) {
                        out_buffer = ByteBuffer.allocate(65536);
                        this.sts_engine.putKeys(in_buffer);
                        this.sts_engine.getAuth(out_buffer);
                        this.sent_auth = true;
                        this.sts_engine.putAuth(in_buffer);
                        byte[] rem_key = this.sts_engine.getRemotePublicKey();
                        if (!this.key_locator.accept(this, new SEPublicKeyImpl(this.my_public_key.getType(), rem_key))) {
                            throw new MessageException("remote public key not accepted");
                        }
                        this.setupBlockCrypto();
                        if (this.pending_message != null) {
                            byte[] pending_bytes = this.pending_message.toByteArray();
                            int pending_size = pending_bytes.length;
                            if (this.outgoing_cipher != null && (pending_size = (pending_size + this.AES_KEY_SIZE_BYTES - 1) / this.AES_KEY_SIZE_BYTES * this.AES_KEY_SIZE_BYTES) == 0) {
                                pending_size = this.AES_KEY_SIZE_BYTES;
                            }
                            if (out_buffer.remaining() >= pending_size) {
                                if (this.outgoing_cipher != null) {
                                    out_buffer.put(this.outgoing_cipher.doFinal(pending_bytes));
                                } else {
                                    out_buffer.put(pending_bytes);
                                }
                                this.pending_message = null;
                            }
                        }
                        crypto_completed = true;
                    } else {
                        this.sts_engine.putAuth(in_buffer);
                        byte[] rem_key = this.sts_engine.getRemotePublicKey();
                        if (!this.key_locator.accept(this, new SEPublicKeyImpl(this.my_public_key.getType(), rem_key))) {
                            this.connection.closing();
                            throw new MessageException("remote public key not accepted");
                        }
                        this.setupBlockCrypto();
                        crypto_completed = true;
                        if (in_buffer.hasRemaining()) {
                            message = new PooledByteBufferImpl(new DirectByteBuffer(in_buffer.slice()));
                            forward = true;
                        }
                    }
                }
            }
            if (out_buffer != null) {
                out_buffer.flip();
                this.connection.send(new PooledByteBufferImpl(new DirectByteBuffer(out_buffer)));
            }
            if (crypto_completed) {
                this.cryptoComplete();
            }
            if (forward) {
                this.receiveContent(message);
            }
        }
        catch (Throwable e) {
            this.reportFailed(e);
            if (e instanceof MessageException) {
                throw (MessageException)e;
            }
            throw new MessageException("Receive failed", e);
        }
    }

    protected void setupBlockCrypto() throws MessageException {
        if (!this.failed) {
            if (this.block_crypto == 1) {
                return;
            }
            try {
                byte[] shared_secret = this.sts_engine.getSharedSecret();
                SecretKeySpec secret_key_spec1 = new SecretKeySpec(shared_secret, 0, 16, "AES");
                SecretKeySpec secret_key_spec2 = new SecretKeySpec(shared_secret, 8, 16, "AES");
                IvParameterSpec param_spec1 = new IvParameterSpec(AES_IV1);
                IvParameterSpec param_spec2 = new IvParameterSpec(AES_IV2);
                Cipher cipher1 = Cipher.getInstance("AES/CBC/PKCS5Padding");
                Cipher cipher2 = Cipher.getInstance("AES/CBC/PKCS5Padding");
                if (this.connection.isIncoming()) {
                    cipher1.init(1, (Key)secret_key_spec1, param_spec1);
                    cipher2.init(2, (Key)secret_key_spec2, param_spec2);
                    this.incoming_cipher = cipher2;
                    this.outgoing_cipher = cipher1;
                } else {
                    cipher1.init(2, (Key)secret_key_spec1, param_spec1);
                    cipher2.init(1, (Key)secret_key_spec2, param_spec2);
                    this.incoming_cipher = cipher1;
                    this.outgoing_cipher = cipher2;
                }
            }
            catch (Throwable e) {
                throw new MessageException("Failed to setup block encryption", e);
            }
        }
    }

    protected void cryptoComplete() throws MessageException {
        this.crypto_complete.releaseForever();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(PooledByteBuffer message) throws MessageException {
        if (this.failed) {
            throw new MessageException("Connection failed");
        }
        try {
            if (this.crypto_complete.isReleasedForever()) {
                this.sendContent(message);
            } else {
                SESTSConnectionImpl sESTSConnectionImpl = this;
                synchronized (sESTSConnectionImpl) {
                    if (this.pending_message == null) {
                        this.pending_message = message;
                    }
                }
            }
            this.crypto_complete.reserve();
            boolean send_it = false;
            SESTSConnectionImpl sESTSConnectionImpl = this;
            synchronized (sESTSConnectionImpl) {
                if (this.pending_message == message) {
                    this.pending_message = null;
                    send_it = true;
                }
            }
            if (send_it) {
                this.sendContent(message);
            }
        }
        catch (Throwable e) {
            this.setFailed();
            if (e instanceof MessageException) {
                throw (MessageException)e;
            }
            throw new MessageException("Send failed", e);
        }
    }

    protected void sendContent(PooledByteBuffer message) throws MessageException {
        block6: {
            if (this.outgoing_cipher != null) {
                try {
                    byte[] plain = message.toByteArray();
                    byte[] enc = this.outgoing_cipher.doFinal(plain);
                    PooledByteBufferImpl temp = new PooledByteBufferImpl(enc);
                    try {
                        this.connection.send(temp);
                        message.returnToPool();
                        break block6;
                    }
                    catch (Throwable e) {
                        temp.returnToPool();
                        throw e;
                    }
                }
                catch (Throwable e) {
                    throw new MessageException("Failed to encrypt data", e);
                }
            }
            if (this.block_crypto != 1) {
                this.connection.close();
                throw new MessageException("Crypto isn't setup");
            }
            this.connection.send(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveContent(PooledByteBuffer message) throws MessageException {
        boolean buffer_handled = false;
        try {
            if (this.incoming_cipher != null) {
                try {
                    byte[] enc = message.toByteArray();
                    byte[] plain = this.incoming_cipher.doFinal(enc);
                    PooledByteBufferImpl temp = new PooledByteBufferImpl(plain);
                    message.returnToPool();
                    buffer_handled = true;
                    message = temp;
                }
                catch (Throwable e) {
                    throw new MessageException("Failed to decrypt data", e);
                }
            } else if (this.block_crypto != 1) {
                throw new MessageException("Crypto isn't setup");
            }
            List listeners_ref = this.listeners.getList();
            MessageException last_error = null;
            for (int i = 0; i < listeners_ref.size(); ++i) {
                PooledByteBuffer message_to_deliver = i == 0 ? message : new PooledByteBufferImpl(message.toByteArray());
                try {
                    ((GenericMessageConnectionListener)listeners_ref.get(i)).receive(this, message_to_deliver);
                    if (message_to_deliver != message) continue;
                    buffer_handled = true;
                    continue;
                }
                catch (Throwable e) {
                    message_to_deliver.returnToPool();
                    if (message_to_deliver == message) {
                        buffer_handled = true;
                    }
                    last_error = e instanceof MessageException ? (MessageException)e : new MessageException("Failed to process message", e);
                }
            }
            if (last_error != null) {
                throw last_error;
            }
        }
        finally {
            if (!buffer_handled) {
                message.returnToPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MessageException {
        List list = connections;
        synchronized (list) {
            connections.remove(this);
        }
        this.connection.close();
    }

    protected void reportConnected() {
        new AEThread2("SESTSConnection:connected", true){

            @Override
            public void run() {
                List listeners_ref = SESTSConnectionImpl.this.listeners.getList();
                for (int i = 0; i < listeners_ref.size(); ++i) {
                    try {
                        ((GenericMessageConnectionListener)listeners_ref.get(i)).connected(SESTSConnectionImpl.this);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
    }

    protected void reportFailed(final Throwable error) {
        this.setFailed();
        new AEThread2("SESTSConnection:failed", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List listeners_ref = SESTSConnectionImpl.this.listeners.getList();
                    for (int i = 0; i < listeners_ref.size(); ++i) {
                        try {
                            ((GenericMessageConnectionListener)listeners_ref.get(i)).failed(SESTSConnectionImpl.this, error);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                finally {
                    try {
                        SESTSConnectionImpl.this.close();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
    }

    @Override
    public void addListener(GenericMessageConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(GenericMessageConnectionListener listener) {
        this.listeners.remove(listener);
    }

    static {
        connections = new ArrayList();
        SimpleTimer.addPeriodicEvent("SESTSConnectionTimer", 15000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                ArrayList<SESTSConnectionImpl> to_close = new ArrayList<SESTSConnectionImpl>();
                List list = connections;
                synchronized (list) {
                    for (int i = 0; i < connections.size(); ++i) {
                        SESTSConnectionImpl connection = (SESTSConnectionImpl)connections.get(i);
                        if (connection.crypto_complete.isReleasedForever()) continue;
                        long now = SystemTime.getCurrentTime();
                        if (connection.create_time > now) {
                            connection.create_time = now;
                            continue;
                        }
                        int time_allowed = connection.getConnectMethodCount() * 60000;
                        if (now - connection.create_time <= (long)time_allowed) continue;
                        to_close.add(connection);
                    }
                }
                for (int i = 0; i < to_close.size(); ++i) {
                    ((SESTSConnectionImpl)to_close.get(i)).reportFailed(new Exception("Timeout during crypto setup"));
                }
            }
        });
        generate_bloom = BloomFilterFactory.createAddRemove4Bit(500);
        generate_bloom_create_time = SystemTime.getCurrentTime();
    }
}

