/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderFileImpl
extends ResourceDownloaderBaseImpl {
    protected boolean cancelled;
    protected File file;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTimeout");
    protected long size = -2L;

    public ResourceDownloaderFileImpl(ResourceDownloaderBaseImpl _parent, File _file) {
        super(_parent);
        this.file = _file;
    }

    @Override
    public String getName() {
        return this.file.toString();
    }

    @Override
    protected void setSize(long size) {
    }

    @Override
    public long getSize() throws ResourceDownloaderException {
        String file_str = this.file.toString();
        int pos = file_str.lastIndexOf(".");
        String file_type = pos != -1 ? file_str.substring(pos + 1) : null;
        this.setProperty("ContentType", HTTPUtils.guessContentTypeFromFileType(file_type));
        return FileUtil.getFileOrDirectorySize(this.file);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.setPropertySupport(name, value);
    }

    @Override
    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderFileImpl c = new ResourceDownloaderFileImpl(this.getParent(), this.file);
        return c;
    }

    @Override
    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof ResourceDownloaderException) {
            throw (ResourceDownloaderException)this.result;
        }
        return (InputStream)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (!this.cancelled) {
                this.informActivity(this.getLogIndent() + (this.file.isDirectory() ? "Processing: " : "Downloading: ") + this.getName());
                final Object parent_tls = TorrentUtils.getTLS();
                AEThread2 t = new AEThread2("ResourceDownloaderTimeout", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object child_tls = TorrentUtils.getTLS();
                        TorrentUtils.setTLS(parent_tls);
                        try {
                            if (ResourceDownloaderFileImpl.this.file.isDirectory()) {
                                ResourceDownloaderFileImpl.this.completed(ResourceDownloaderFileImpl.this, null);
                            } else {
                                ResourceDownloaderFileImpl.this.completed(ResourceDownloaderFileImpl.this, new FileInputStream(ResourceDownloaderFileImpl.this.file));
                            }
                        }
                        catch (Throwable e) {
                            ResourceDownloaderFileImpl.this.failed(ResourceDownloaderFileImpl.this, new ResourceDownloaderException(ResourceDownloaderFileImpl.this, "Failed to read file", e));
                            Debug.printStackTrace(e);
                        }
                        finally {
                            TorrentUtils.setTLS(child_tls);
                        }
                    }
                };
                t.start();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void cancel() {
        this.cancel(new ResourceDownloaderCancelledException(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(ResourceDownloaderException reason) {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = reason;
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        if (this.informComplete(data)) {
            this.result = data;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.done_sem.release();
        this.informFailed(e);
    }
}

