/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.update.UpdateManagerVerificationListener;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateInstallerImpl;

public class UpdateManagerImpl
implements UpdateManager,
UpdateCheckInstanceListener {
    private static UpdateManagerImpl singleton;
    private AzureusCore azureus_core;
    private List<UpdateCheckInstanceImpl> checkers = new ArrayList<UpdateCheckInstanceImpl>();
    private List<UpdatableComponentImpl> components = new ArrayList<UpdatableComponentImpl>();
    private List listeners = new ArrayList();
    private List verification_listeners = new ArrayList();
    private List<UpdateInstaller> installers = new ArrayList<UpdateInstaller>();
    protected AEMonitor this_mon = new AEMonitor("UpdateManager");

    public static UpdateManager getSingleton(AzureusCore core) {
        if (singleton == null) {
            singleton = new UpdateManagerImpl(core);
        }
        return singleton;
    }

    protected UpdateManagerImpl(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        UpdateInstallerImpl.checkForFailedInstalls(this);
        try {
            PlatformManagerFactory.getPlatformManager();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected AzureusCore getCore() {
        return this.azureus_core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUpdatableComponent(UpdatableComponent component, boolean mandatory) {
        try {
            this.this_mon.enter();
            this.components.add(new UpdatableComponentImpl(component, mandatory));
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCheckInstance[] getCheckInstances() {
        try {
            this.this_mon.enter();
            UpdateCheckInstance[] updateCheckInstanceArray = this.checkers.toArray(new UpdateCheckInstance[this.checkers.size()]);
            return updateCheckInstanceArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public UpdateCheckInstance createUpdateCheckInstance() {
        return this.createUpdateCheckInstance(2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCheckInstance createUpdateCheckInstance(int type, String name) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] comps = new UpdatableComponentImpl[this.components.size()];
            this.components.toArray(comps);
            UpdateCheckInstanceImpl res = new UpdateCheckInstanceImpl(this, type, name, comps);
            this.checkers.add(res);
            res.addListener(this);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(res);
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl = res;
            return updateCheckInstanceImpl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public UpdateCheckInstanceImpl createEmptyUpdateCheckInstance(int type, String name) {
        return this.createEmptyUpdateCheckInstance(type, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCheckInstanceImpl createEmptyUpdateCheckInstance(int type, String name, boolean low_noise) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] comps = new UpdatableComponentImpl[]{};
            UpdateCheckInstanceImpl res = new UpdateCheckInstanceImpl(this, type, name, comps);
            res.setLowNoise(low_noise);
            this.checkers.add(res);
            res.addListener(this);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(res);
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl = res;
            return updateCheckInstanceImpl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public UpdateInstaller createInstaller() throws UpdateException {
        UpdateInstallerImpl installer = new UpdateInstallerImpl(this);
        this.installers.add(installer);
        return installer;
    }

    @Override
    public UpdateInstaller[] getInstallers() {
        UpdateInstaller[] res = new UpdateInstaller[this.installers.size()];
        this.installers.toArray(res);
        return res;
    }

    @Override
    public void cancelled(UpdateCheckInstance instance) {
        this.complete(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(UpdateCheckInstance instance) {
        try {
            this.this_mon.enter();
            this.checkers.remove(instance);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removeInstaller(UpdateInstaller installer) {
        this.installers.remove(installer);
    }

    @Override
    public String getInstallDir() {
        String str = SystemProperties.getApplicationPath();
        if (str.endsWith(File.separator)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public String getUserDir() {
        String str = SystemProperties.getUserPath();
        if (str.endsWith(File.separator)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public void restart() throws UpdateException {
        this.applyUpdates(true);
    }

    @Override
    public void applyUpdates(boolean restart_after) throws UpdateException {
        try {
            if (restart_after) {
                this.azureus_core.requestRestart();
            } else {
                this.azureus_core.requestStop();
            }
        }
        catch (Throwable e) {
            throw new UpdateException("UpdateManager:applyUpdates fails", e);
        }
    }

    /*
     * Exception decompiling
     */
    public InputStream verifyData(Update update, InputStream is, boolean force) throws UpdateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 18[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addVerificationListener(UpdateManagerVerificationListener l) {
        this.verification_listeners.add(l);
    }

    @Override
    public void removeVerificationListener(UpdateManagerVerificationListener l) {
        this.verification_listeners.add(l);
    }

    @Override
    public void addListener(UpdateManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(UpdateManagerListener l) {
        this.listeners.remove(l);
    }
}

